/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.MissionEndRewardCase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardForMissionEnd;
import java.util.Hashtable;

public class RewardForMissionEndImplementation
extends RewardBase
implements IRewardProducer {
    private RewardForMissionEnd params = null;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof RewardForMissionEnd)) {
            return false;
        }
        this.params = (RewardForMissionEnd)params;
        return true;
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
        try {
            Hashtable<String, Object> properties = MalmoMod.getPropertiesForCurrentThread();
            if (properties.containsKey("QuitCode")) {
                float reward_value = this.parseQuitCode((String)properties.get("QuitCode"));
                reward.add(this.params.getDimension(), reward_value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        try {
            if (MalmoMod.getPropertiesForCurrentThread().containsKey("QuitCode")) {
                MalmoMod.getPropertiesForCurrentThread().remove("QuitCode");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get properties.");
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    private float parseQuitCode(String qc) {
        float reward = 0.0f;
        if (qc != null && !qc.isEmpty() && this.params != null) {
            String[] codes;
            for (String s : codes = qc.split(";")) {
                for (MissionEndRewardCase merc : this.params.getReward()) {
                    if (!merc.getDescription().equalsIgnoreCase(s)) continue;
                    float this_reward = merc.getReward().floatValue();
                    float adjusted_reward = this.adjustAndDistributeReward(this_reward, this.params.getDimension(), merc.getDistribution());
                    reward += adjusted_reward;
                }
                if (!s.equals("MALMO_AGENT_DIED")) continue;
                float this_reward = this.params.getRewardForDeath().floatValue();
                float adjusted_reward = this.adjustAndDistributeReward(this_reward, this.params.getDimension(), this.params.getRewardForDeathDistribution());
                reward += adjusted_reward;
            }
        }
        return reward;
    }
}

