/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.PointWithReward;
import com.microsoft.Malmo.Schemas.Pos;
import com.microsoft.Malmo.Schemas.RewardForReachingPosition;
import com.microsoft.Malmo.Utils.PositionHelper;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;

public class RewardForReachingPositionImplementation
extends RewardBase
implements IRewardProducer {
    Pos targetPos;
    float reward;
    float tolerance;
    boolean oneShot;
    boolean fired = false;
    List<PointWithReward> rewardPoints;
    private RewardForReachingPosition params;

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof RewardForReachingPosition)) {
            return false;
        }
        this.params = (RewardForReachingPosition)params;
        this.rewardPoints = this.params.getMarker();
        return true;
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
        if (missionInit == null || Minecraft.getMinecraft().player == null) {
            return;
        }
        if (this.rewardPoints != null) {
            Iterator<PointWithReward> goalIterator = this.rewardPoints.iterator();
            while (goalIterator.hasNext()) {
                PointWithReward goal = goalIterator.next();
                boolean oneShot = goal.isOneshot();
                float reward_value = goal.getReward().floatValue();
                float tolerance = goal.getTolerance().floatValue();
                float distance = PositionHelper.calcDistanceFromPlayerToPosition(Minecraft.getMinecraft().player, goal);
                if (!(distance <= tolerance)) continue;
                float adjusted_reward = this.adjustAndDistributeReward(reward_value, this.params.getDimension(), goal.getDistribution());
                reward.add(this.params.getDimension(), adjusted_reward);
                if (!oneShot) continue;
                goalIterator.remove();
            }
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }
}

