/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.CommandGroup;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardForSendingCommand;

public class RewardForSendingCommandImplementation
extends RewardBase
implements IRewardProducer {
    protected float rewardPerCommand;
    protected Integer commandTally = 0;
    private RewardForSendingCommand params;

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof RewardForSendingCommand)) {
            return false;
        }
        this.params = (RewardForSendingCommand)params;
        this.rewardPerCommand = this.params.getReward().floatValue();
        return true;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        MissionBehaviour mb = this.parentBehaviour();
        ICommandHandler oldch = mb.commandHandler;
        CommandGroup newch = new CommandGroup(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
                boolean handled = super.onExecute(verb, parameter, missionInit);
                if (handled) {
                    Integer n = RewardForSendingCommandImplementation.this.commandTally;
                    synchronized (n) {
                        RewardForSendingCommandImplementation rewardForSendingCommandImplementation = RewardForSendingCommandImplementation.this;
                        Integer n2 = rewardForSendingCommandImplementation.commandTally;
                        Integer n3 = rewardForSendingCommandImplementation.commandTally = Integer.valueOf(rewardForSendingCommandImplementation.commandTally + 1);
                    }
                }
                return handled;
            }
        };
        newch.setOverriding(oldch != null ? oldch.isOverriding() : true);
        if (oldch != null) {
            newch.addCommandHandler(oldch);
        }
        mb.commandHandler = newch;
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
        Integer n = this.commandTally;
        synchronized (n) {
            if (this.commandTally > 0) {
                float reward_value = this.rewardPerCommand * (float)this.commandTally.intValue();
                float adjusted_reward = this.adjustAndDistributeReward(reward_value, this.params.getDimension(), this.params.getDistribution());
                reward.add(this.params.getDimension(), adjusted_reward);
                this.commandTally = 0;
            }
        }
    }
}

