/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IVideoProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.VideoProducer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class VideoProducerImplementation
extends HandlerBase
implements IVideoProducer {
    private VideoProducer videoParams;
    private Framebuffer fbo;
    private FloatBuffer depthBuffer;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof VideoProducer)) {
            return false;
        }
        this.videoParams = (VideoProducer)params;
        return true;
    }

    @Override
    public IVideoProducer.VideoType getVideoType() {
        return IVideoProducer.VideoType.VIDEO;
    }

    @Override
    public void getFrame(MissionInit missionInit, ByteBuffer buffer) {
        float range;
        float maxval;
        float minval;
        if (!this.videoParams.isWantDepth()) {
            this.getRGBFrame(buffer);
            return;
        }
        int width = this.videoParams.getWidth();
        int height = this.videoParams.getHeight();
        GL30.glBindFramebuffer((int)36008, (int)Minecraft.getMinecraft().getFramebuffer().framebufferObject);
        GL30.glBindFramebuffer((int)36009, (int)this.fbo.framebufferObject);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)Minecraft.getMinecraft().getFramebuffer().framebufferWidth, (int)Minecraft.getMinecraft().getFramebuffer().framebufferHeight, (int)0, (int)0, (int)width, (int)height, (int)16640, (int)9728);
        this.fbo.bindFramebuffer(true);
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6402, (int)5126, (FloatBuffer)this.depthBuffer);
        this.fbo.unbindFramebuffer();
        if (this.videoParams.getDepthScaling() == null || this.videoParams.getDepthScaling().isAutoscale()) {
            minval = 1.0f;
            maxval = 0.0f;
            for (int i = 0; i < width * height; ++i) {
                float f = this.depthBuffer.get(i);
                if (f < minval) {
                    minval = f;
                }
                if (!(f > maxval)) continue;
                maxval = f;
            }
        } else {
            minval = this.videoParams.getDepthScaling().getMin().floatValue();
            if (minval > (maxval = this.videoParams.getDepthScaling().getMax().floatValue())) {
                float t = minval;
                minval = maxval;
                maxval = t;
            }
        }
        if ((double)(range = maxval - minval) < 1.0E-6) {
            range = 1.0E-6f;
        }
        float scale = 255.0f / range;
        for (int i = 0; i < width * height; ++i) {
            float f = this.depthBuffer.get(i);
            f = f < minval ? minval : (f > maxval ? maxval : f);
            f -= minval;
            buffer.put(i * 4 + 3, (byte)(f *= scale));
        }
        this.depthBuffer.clear();
    }

    @Override
    public int getWidth() {
        return this.videoParams.getWidth();
    }

    @Override
    public int getHeight() {
        return this.videoParams.getHeight();
    }

    @Override
    public int getRequiredBufferSize() {
        return this.videoParams.getWidth() * this.videoParams.getHeight() * (this.videoParams.isWantDepth() ? 4 : 3);
    }

    private void getRGBFrame(ByteBuffer buffer) {
        int format = 6407;
        int width = this.videoParams.getWidth();
        int height = this.videoParams.getHeight();
        this.fbo.bindFramebuffer(true);
        Minecraft.getMinecraft().getFramebuffer().framebufferRenderExt(width, height, true);
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6407, (int)5121, (ByteBuffer)buffer);
        this.fbo.unbindFramebuffer();
        GlStateManager.enableDepth();
        Minecraft.getMinecraft().getFramebuffer().bindFramebuffer(true);
    }

    @Override
    public void prepare(MissionInit missionInit) {
        this.fbo = new Framebuffer(this.videoParams.getWidth(), this.videoParams.getHeight(), true);
        if (this.videoParams.isWantDepth()) {
            this.depthBuffer = BufferUtils.createFloatBuffer((int)(this.videoParams.getWidth() * this.videoParams.getHeight()));
        }
        Minecraft.getMinecraft().gameSettings.thirdPersonView = this.videoParams.getViewpoint();
    }

    @Override
    public void cleanup() {
        this.fbo.deleteFramebuffer();
    }
}

