/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldDecorator;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;

public class WorldFromComposite
extends HandlerBase
implements IWorldDecorator {
    private ArrayList<IWorldDecorator> builders = new ArrayList();

    public void addBuilder(IWorldDecorator builder) {
        this.builders.add(builder);
    }

    @Override
    public void buildOnWorld(MissionInit missionInit, World world) throws IWorldDecorator.DecoratorException {
        for (IWorldDecorator builder : this.builders) {
            builder.buildOnWorld(missionInit, world);
        }
    }

    @Override
    public void update(World world) {
        for (IWorldDecorator builder : this.builders) {
            builder.update(world);
        }
    }

    @Override
    public boolean getExtraAgentHandlersAndData(List<Object> handlers, Map<String, String> data) {
        boolean added = false;
        for (IWorldDecorator builder : this.builders) {
            added |= builder.getExtraAgentHandlersAndData(handlers, data);
        }
        return added;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        for (IWorldDecorator builder : this.builders) {
            builder.prepare(missionInit);
        }
    }

    @Override
    public void cleanup() {
        for (IWorldDecorator builder : this.builders) {
            builder.cleanup();
        }
    }

    @Override
    public boolean targetedUpdate(String nextAgentName) {
        for (IWorldDecorator builder : this.builders) {
            if (!builder.targetedUpdate(nextAgentName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getTurnParticipants(ArrayList<String> participants, ArrayList<Integer> participantSlots) {
        for (IWorldDecorator builder : this.builders) {
            builder.getTurnParticipants(participants, participantSlots);
        }
    }

    public boolean isFixed() {
        return false;
    }
}

