/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Mixins;

import com.microsoft.Malmo.Utils.TimeHelper;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetworkManager;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Timer;
import net.minecraft.util.Util;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.Display;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraftGameloop {
    @Shadow
    public Profiler mcProfiler;
    @Shadow
    private SoundHandler mcSoundHandler;
    @Shadow
    public boolean isGamePaused;
    @Shadow
    public WorldClient world;
    @Shadow
    public Timer timer;
    @Shadow
    public Queue<FutureTask<?>> scheduledTasks;
    @Shadow
    public EntityPlayerSP player;
    @Shadow
    private Framebuffer framebufferMc;
    @Shadow
    public boolean skipRenderWorld;
    @Shadow
    public EntityRenderer entityRenderer;
    @Shadow
    public GameSettings gameSettings;
    @Shadow
    long prevFrameTime;
    @Shadow
    public GuiAchievement guiAchievement;
    @Shadow
    int displayWidth;
    @Shadow
    public PlayerControllerMP playerController;
    @Shadow
    private NetworkManager myNetworkManager;
    @Shadow
    int displayHeight;
    @Shadow
    private int fpsCounter;
    @Shadow
    public GuiScreen currentScreen;
    @Shadow
    private IntegratedServer theIntegratedServer;
    @Shadow
    public FrameTimer frameTimer;
    @Shadow
    long startNanoTime;
    @Shadow
    private long debugUpdateTime;
    @Shadow
    public String debug;
    @Shadow
    public Snooper usageSnooper;
    private int numTicksPassed = 0;

    @Shadow
    public abstract void shutdown();

    @Shadow
    public abstract void runTick() throws IOException;

    @Shadow
    public abstract void checkGLError(String var1);

    @Shadow
    public abstract void displayDebugInfo(long var1);

    @Shadow
    public abstract void updateDisplay();

    @Shadow
    public abstract boolean isSingleplayer();

    @Shadow
    public abstract int getLimitFramerate();

    @Shadow
    public abstract boolean isFramerateLimitBelowMax();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGameLoop() throws IOException {
        long i = System.nanoTime();
        this.mcProfiler.startSection("root");
        if (Display.isCreated() && Display.isCloseRequested()) {
            this.shutdown();
        }
        float f = this.timer.renderPartialTicks;
        if (this.isGamePaused && this.world != null) {
            this.timer.updateTimer();
            this.timer.renderPartialTicks = f;
        } else {
            this.timer.updateTimer();
        }
        this.mcProfiler.startSection("scheduledExecutables");
        Queue<FutureTask<?>> queue = this.scheduledTasks;
        synchronized (queue) {
            while (!this.scheduledTasks.isEmpty()) {
                Util.runTask(this.scheduledTasks.poll(), (Logger)Minecraft.LOGGER);
            }
        }
        this.mcProfiler.endSection();
        long l = System.nanoTime();
        if (TimeHelper.SyncManager.isSynchronous().booleanValue() && TimeHelper.SyncManager.isServerRunning().booleanValue() && !this.isGamePaused || TimeHelper.SyncManager.shouldFlush().booleanValue()) {
            this.mcProfiler.startSection("waitForTick");
            TimeHelper.SyncManager.debugLog("[Client] wait for tick");
            while (!TimeHelper.SyncManager.shouldClientTick().booleanValue()) {
                Thread.yield();
            }
            this.mcProfiler.endSection();
            this.mcProfiler.startSection("syncTickEventPre");
            TimeHelper.SyncManager.debugLog("[Client] client tick.");
            MinecraftForge.EVENT_BUS.post((Event)new TimeHelper.SyncTickEvent(TickEvent.Phase.START));
            this.mcProfiler.endSection();
            this.mcProfiler.startSection("clientTick");
            if (TimeHelper.SyncManager.shouldClientTick().booleanValue()) {
                this.runTick();
                TimeHelper.SyncManager.completeClientTick();
            } else {
                this.timer.renderPartialTicks = f;
            }
            this.mcProfiler.endSection();
            this.mcProfiler.startSection("serverTick");
            TimeHelper.SyncManager.debugLog("[Client] wait for server");
            while (!TimeHelper.SyncManager.shouldRenderTick().booleanValue()) {
                Thread.yield();
            }
            this.mcProfiler.endSection();
        } else {
            for (int j = 0; j < this.timer.elapsedTicks; ++j) {
                this.runTick();
            }
        }
        this.mcProfiler.startSection("preRenderErrors");
        long i1 = System.nanoTime() - l;
        this.checkGLError("Pre render");
        this.mcProfiler.endSection();
        this.mcProfiler.startSection("sound");
        this.mcSoundHandler.setListener((EntityPlayer)this.player, this.timer.renderPartialTicks);
        this.mcProfiler.endSection();
        this.mcProfiler.startSection("render");
        GlStateManager.pushMatrix();
        GlStateManager.clear((int)16640);
        this.framebufferMc.bindFramebuffer(true);
        this.mcProfiler.startSection("display");
        GlStateManager.enableTexture2D();
        this.mcProfiler.endSection();
        if (!this.skipRenderWorld) {
            FMLCommonHandler.instance().onRenderTickStart(this.timer.renderPartialTicks);
            this.mcProfiler.endStartSection("gameRenderer");
            this.entityRenderer.updateCameraAndRender(this.timer.renderPartialTicks, i);
            this.mcProfiler.endSection();
            FMLCommonHandler.instance().onRenderTickEnd(this.timer.renderPartialTicks);
        }
        this.mcProfiler.endSection();
        if (this.gameSettings.showDebugInfo && this.gameSettings.showDebugProfilerChart && !this.gameSettings.hideGUI) {
            if (!this.mcProfiler.profilingEnabled) {
                this.mcProfiler.clearProfiling();
            }
            this.mcProfiler.profilingEnabled = true;
            this.displayDebugInfo(i1);
        } else {
            this.mcProfiler.profilingEnabled = false;
            this.prevFrameTime = System.nanoTime();
        }
        this.guiAchievement.updateAchievementWindow();
        this.framebufferMc.unbindFramebuffer();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        this.framebufferMc.framebufferRender(this.displayWidth, this.displayHeight);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        this.entityRenderer.renderStreamIndicator(this.timer.renderPartialTicks);
        GlStateManager.popMatrix();
        this.mcProfiler.startSection("root");
        this.updateDisplay();
        if (TimeHelper.SyncManager.isSynchronous().booleanValue() && TimeHelper.SyncManager.isServerRunning().booleanValue() && TimeHelper.SyncManager.shouldRenderTick().booleanValue() && TimeHelper.SyncManager.isTicking().booleanValue() || TimeHelper.SyncManager.shouldFlush().booleanValue()) {
            TimeHelper.SyncManager.debugLog("[Client] complete tick.");
            TimeHelper.SyncManager.completeTick();
            this.mcProfiler.startSection("syncTickEventPost");
            MinecraftForge.EVENT_BUS.post((Event)new TimeHelper.SyncTickEvent(TickEvent.Phase.END));
            this.mcProfiler.endSection();
        }
        Thread.yield();
        this.checkGLError("Post render");
        ++this.fpsCounter;
        this.isGamePaused = this.isSingleplayer() && this.currentScreen != null && this.currentScreen.doesGuiPauseGame() && !this.theIntegratedServer.getPublic();
        long k = System.nanoTime();
        this.frameTimer.addFrame(k - this.startNanoTime);
        this.startNanoTime = k;
        while (Minecraft.getSystemTime() >= this.debugUpdateTime + 1000L) {
            Minecraft.debugFPS = this.fpsCounter;
            Object[] objectArray = new Object[8];
            objectArray[0] = Minecraft.debugFPS;
            objectArray[1] = RenderChunk.renderChunksUpdated;
            objectArray[2] = RenderChunk.renderChunksUpdated == 1 ? "" : "s";
            objectArray[3] = (float)this.gameSettings.limitFramerate == GameSettings.Options.FRAMERATE_LIMIT.getValueMax() ? "inf" : Integer.valueOf(this.gameSettings.limitFramerate);
            objectArray[4] = this.gameSettings.enableVsync ? " vsync" : "";
            Object object = objectArray[5] = this.gameSettings.fancyGraphics ? "" : " fast";
            objectArray[6] = this.gameSettings.clouds == 0 ? "" : (this.gameSettings.clouds == 1 ? " fast-clouds" : " fancy-clouds");
            objectArray[7] = OpenGlHelper.useVbo() ? " vbo" : "";
            this.debug = String.format("%d fps (%d chunk update%s) T: %s%s%s%s%s", objectArray);
            RenderChunk.renderChunksUpdated = 0;
            this.debugUpdateTime += 1000L;
            this.fpsCounter = 0;
            this.usageSnooper.addMemoryStatsToSnooper();
            if (this.usageSnooper.isSnooperRunning()) continue;
            this.usageSnooper.startSnooper();
        }
        if (this.isFramerateLimitBelowMax()) {
            this.mcProfiler.startSection("fpslimit_wait");
            Display.sync((int)this.getLimitFramerate());
            this.mcProfiler.endSection();
        }
        this.mcProfiler.endSection();
    }
}

