/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Mixins;

import com.microsoft.Malmo.Utils.TimeHelper;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.crash.CrashReport;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServerRun {
    @Shadow
    private long currentTime;
    @Shadow
    private ServerStatusResponse statusResponse;
    @Shadow
    private boolean serverRunning;
    @Shadow
    private String motd;
    @Shadow
    private long timeOfLastWarning;
    @Shadow
    private static final Logger LOG = LogManager.getLogger();
    @Shadow
    private boolean serverIsRunning;
    @Shadow
    private boolean serverStopped;
    @Shadow
    public WorldServer[] worlds;

    @Shadow
    public abstract boolean init() throws IOException;

    @Shadow
    public abstract void applyServerIconToResponse(ServerStatusResponse var1);

    @Shadow
    public abstract void tick();

    @Shadow
    public abstract void finalTick(CrashReport var1);

    @Shadow
    public abstract CrashReport addServerInfoToCrashReport(CrashReport var1);

    @Shadow
    public abstract File getDataDirectory();

    @Shadow
    public abstract void stopServer();

    @Shadow
    public abstract void systemExitNow();

    @Shadow
    public abstract void initiateShutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long i;
        try {
            if (!this.init()) {
                FMLCommonHandler.instance().expectServerStopped();
                this.finalTick(null);
                return;
            }
            FMLCommonHandler.instance().handleServerStarted();
            this.currentTime = MinecraftServer.getCurrentTimeMillis();
            i = 0L;
            TimeHelper.SyncManager.numTicks = 0L;
            this.statusResponse.setServerDescription((ITextComponent)new TextComponentString(this.motd));
            this.statusResponse.setVersion(new ServerStatusResponse.Version("1.11.2", 316));
            this.applyServerIconToResponse(this.statusResponse);
        }
        catch (StartupQuery.AbortedException e) {
            FMLCommonHandler.instance().expectServerStopped();
            return;
        }
        catch (Throwable throwable1) {
            LOG.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = null;
            crashreport = throwable1 instanceof ReportedException ? this.addServerInfoToCrashReport(((ReportedException)throwable1).getCrashReport()) : this.addServerInfoToCrashReport(new CrashReport("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.getDataDirectory(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.saveToFile(file1)) {
                LOG.error("This crash report has been saved to: {}", new Object[]{file1.getAbsolutePath()});
            } else {
                LOG.error("We were unable to save this crash report to disk.");
            }
            FMLCommonHandler.instance().expectServerStopped();
            this.finalTick(crashreport);
            return;
        }
        finally {
            TimeHelper.SyncManager.serverFinished();
            try {
                this.stopServer();
                this.serverStopped = true;
            }
            catch (Throwable throwable) {
                LOG.error("Exception stopping the server", throwable);
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.serverStopped = true;
                this.systemExitNow();
            }
        }
        while (true) {
            if (!this.serverRunning) {
                FMLCommonHandler.instance().handleServerStopping();
                FMLCommonHandler.instance().expectServerStopped();
                return;
            }
            TimeHelper.SyncManager.setServerRunning();
            long k = MinecraftServer.getCurrentTimeMillis();
            long j = k - this.currentTime;
            if (j > 2000L && this.currentTime - this.timeOfLastWarning >= 15000L) {
                LOG.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{j, j / TimeHelper.serverTickLength});
                j = 2000L;
                this.timeOfLastWarning = this.currentTime;
            }
            if (j < 0L) {
                LOG.warn("Time ran backwards! Did the system time change?");
                j = 0L;
            }
            this.currentTime = k;
            if ((i += j) < 0L) {
                i = 0L;
            }
            if (this.worlds[0].areAllPlayersAsleep()) {
                this.tick();
                i = 0L;
            } else if (TimeHelper.SyncManager.isSynchronous().booleanValue() && TimeHelper.SyncManager.numTicks > 32L) {
                if (TimeHelper.SyncManager.shouldServerTick().booleanValue() && TimeHelper.SyncManager.numTicks > 32L) {
                    TimeHelper.SyncManager.debugLog("Server tick start." + Long.toString(TimeHelper.SyncManager.numTicks));
                    this.tick();
                    TimeHelper.SyncManager.debugLog("Server tick end." + Long.toString(TimeHelper.SyncManager.numTicks));
                    ++TimeHelper.SyncManager.numTicks;
                    TimeHelper.SyncManager.completeServerTick();
                }
            } else {
                TimeHelper.SyncManager.debugLog("Regular ticking ! " + Long.toString(TimeHelper.SyncManager.numTicks));
                while (i > TimeHelper.serverTickLength) {
                    i -= TimeHelper.serverTickLength;
                    if (TimeHelper.isPaused().booleanValue()) continue;
                    ++TimeHelper.SyncManager.numTicks;
                    this.tick();
                }
                Thread.sleep(Math.max(1L, TimeHelper.serverTickLength - i));
            }
            this.serverIsRunning = true;
        }
    }
}

