/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Server;

import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Server.ServerState;
import com.microsoft.Malmo.Server.ServerStateMachine;
import com.microsoft.Malmo.Utils.TimeHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class MalmoModServer {
    private ServerStateMachine stateMachine;
    private TimeHelper.TickRateMonitor serverTickMonitor = new TimeHelper.TickRateMonitor();

    public void init(FMLInitializationEvent event) {
        this.initBusses();
        this.stateMachine = new ServerStateMachine(ServerState.WAITING_FOR_MOD_READY);
    }

    public void init(MissionInit minit) {
        this.initBusses();
        this.stateMachine = new ServerStateMachine(ServerState.WAITING_FOR_MOD_READY, minit);
    }

    public void sendMissionInitDirectToServer(MissionInit minit) {
        this.stateMachine.setMissionInit(minit);
    }

    private void initBusses() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.side == Side.SERVER && ev.phase == TickEvent.Phase.START) {
            this.serverTickMonitor.beat();
        }
    }

    public float getServerTickRate() {
        return this.serverTickMonitor.getEventsPerSecond();
    }
}

