/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Server;

import com.microsoft.Malmo.IState;
import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldDecorator;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.Schemas.AgentSection;
import com.microsoft.Malmo.Schemas.AgentStart;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.EntityTypes;
import com.microsoft.Malmo.Schemas.InventoryObjectType;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ModSettings;
import com.microsoft.Malmo.Schemas.PosAndDirection;
import com.microsoft.Malmo.Schemas.ServerInitialConditions;
import com.microsoft.Malmo.Schemas.ServerSection;
import com.microsoft.Malmo.Server.ServerState;
import com.microsoft.Malmo.StateEpisode;
import com.microsoft.Malmo.StateMachine;
import com.microsoft.Malmo.Utils.EnvironmentHelper;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import com.microsoft.Malmo.Utils.SchemaHelper;
import com.microsoft.Malmo.Utils.ScreenHelper;
import com.microsoft.Malmo.Utils.TimeHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ServerStateMachine
extends StateMachine {
    private MissionInit currentMissionInit = null;
    private MissionInit queuedMissionInit = null;
    private MissionBehaviour missionHandlers = null;
    protected String quitCode = "";
    private ArrayList<String> userConnectionWatchList = new ArrayList();
    private ArrayList<String> userTurnSchedule = new ArrayList();

    protected void clearUserConnectionWatchList() {
        this.userConnectionWatchList.clear();
    }

    protected void clearUserTurnSchedule() {
        this.userTurnSchedule.clear();
    }

    protected String getNextAgentInTurnSchedule(String currentAgent) {
        int i = this.userTurnSchedule.indexOf(currentAgent);
        if (i < 0) {
            return null;
        }
        return this.userTurnSchedule.get(++i % this.userTurnSchedule.size());
    }

    protected void removeFromTurnSchedule(String agent) {
        this.userTurnSchedule.remove(agent);
    }

    protected void addUsernameToWatchList(String username) {
        this.userConnectionWatchList.add(username);
    }

    protected void setUserTurnSchedule(ArrayList<String> schedule) {
        this.userTurnSchedule = schedule;
    }

    protected boolean checkWatchList() {
        String[] connected_users = FMLCommonHandler.instance().getMinecraftServerInstance().getOnlinePlayerNames();
        if (connected_users.length < this.userConnectionWatchList.size()) {
            return false;
        }
        for (String username : this.userConnectionWatchList) {
            boolean bFound = false;
            for (int i = 0; i < connected_users.length && !bFound; ++i) {
                if (!connected_users[i].equals(username)) continue;
                bFound = true;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    protected void initialiseHandlers(MissionInit init) throws Exception {
        this.missionHandlers = MissionBehaviour.createServerHandlersFromMissionInit(init);
    }

    protected MissionBehaviour getHandlers() {
        return this.missionHandlers;
    }

    public void setMissionInit(MissionInit minit) {
        this.queuedMissionInit = minit;
    }

    public ServerStateMachine(ServerState initialState) {
        super(initialState);
        this.initBusses();
    }

    public ServerStateMachine(ServerState initialState, MissionInit minit) {
        super(initialState);
        this.currentMissionInit = minit;
        this.initBusses();
    }

    private void initBusses() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected String getName() {
        return "SERVER";
    }

    @Override
    protected void onPreStateChange(IState toState) {
        String text = "SERVER: " + toState;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("text", text);
        data.put("category", ScreenHelper.TextCategory.TXT_SERVER_STATE.name());
        MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_TEXT, data);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent ev) {
        this.updateState();
    }

    @SubscribeEvent
    public void onGetPotentialSpawns(WorldEvent.PotentialSpawns ps) {
        boolean allowSpawning = false;
        if (this.currentMissionInit() != null && this.currentMissionInit().getMission() != null) {
            ServerInitialConditions sic;
            ServerSection ss = this.currentMissionInit().getMission().getServerSection();
            ServerInitialConditions serverInitialConditions = sic = ss != null ? ss.getServerInitialConditions() : null;
            if (sic != null) {
                boolean bl = allowSpawning = sic.isAllowSpawning() == Boolean.TRUE;
            }
            if (allowSpawning && sic.getAllowedMobs() != null && !sic.getAllowedMobs().isEmpty()) {
                Iterator it = ps.getList().iterator();
                while (it.hasNext()) {
                    Biome.SpawnListEntry sle = (Biome.SpawnListEntry)it.next();
                    EntityEntry entry = EntityRegistry.getEntry((Class)sle.entityClass);
                    String mobName = entry == null ? null : entry.getName();
                    boolean allowed = false;
                    for (EntityTypes mob : sic.getAllowedMobs()) {
                        if (!mob.value().equals(mobName)) continue;
                        allowed = true;
                    }
                    if (allowed) continue;
                    it.remove();
                }
            }
        }
        if (!allowSpawning) {
            ps.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn cs) {
        boolean allowSpawning = false;
        if (this.currentMissionInit() != null && this.currentMissionInit().getMission() != null) {
            ServerInitialConditions sic;
            ServerSection ss = this.currentMissionInit().getMission().getServerSection();
            ServerInitialConditions serverInitialConditions = sic = ss != null ? ss.getServerInitialConditions() : null;
            if (sic != null) {
                boolean bl = allowSpawning = sic.isAllowSpawning() == Boolean.TRUE;
            }
            if (allowSpawning && sic.getAllowedMobs() != null && !sic.getAllowedMobs().isEmpty()) {
                String mobName = EntityList.getEntityString((Entity)cs.getEntity());
                allowSpawning = false;
                for (EntityTypes mob : sic.getAllowedMobs()) {
                    if (!mob.value().equals(mobName)) continue;
                    allowSpawning = true;
                    break;
                }
            }
        }
        if (allowSpawning) {
            cs.setResult(Event.Result.DEFAULT);
        } else {
            cs.setResult(Event.Result.DENY);
        }
    }

    @Override
    protected StateEpisode getStateEpisodeForState(IState state) {
        if (!(state instanceof ServerState)) {
            return null;
        }
        ServerState sstate = (ServerState)state;
        switch (sstate) {
            case WAITING_FOR_MOD_READY: {
                return new InitialiseServerModEpisode(this);
            }
            case DORMANT: {
                return new DormantEpisode(this);
            }
            case BUILDING_WORLD: {
                return new BuildingWorldEpisode(this);
            }
            case WAITING_FOR_AGENTS_TO_ASSEMBLE: {
                return new WaitingForAgentsEpisode(this);
            }
            case RUNNING: {
                return new RunningEpisode(this);
            }
            case WAITING_FOR_AGENTS_TO_QUIT: {
                return new WaitingForAgentsToQuitEpisode(this);
            }
            case ERROR: {
                return new ErrorEpisode(this);
            }
            case CLEAN_UP: {
                return new CleanUpEpisode(this);
            }
            case MISSION_ENDED: {
                return null;
            }
            case MISSION_ABORTED: {
                return null;
            }
        }
        return null;
    }

    protected MissionInit currentMissionInit() {
        return this.currentMissionInit;
    }

    protected boolean hasQueuedMissionInit() {
        return this.queuedMissionInit != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MissionInit releaseQueuedMissionInit() {
        MissionInit minit = null;
        MissionInit missionInit = this.queuedMissionInit;
        synchronized (missionInit) {
            minit = this.queuedMissionInit;
            this.queuedMissionInit = null;
        }
        return minit;
    }

    public class CleanUpEpisode
    extends StateEpisode {
        public CleanUpEpisode(StateMachine machine) {
            super(machine);
        }

        @Override
        protected void execute() {
            ServerStateMachine.this.currentMissionInit = null;
            this.episodeHasCompleted(ServerState.DORMANT);
        }
    }

    public class ErrorEpisode
    extends StateEpisode {
        public ErrorEpisode(StateMachine machine) {
            super(machine);
        }

        @Override
        protected void execute() {
            this.episodeHasCompleted(ServerState.CLEAN_UP);
        }
    }

    public class RunningEpisode
    extends ErrorAwareEpisode {
        ArrayList<String> runningAgents;
        boolean missionHasEnded;
        long tickCount;
        long secondStartTimeMs;

        protected RunningEpisode(ServerStateMachine machine) {
            super(machine);
            this.runningAgents = new ArrayList();
            this.missionHasEnded = false;
            this.tickCount = 0L;
            this.secondStartTimeMs = 0L;
            List<AgentSection> agents = ServerStateMachine.this.currentMissionInit().getMission().getAgentSection();
            if (agents != null && agents.size() > 0) {
                for (AgentSection as : agents) {
                    this.runningAgents.add(as.getName());
                }
            }
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.CLIENT_AGENTFINISHEDMISSION);
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.CLIENT_SHARE_REWARD);
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.CLIENT_TURN_TAKEN);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.CLIENT_AGENTFINISHEDMISSION);
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.CLIENT_SHARE_REWARD);
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.CLIENT_TURN_TAKEN);
        }

        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            super.onMessage(messageType, data);
            if (messageType == MalmoMod.MalmoMessageType.CLIENT_AGENTFINISHEDMISSION) {
                String agentName = data.get("agentname");
                if (agentName != null) {
                    this.runningAgents.remove(agentName);
                    ServerStateMachine.this.removeFromTurnSchedule(agentName);
                }
            } else if (messageType == MalmoMod.MalmoMessageType.CLIENT_SHARE_REWARD) {
                MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_SHARE_REWARD, data);
            } else if (messageType == MalmoMod.MalmoMessageType.CLIENT_TURN_TAKEN) {
                String agentName = data.get("agentname");
                String nextAgentName = ServerStateMachine.this.getNextAgentInTurnSchedule(agentName);
                if (nextAgentName == null) {
                    String error = "ERROR IN TURN SCHEDULER - cannot find the successor to " + agentName;
                    ServerStateMachine.this.saveErrorDetails(error);
                    System.out.println(error);
                    MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_ABORT);
                    this.episodeHasCompleted(ServerState.ERROR);
                } else {
                    boolean handled;
                    PlayerList scoman = FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerList();
                    EntityPlayerMP player = scoman.getPlayerByUsername(nextAgentName);
                    if (player != null) {
                        MalmoMod.network.sendTo((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.SERVER_YOUR_TURN, ""), player);
                    } else if (ServerStateMachine.this.getHandlers().worldDecorator != null && !(handled = ServerStateMachine.this.getHandlers().worldDecorator.targetedUpdate(nextAgentName))) {
                        String error = "ERROR IN TURN SCHEDULER - could not find client for user " + nextAgentName;
                        ServerStateMachine.this.saveErrorDetails(error);
                        System.out.println(error);
                        MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_ABORT);
                        this.episodeHasCompleted(ServerState.ERROR);
                    }
                }
            }
        }

        @Override
        protected void execute() {
            ModSettings modsettings;
            ServerInitialConditions sic;
            ServerSection ss = ServerStateMachine.this.currentMissionInit().getMission().getServerSection();
            ServerInitialConditions serverInitialConditions = sic = ss != null ? ss.getServerInitialConditions() : null;
            if (sic != null && sic.getTime() != null) {
                boolean allowTimeToPass = sic.getTime().isAllowPassageOfTime() != Boolean.FALSE;
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server.worlds != null && server.worlds.length != 0) {
                    for (int i = 0; i < server.worlds.length; ++i) {
                        WorldServer world = server.worlds[i];
                        world.getGameRules().setOrCreateGameRule("doDaylightCycle", allowTimeToPass ? "true" : "false");
                        if (sic.getTime().getStartTime() == null) continue;
                        world.setWorldTime((long)sic.getTime().getStartTime().intValue());
                    }
                }
            }
            if ((modsettings = ServerStateMachine.this.currentMissionInit().getMission().getModSettings()) != null && modsettings.getMsPerTick() != null) {
                TimeHelper.serverTickLength = modsettings.getMsPerTick().intValue();
            }
            if (ServerStateMachine.this.getHandlers().quitProducer != null) {
                ServerStateMachine.this.getHandlers().quitProducer.prepare(ServerStateMachine.this.currentMissionInit());
            }
            if (ServerStateMachine.this.getHandlers().worldDecorator != null) {
                ServerStateMachine.this.getHandlers().worldDecorator.prepare(ServerStateMachine.this.currentMissionInit());
            }
            MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_GO);
            if (!ServerStateMachine.this.userTurnSchedule.isEmpty()) {
                String agentName = (String)ServerStateMachine.this.userTurnSchedule.get(0);
                PlayerList scoman = FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerList();
                EntityPlayerMP player = scoman.getPlayerByUsername(agentName);
                if (player != null) {
                    MalmoMod.network.sendTo((IMessage)new MalmoMod.MalmoMessage(MalmoMod.MalmoMessageType.SERVER_YOUR_TURN, ""), player);
                } else if (ServerStateMachine.this.getHandlers().worldDecorator != null) {
                    ServerStateMachine.this.getHandlers().worldDecorator.targetedUpdate(agentName);
                }
            }
        }

        @Override
        protected void onServerTick(TickEvent.ServerTickEvent ev) {
            if (this.missionHasEnded) {
                return;
            }
            if (!ServerStateMachine.this.checkWatchList()) {
                this.onError(null);
            }
            if (ev.phase == TickEvent.Phase.START) {
                long timeNow;
                if (this.secondStartTimeMs == 0L) {
                    this.secondStartTimeMs = System.currentTimeMillis();
                }
                if ((timeNow = System.currentTimeMillis()) - this.secondStartTimeMs > 1000L) {
                    long targetTicks = 1000L / TimeHelper.serverTickLength;
                    if (this.tickCount < targetTicks) {
                        System.out.println("Warning: managed " + this.tickCount + "/" + targetTicks + " ticks this second.");
                    }
                    this.secondStartTimeMs = timeNow;
                    this.tickCount = 0L;
                }
                ++this.tickCount;
            }
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (ev.phase == TickEvent.Phase.END && ServerStateMachine.this.getHandlers() != null && ServerStateMachine.this.getHandlers().worldDecorator != null) {
                World world = server.getEntityWorld();
                ServerStateMachine.this.getHandlers().worldDecorator.update(world);
            }
            if (ev.phase == TickEvent.Phase.END) {
                if (ServerStateMachine.this.getHandlers() != null && ServerStateMachine.this.getHandlers().quitProducer != null && ServerStateMachine.this.getHandlers().quitProducer.doIWantToQuit(ServerStateMachine.this.currentMissionInit())) {
                    ServerStateMachine.this.quitCode = ServerStateMachine.this.getHandlers().quitProducer.getOutcome();
                    this.onMissionEnded(true);
                } else if (this.runningAgents.isEmpty()) {
                    ServerStateMachine.this.quitCode = "All agents finished";
                    this.onMissionEnded(true);
                }
                if (server.getTickCounter() % 500 == 0) {
                    EnvironmentHelper.setMissionWeather(ServerStateMachine.this.currentMissionInit(), server.getEntityWorld().getWorldInfo());
                }
            }
        }

        private void onMissionEnded(boolean success) {
            this.missionHasEnded = true;
            if (ServerStateMachine.this.getHandlers().quitProducer != null) {
                ServerStateMachine.this.getHandlers().quitProducer.cleanup();
            }
            if (ServerStateMachine.this.getHandlers().worldDecorator != null) {
                ServerStateMachine.this.getHandlers().worldDecorator.cleanup();
            }
            TimeHelper.serverTickLength = 50L;
            if (success) {
                this.episodeHasCompleted(ServerState.WAITING_FOR_AGENTS_TO_QUIT);
            }
        }

        @Override
        protected void onError(Map<String, String> errorData) {
            this.onMissionEnded(false);
            MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_ABORT);
            this.episodeHasCompleted(ServerState.ERROR);
        }
    }

    public class WaitingForAgentsEpisode
    extends ErrorAwareEpisode
    implements MalmoMod.IMalmoMessageListener {
        private ArrayList<String> pendingReadyAgents;
        private ArrayList<String> pendingRunningAgents;
        private HashMap<String, String> usernameToAgentnameMap;
        private Map<Integer, String> userTurnScheduleMap;

        protected WaitingForAgentsEpisode(ServerStateMachine machine) {
            super(machine);
            this.pendingReadyAgents = new ArrayList();
            this.pendingRunningAgents = new ArrayList();
            this.usernameToAgentnameMap = new HashMap();
            this.userTurnScheduleMap = new HashMap<Integer, String>();
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.CLIENT_AGENTREADY);
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.CLIENT_AGENTRUNNING);
            ServerStateMachine.this.clearUserConnectionWatchList();
            ServerStateMachine.this.clearUserTurnSchedule();
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.CLIENT_AGENTREADY);
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.CLIENT_AGENTRUNNING);
        }

        private void addUsernameToTurnSchedule(String username, Integer requestedPosition) {
            if (requestedPosition == null || this.userTurnScheduleMap.containsKey(requestedPosition)) {
                requestedPosition = -this.userTurnScheduleMap.size();
            }
            this.userTurnScheduleMap.put(requestedPosition, username);
        }

        private void saveTurnSchedule() {
            if (this.userTurnScheduleMap.isEmpty()) {
                return;
            }
            ArrayList<Integer> keys = new ArrayList<Integer>(this.userTurnScheduleMap.keySet());
            Collections.sort(keys);
            ArrayList<String> schedule = new ArrayList<String>();
            for (Integer i : keys) {
                if (i < 0) continue;
                schedule.add(this.userTurnScheduleMap.get(i));
            }
            Collections.reverse(keys);
            for (Integer i : keys) {
                if (i >= 0) continue;
                schedule.add(this.userTurnScheduleMap.get(i));
            }
            ServerStateMachine.this.setUserTurnSchedule(schedule);
        }

        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            super.onMessage(messageType, data);
            if (messageType == MalmoMod.MalmoMessageType.CLIENT_AGENTREADY) {
                String username = data.get("username");
                String agentname = data.get("agentname");
                if (username != null && agentname != null && this.pendingReadyAgents.contains(agentname)) {
                    this.initialisePlayer(username, agentname);
                    this.pendingReadyAgents.remove(agentname);
                    this.usernameToAgentnameMap.put(username, agentname);
                    this.pendingRunningAgents.add(username);
                    ServerStateMachine.this.addUsernameToWatchList(username);
                    String requestedTurnPosition = data.get("turnPosition");
                    if (requestedTurnPosition != null) {
                        Integer pos = Integer.valueOf(requestedTurnPosition);
                        this.addUsernameToTurnSchedule(username, pos);
                    }
                    if (this.pendingReadyAgents.isEmpty()) {
                        this.onCastAssembled();
                    }
                }
            } else if (messageType == MalmoMod.MalmoMessageType.CLIENT_AGENTRUNNING) {
                String username = data.get("username");
                String agentname = this.usernameToAgentnameMap.get(username);
                if (username != null && this.pendingRunningAgents.contains(username)) {
                    if (agentname != null && !agentname.isEmpty()) {
                        AgentSection as = this.getAgentSectionFromAgentName(agentname);
                        EntityPlayerMP player = this.getPlayerFromUsername(username);
                        if (player != null && as != null) {
                            PosAndDirection pos = as.getAgentStart().getPlacement();
                            if (pos != null) {
                                player.posX = pos.getX().doubleValue();
                                player.posY = pos.getY().doubleValue();
                                player.posZ = pos.getZ().doubleValue();
                            }
                            player.setGameType(GameType.getByName((String)as.getMode().name().toLowerCase()));
                            player.capabilities.isFlying = false;
                            player.sendPlayerAbilities();
                            player.onUpdate();
                        }
                    }
                    this.pendingRunningAgents.remove(username);
                    if (this.pendingRunningAgents.isEmpty()) {
                        this.episodeHasCompleted(ServerState.RUNNING);
                    }
                }
            }
        }

        private AgentSection getAgentSectionFromAgentName(String agentname) {
            List<AgentSection> agents = ServerStateMachine.this.currentMissionInit().getMission().getAgentSection();
            if (agents != null && agents.size() > 0) {
                for (AgentSection ascandidate : agents) {
                    if (!ascandidate.getName().equals(agentname)) continue;
                    return ascandidate;
                }
            }
            return null;
        }

        private EntityPlayerMP getPlayerFromUsername(String username) {
            PlayerList scoman = FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerList();
            EntityPlayerMP player = scoman.getPlayerByUsername(username);
            return player;
        }

        private void initialisePlayer(String username, String agentname) {
            AgentSection as = this.getAgentSectionFromAgentName(agentname);
            EntityPlayerMP player = this.getPlayerFromUsername(username);
            if (player != null && as != null) {
                if (player.getHealth() <= 0.0f || player.isDead || !player.isEntityAlive()) {
                    player.markPlayerActive();
                    player.connection.playerEntity = player = FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerList().recreatePlayerEntity(player, player.dimension, false);
                }
                player.setHealth(player.getMaxHealth());
                player.getFoodStats().addStats(20, 40.0f);
                player.maxHurtResistantTime = 1;
                this.disablePlayerGracePeriod(player);
                player.extinguish();
                PosAndDirection pos = as.getAgentStart().getPlacement();
                if (pos != null) {
                    player.rotationYaw = pos.getYaw().floatValue();
                    player.rotationPitch = pos.getPitch().floatValue();
                    player.setPositionAndUpdate(pos.getX().doubleValue(), pos.getY().doubleValue(), pos.getZ().doubleValue());
                    player.onUpdate();
                }
                player.setVelocity(0.0, 0.0, 0.0);
                if (as.getAgentStart().getInventory() != null) {
                    this.initialiseInventory(player, as.getAgentStart().getInventory());
                }
                if (as.getAgentStart().getEnderBoxInventory() != null) {
                    this.initialiseEnderInventory(player, as.getAgentStart().getEnderBoxInventory());
                }
                player.setGameType(GameType.SPECTATOR);
            }
        }

        private boolean disablePlayerGracePeriod(EntityPlayerMP player) {
            boolean devEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
            String ritFieldName = devEnv ? "respawnInvulnerabilityTicks" : "field_147101_bU";
            try {
                Field rit = EntityPlayerMP.class.getDeclaredField(ritFieldName);
                rit.setAccessible(true);
                rit.set(player, 0);
                return true;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        protected void execute() {
            List<AgentSection> agents = ServerStateMachine.this.currentMissionInit().getMission().getAgentSection();
            if (agents != null && agents.size() > 0) {
                System.out.println("Experiment requires: ");
                for (AgentSection as : agents) {
                    System.out.println(">>>> " + as.getName());
                    this.pendingReadyAgents.add(as.getName());
                }
            }
        }

        private void resetPlayerGameTypes() {
            for (Map.Entry<String, String> entry : this.usernameToAgentnameMap.entrySet()) {
                AgentSection as = this.getAgentSectionFromAgentName(entry.getValue());
                EntityPlayerMP player = this.getPlayerFromUsername(entry.getKey());
                if (as == null || player == null) continue;
                player.setGameType(GameType.getByName((String)as.getMode().name().toLowerCase()));
                player.capabilities.isFlying = false;
                player.sendPlayerAbilities();
            }
        }

        private void onCastAssembled() {
            MissionBehaviour handlers = ServerStateMachine.this.getHandlers();
            ArrayList<Object> extraHandlers = new ArrayList<Object>();
            HashMap<String, String> data = new HashMap<String, String>();
            if (handlers.worldDecorator != null && handlers.worldDecorator.getExtraAgentHandlersAndData(extraHandlers, data)) {
                for (Object e : extraHandlers) {
                    try {
                        String xml = SchemaHelper.serialiseObject(e, MissionInit.class);
                        data.put(e.getClass().getName(), xml);
                    }
                    catch (JAXBException e2) {
                        System.out.println("Exception trying to describe extra handlers: " + (Object)((Object)e2));
                    }
                }
            }
            if (handlers.worldDecorator != null) {
                ArrayList<String> participants = new ArrayList<String>();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                handlers.worldDecorator.getTurnParticipants(participants, arrayList);
                for (int i = 0; i < Math.min(participants.size(), arrayList.size()); ++i) {
                    this.addUsernameToTurnSchedule(participants.get(i), arrayList.get(i));
                }
            }
            this.saveTurnSchedule();
            MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_ALLPLAYERSJOINED, data);
        }

        @Override
        protected void onError(Map<String, String> errorData) {
            this.resetPlayerGameTypes();
            MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_ABORT, errorData);
            this.episodeHasCompleted(ServerState.ERROR);
        }

        @Override
        protected void onServerTick(TickEvent.ServerTickEvent ev) {
            if (!ServerStateMachine.this.checkWatchList()) {
                this.onError(null);
            }
        }

        private ItemStack itemStackFromInventoryObject(InventoryObjectType obj) {
            DrawItem di = new DrawItem();
            di.setColour(obj.getColour());
            di.setVariant(obj.getVariant());
            di.setType(obj.getType());
            ItemStack item = MinecraftTypeHelper.getItemStackFromDrawItem(di);
            if (item != null) {
                item.setCount(obj.getQuantity());
            }
            return item;
        }

        private void initialiseInventory(EntityPlayerMP player, AgentStart.Inventory inventory) {
            player.inventory.clearMatchingItems(null, -1, -1, null);
            player.inventoryContainer.detectAndSendChanges();
            if (!player.capabilities.isCreativeMode) {
                player.updateHeldItem();
            }
            for (JAXBElement<? extends InventoryObjectType> el : inventory.getInventoryObject()) {
                InventoryObjectType obj = (InventoryObjectType)el.getValue();
                ItemStack item = this.itemStackFromInventoryObject(obj);
                if (item == null) continue;
                player.inventory.setInventorySlotContents(obj.getSlot(), item);
            }
        }

        private void initialiseEnderInventory(EntityPlayerMP player, AgentStart.EnderBoxInventory inventory) {
            player.getInventoryEnderChest().clear();
            for (JAXBElement<? extends InventoryObjectType> el : inventory.getInventoryObject()) {
                InventoryObjectType obj = (InventoryObjectType)el.getValue();
                ItemStack item = this.itemStackFromInventoryObject(obj);
                if (item == null) continue;
                player.getInventoryEnderChest().setInventorySlotContents(obj.getSlot(), item);
            }
        }
    }

    public class WaitingForAgentsToQuitEpisode
    extends ErrorAwareEpisode
    implements MalmoMod.IMalmoMessageListener {
        private HashMap<String, Boolean> agentsStopped;

        protected WaitingForAgentsToQuitEpisode(ServerStateMachine machine) {
            super(machine);
            this.agentsStopped = new HashMap();
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.CLIENT_AGENTSTOPPED);
        }

        @Override
        protected void execute() {
            List<AgentSection> agents = ServerStateMachine.this.currentMissionInit().getMission().getAgentSection();
            for (AgentSection as : agents) {
                this.agentsStopped.put(as.getName(), false);
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("QuitCode", ServerStateMachine.this.quitCode);
            MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_STOPAGENTS, data);
        }

        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            super.onMessage(messageType, data);
            if (messageType == MalmoMod.MalmoMessageType.CLIENT_AGENTSTOPPED) {
                String name = data.get("agentname");
                this.agentsStopped.put(name, true);
                if (!this.agentsStopped.containsValue(false)) {
                    MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_MISSIONOVER);
                    this.episodeHasCompleted(ServerState.CLEAN_UP);
                }
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.CLIENT_AGENTSTOPPED);
        }

        @Override
        protected void onServerTick(TickEvent.ServerTickEvent ev) {
            if (!ServerStateMachine.this.checkWatchList()) {
                MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_ABORT);
                this.episodeHasCompleted(ServerState.ERROR);
            }
        }
    }

    public class BuildingWorldEpisode
    extends ErrorAwareEpisode {
        private ServerStateMachine ssmachine;

        protected BuildingWorldEpisode(ServerStateMachine machine) {
            super(machine);
            this.ssmachine = machine;
        }

        @Override
        protected void execute() {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            World world = server.getEntityWorld();
            MissionBehaviour handlers = this.ssmachine.getHandlers();
            boolean builtOkay = true;
            if (handlers != null && handlers.worldDecorator != null) {
                try {
                    handlers.worldDecorator.buildOnWorld(this.ssmachine.currentMissionInit(), world);
                }
                catch (IWorldDecorator.DecoratorException e) {
                    builtOkay = false;
                    if (e.getMessage() != null) {
                        ServerStateMachine.this.saveErrorDetails(e.getMessage());
                    }
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("message", ServerStateMachine.this.getErrorDetails());
                    MalmoMod.safeSendToAll(MalmoMod.MalmoMessageType.SERVER_ABORT, data);
                    this.episodeHasCompleted(ServerState.ERROR);
                }
            }
            if (builtOkay) {
                EnvironmentHelper.setMissionWeather(ServerStateMachine.this.currentMissionInit(), server.getEntityWorld().getWorldInfo());
                this.episodeHasCompleted(ServerState.WAITING_FOR_AGENTS_TO_ASSEMBLE);
            }
        }

        @Override
        protected void onError(Map<String, String> errorData) {
            this.episodeHasCompleted(ServerState.ERROR);
        }
    }

    public class DormantEpisode
    extends ErrorAwareEpisode {
        private ServerStateMachine ssmachine;

        protected DormantEpisode(ServerStateMachine machine) {
            super(machine);
            this.ssmachine = machine;
            if (machine.hasQueuedMissionInit()) {
                MissionInit staleMinit = machine.releaseQueuedMissionInit();
                String summary = staleMinit.getMission().getAbout().getSummary();
                System.out.println("SERVER DITCHING SUSPECTED STALE MISSIONINIT: " + summary);
            }
        }

        @Override
        protected void execute() {
            ServerStateMachine.this.clearErrorDetails();
            if (ServerStateMachine.this.currentMissionInit() != null) {
                System.out.println("INCOMING MISSION: Received MissionInit directly through ServerStateMachine constructor.");
                this.onReceiveMissionInit(ServerStateMachine.this.currentMissionInit());
            }
        }

        @Override
        protected void onServerTick(TickEvent.ServerTickEvent ev) {
            try {
                this.checkForMissionCommand();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void checkForMissionCommand() throws Exception {
            if (this.ssmachine.hasQueuedMissionInit()) {
                System.out.println("INCOMING MISSION: Received MissionInit directly through queue.");
                this.onReceiveMissionInit(this.ssmachine.releaseQueuedMissionInit());
            }
        }

        protected void onReceiveMissionInit(MissionInit missionInit) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            System.out.println("Mission received: " + missionInit.getMission().getAbout().getSummary());
            TextComponentString txtMission = new TextComponentString("Received mission: " + TextFormatting.BLUE + missionInit.getMission().getAbout().getSummary());
            TextComponentString txtSource = new TextComponentString("Source: " + TextFormatting.GREEN + missionInit.getClientAgentConnection().getAgentIPAddress());
            server.getPlayerList().sendMessage((ITextComponent)txtMission);
            server.getPlayerList().sendMessage((ITextComponent)txtSource);
            ServerStateMachine.this.currentMissionInit = missionInit;
            try {
                this.ssmachine.initialiseHandlers(missionInit);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.episodeHasCompleted(ServerState.BUILDING_WORLD);
        }
    }

    public class InitialiseServerModEpisode
    extends StateEpisode {
        ServerStateMachine ssmachine;

        protected InitialiseServerModEpisode(ServerStateMachine machine) {
            super(machine);
            this.ssmachine = machine;
        }

        @Override
        protected void execute() throws Exception {
        }

        @Override
        protected void onServerTick(TickEvent.ServerTickEvent ev) {
            this.episodeHasCompleted(ServerState.DORMANT);
        }
    }

    public abstract class ErrorAwareEpisode
    extends StateEpisode
    implements MalmoMod.IMalmoMessageListener {
        protected Boolean errorFlag;
        protected Map<String, String> errorData;

        public ErrorAwareEpisode(ServerStateMachine machine) {
            super(machine);
            this.errorFlag = false;
            this.errorData = null;
            MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.CLIENT_BAILED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
            if (messageType == MalmoMod.MalmoMessageType.CLIENT_BAILED) {
                Boolean bl = this.errorFlag;
                synchronized (bl) {
                    this.errorFlag = true;
                    this.errorData = data;
                    this.onError(data);
                }
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.CLIENT_BAILED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean inErrorState() {
            Boolean bl = this.errorFlag;
            synchronized (bl) {
                return this.errorFlag;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> getErrorData() {
            Boolean bl = this.errorFlag;
            synchronized (bl) {
                return this.errorData;
            }
        }

        protected void onError(Map<String, String> errorData) {
        }
    }
}

