/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.Schemas.BlockType;
import com.microsoft.Malmo.Schemas.Colour;
import com.microsoft.Malmo.Schemas.ContainedObjectType;
import com.microsoft.Malmo.Schemas.DrawBlock;
import com.microsoft.Malmo.Schemas.DrawContainer;
import com.microsoft.Malmo.Schemas.DrawCuboid;
import com.microsoft.Malmo.Schemas.DrawEntity;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.DrawLine;
import com.microsoft.Malmo.Schemas.DrawObjectType;
import com.microsoft.Malmo.Schemas.DrawSign;
import com.microsoft.Malmo.Schemas.DrawSphere;
import com.microsoft.Malmo.Schemas.DrawingDecorator;
import com.microsoft.Malmo.Schemas.EntityTypes;
import com.microsoft.Malmo.Schemas.Facing;
import com.microsoft.Malmo.Schemas.NoteTypes;
import com.microsoft.Malmo.Schemas.ShapeTypes;
import com.microsoft.Malmo.Schemas.Variation;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockDrawingHelper {
    private List<StateCheck> checkList;

    public void beginDrawing(World w) {
        this.checkList = new ArrayList<StateCheck>();
    }

    public void endDrawing(World w) {
        for (StateCheck sc : this.checkList) {
            Block blockDesired;
            IBlockState stateActual = w.getBlockState(sc.pos);
            Block blockActual = stateActual.getBlock();
            if (blockActual != (blockDesired = sc.desiredState.getBlock()) || stateActual == sc.desiredState) continue;
            if (sc.propertiesToCheck == null) {
                w.setBlockState(sc.pos, sc.desiredState);
                continue;
            }
            for (IProperty prop : sc.propertiesToCheck) {
                stateActual = stateActual.withProperty(prop, sc.desiredState.getValue(prop));
            }
            w.setBlockState(sc.pos, stateActual);
        }
    }

    public void Draw(DrawingDecorator drawingNode, World world) throws Exception {
        this.beginDrawing(world);
        for (JAXBElement<? extends DrawObjectType> jaxbobj : drawingNode.getDrawObjectType()) {
            Object obj = jaxbobj.getValue();
            if (obj instanceof DrawBlock) {
                this.DrawPrimitive((DrawBlock)obj, world);
                continue;
            }
            if (obj instanceof DrawItem) {
                this.DrawPrimitive((DrawItem)obj, world);
                continue;
            }
            if (obj instanceof DrawCuboid) {
                this.DrawPrimitive((DrawCuboid)obj, world);
                continue;
            }
            if (obj instanceof DrawSphere) {
                this.DrawPrimitive((DrawSphere)obj, world);
                continue;
            }
            if (obj instanceof DrawLine) {
                this.DrawPrimitive((DrawLine)obj, world);
                continue;
            }
            if (obj instanceof DrawEntity) {
                this.DrawPrimitive((DrawEntity)obj, world);
                continue;
            }
            if (obj instanceof DrawContainer) {
                this.DrawPrimitive((DrawContainer)obj, world);
                continue;
            }
            if (obj instanceof DrawSign) {
                this.DrawPrimitive((DrawSign)obj, world);
                continue;
            }
            throw new Exception("Unsupported drawing primitive: " + obj.getClass().getName());
        }
        this.endDrawing(world);
    }

    private void DrawPrimitive(DrawBlock b, World w) throws Exception {
        XMLBlockState blockType = new XMLBlockState(b.getType(), b.getColour(), b.getFace(), b.getVariant());
        if (!blockType.isValid()) {
            throw new Exception("Unrecogised item type: " + b.getType().value());
        }
        BlockPos pos = new BlockPos(b.getX(), b.getY(), b.getZ());
        this.clearEntities(w, b.getX(), b.getY(), b.getZ(), b.getX() + 1, b.getY() + 1, b.getZ() + 1);
        this.setBlockState(w, pos, blockType);
    }

    public static IBlockState applyModifications(IBlockState blockType, Colour colour, Facing facing, Variation variant) {
        if (blockType == null) {
            return null;
        }
        if (colour != null) {
            blockType = MinecraftTypeHelper.applyColour(blockType, colour);
        }
        if (facing != null) {
            blockType = MinecraftTypeHelper.applyFacing(blockType, facing);
        }
        if (variant != null) {
            blockType = MinecraftTypeHelper.applyVariant(blockType, variant);
        }
        return blockType;
    }

    private void DrawPrimitive(DrawSphere s, World w) throws Exception {
        XMLBlockState blockType = new XMLBlockState(s.getType(), s.getColour(), null, s.getVariant());
        if (!blockType.isValid()) {
            throw new Exception("Unrecognised block type: " + s.getType().value());
        }
        int radius = s.getRadius();
        for (int x = s.getX() - radius; x <= s.getX() + radius; ++x) {
            for (int y = s.getY() - radius; y <= s.getY() + radius; ++y) {
                for (int z = s.getZ() - radius; z <= s.getZ() + radius; ++z) {
                    if ((z - s.getZ()) * (z - s.getZ()) + (y - s.getY()) * (y - s.getY()) + (x - s.getX()) * (x - s.getX()) > radius * radius) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    this.setBlockState(w, pos, blockType);
                    AxisAlignedBB aabb = new AxisAlignedBB(pos, new BlockPos(x + 1, y + 1, z + 1));
                    this.clearEntities(w, aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ);
                }
            }
        }
    }

    private void DrawPrimitive(DrawLine l, World w) throws Exception {
        XMLBlockState blockType = new XMLBlockState(l.getType(), l.getColour(), l.getFace(), l.getVariant());
        if (!blockType.isValid()) {
            throw new Exception("Unrecognised block type: " + l.getType().value());
        }
        XMLBlockState stepType = blockType;
        if (l.getSteptype() != null && !(stepType = new XMLBlockState(l.getSteptype(), l.getColour(), l.getFace(), l.getVariant())).isValid()) {
            throw new Exception("Unrecognised block type: " + l.getSteptype().value());
        }
        float dx = l.getX2() - l.getX1();
        float dy = l.getY2() - l.getY1();
        float dz = l.getZ2() - l.getZ1();
        float steps = (int)Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        if (steps < 1.0f) {
            steps = 1.0f;
        }
        dx /= steps;
        dy /= steps;
        dz /= steps;
        int prevY = l.getY1();
        int prevZ = l.getZ1();
        int prevX = l.getX1();
        int i = 0;
        while ((float)i <= steps) {
            int x = Math.round((float)l.getX1() + (float)i * dx);
            int y = Math.round((float)l.getY1() + (float)i * dy);
            int z = Math.round((float)l.getZ1() + (float)i * dz);
            BlockPos pos = new BlockPos(x, y, z);
            this.clearEntities(w, x, y, z, x + 1, y + 1, z + 1);
            this.setBlockState(w, pos, y == prevY ? blockType : stepType);
            if (x != prevX && z != prevZ) {
                pos = new BlockPos(x, y, prevZ);
                this.clearEntities(w, x, y, prevZ, x + 1, y + 1, prevZ + 1);
                this.setBlockState(w, pos, y == prevY ? blockType : stepType);
            }
            prevY = y;
            prevX = x;
            prevZ = z;
            ++i;
        }
    }

    public void clearEntities(World w, double x1, double y1, double z1, double x2, double y2, double z2) {
        List entities = w.getEntitiesWithinAABBExcludingEntity(null, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
        for (Entity ent : entities) {
            if (ent instanceof EntityPlayer) continue;
            w.removeEntity(ent);
        }
    }

    private void DrawPrimitive(DrawItem i, World w) throws Exception {
        ItemStack item = MinecraftTypeHelper.getItemStackFromDrawItem(i);
        if (item == null) {
            throw new Exception("Unrecognised item type: " + i.getType());
        }
        BlockPos pos = new BlockPos(i.getX(), i.getY(), i.getZ());
        this.placeItem(item, pos, w, true);
    }

    private void DrawPrimitive(DrawEntity e, World w) throws Exception {
        String oldEntityName = e.getType().getValue();
        String id = null;
        for (EntityEntry ent : ForgeRegistries.ENTITIES) {
            if (!ent.getName().equals(oldEntityName)) continue;
            id = ent.getRegistryName().toString();
            break;
        }
        if (id == null) {
            return;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setString("id", id);
        nbttagcompound.setBoolean("PersistenceRequired", true);
        try {
            Entity entity = EntityList.createEntityFromNBT((NBTTagCompound)nbttagcompound, (World)w);
            if (entity != null) {
                this.positionEntity(entity, e.getX().doubleValue(), e.getY().doubleValue(), e.getZ().doubleValue(), e.getYaw().floatValue(), e.getPitch().floatValue());
                entity.setVelocity(e.getXVel().doubleValue(), e.getYVel().doubleValue(), e.getZVel().doubleValue());
                if (entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).rotationYaw = e.getYaw().floatValue();
                    ((EntityLivingBase)entity).prevRotationYaw = e.getYaw().floatValue();
                    ((EntityLivingBase)entity).prevRotationYawHead = e.getYaw().floatValue();
                    ((EntityLivingBase)entity).rotationYawHead = e.getYaw().floatValue();
                    ((EntityLivingBase)entity).prevRenderYawOffset = e.getYaw().floatValue();
                    ((EntityLivingBase)entity).renderYawOffset = e.getYaw().floatValue();
                }
                w.getBlockState(entity.getPosition());
                if (!w.spawnEntity(entity)) {
                    System.out.println("WARNING: Failed to spawn entity! Chunk not loaded?");
                }
            }
        }
        catch (RuntimeException runtimeexception) {
            throw new Exception("Couldn't create entity type: " + e.getType().getValue());
        }
    }

    protected void DrawPrimitive(DrawContainer c, World w) throws Exception {
        String cType = c.getType().value();
        BlockType bType = BlockType.fromValue(cType);
        XMLBlockState blockType = new XMLBlockState(bType, c.getColour(), c.getFace(), c.getVariant());
        if (!blockType.isValid()) {
            throw new Exception("Unrecogised item type: " + c.getType().value());
        }
        BlockPos pos = new BlockPos(c.getX(), c.getY(), c.getZ());
        this.setBlockState(w, pos, blockType);
        TileEntity tileentity = w.getTileEntity(pos);
        if (tileentity instanceof TileEntityLockableLoot) {
            ((TileEntityLockableLoot)tileentity).clear();
            int index = 0;
            for (ContainedObjectType cot : c.getObject()) {
                DrawItem di = new DrawItem();
                di.setColour(cot.getColour());
                di.setType(cot.getType());
                di.setVariant(cot.getVariant());
                ItemStack stack = MinecraftTypeHelper.getItemStackFromDrawItem(di);
                stack.setCount(cot.getQuantity());
                ((TileEntityLockableLoot)tileentity).setInventorySlotContents(index, stack);
                ++index;
            }
        }
    }

    protected void DrawPrimitive(DrawSign s, World w) throws Exception {
        TileEntity tileentity;
        Block placedBlock;
        IBlockState placedBlockState;
        String sType = s.getType().value();
        BlockType bType = BlockType.fromValue(sType);
        XMLBlockState blockType = new XMLBlockState(bType, s.getColour(), s.getFace(), s.getVariant());
        BlockPos pos = new BlockPos(s.getX(), s.getY(), s.getZ());
        this.setBlockState(w, pos, blockType);
        if (blockType.type == BlockType.STANDING_SIGN && s.getRotation() != null && (placedBlockState = w.getBlockState(pos)) != null && (placedBlock = placedBlockState.getBlock()) != null) {
            IBlockState rotatedBlock = placedBlock.getStateFromMeta(s.getRotation().intValue());
            w.setBlockState(pos, rotatedBlock);
        }
        if ((tileentity = w.getTileEntity(pos)) instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            if (s.getLine1() != null) {
                sign.signText[0] = new TextComponentString(s.getLine1());
            }
            if (s.getLine2() != null) {
                sign.signText[1] = new TextComponentString(s.getLine2());
            }
            if (s.getLine3() != null) {
                sign.signText[2] = new TextComponentString(s.getLine3());
            }
            if (s.getLine4() != null) {
                sign.signText[3] = new TextComponentString(s.getLine4());
            }
        }
    }

    protected void positionEntity(Entity entity, double x, double y, double z, float yaw, float pitch) {
        entity.setLocationAndAngles(x, y, z, yaw, pitch);
    }

    public void placeItem(ItemStack stack, BlockPos pos, World world, boolean centreItem) {
        EntityItem entityitem = this.createItem(stack, pos.getX(), pos.getY(), pos.getZ(), world, centreItem);
        entityitem.motionX = 0.0;
        entityitem.motionY = 0.0;
        entityitem.motionZ = 0.0;
        entityitem.setDefaultPickupDelay();
        world.spawnEntity((Entity)entityitem);
    }

    protected EntityItem createItem(ItemStack stack, double x, double y, double z, World w, boolean centreItem) {
        if (centreItem) {
            x = (double)((int)x) + 0.5;
            y = (double)((int)y) + 0.5;
            z = (double)((int)z) + 0.5;
        }
        return new EntityItem(w, x, y, z, stack);
    }

    private void DrawPrimitive(DrawCuboid c, World w) throws Exception {
        XMLBlockState blockType = new XMLBlockState(c.getType(), c.getColour(), c.getFace(), c.getVariant());
        if (!blockType.isValid()) {
            throw new Exception("Unrecogised item type: " + c.getType().value());
        }
        int x1 = Math.min(c.getX1(), c.getX2());
        int x2 = Math.max(c.getX1(), c.getX2());
        int y1 = Math.min(c.getY1(), c.getY2());
        int y2 = Math.max(c.getY1(), c.getY2());
        int z1 = Math.min(c.getZ1(), c.getZ2());
        int z2 = Math.max(c.getZ1(), c.getZ2());
        this.clearEntities(w, x1, y1, z1, x2 + 1, y2 + 1, z2 + 1);
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    this.setBlockState(w, pos, blockType);
                }
            }
        }
    }

    public void setBlockState(World w, BlockPos pos, XMLBlockState state) {
        TileEntity te;
        if (!state.isValid()) {
            return;
        }
        if (state.getBlock() instanceof BlockRailBase && state.variant != null) {
            try {
                ShapeTypes shape = ShapeTypes.fromValue(state.variant.getValue());
                if (shape != null) {
                    StateCheck sc = new StateCheck();
                    sc.pos = pos;
                    sc.desiredState = state.state;
                    sc.propertiesToCheck = new ArrayList<IProperty>();
                    sc.propertiesToCheck.add(((BlockRailBase)state.getBlock()).getShapeProperty());
                    this.checkList.add(sc);
                }
            }
            catch (IllegalArgumentException shape) {
                // empty catch block
            }
        }
        w.setBlockState(pos, state.state);
        if (state.type == BlockType.MOB_SPAWNER && (te = w.getTileEntity(pos)) != null && te instanceof TileEntityMobSpawner) {
            try {
                EntityTypes entvar = EntityTypes.fromValue(state.variant.getValue());
                ((TileEntityMobSpawner)te).getSpawnerBaseLogic().setEntityId(new ResourceLocation(entvar.value()));
            }
            catch (Exception entvar) {
                // empty catch block
            }
        }
        if (state.type == BlockType.NOTEBLOCK && (te = w.getTileEntity(pos)) != null && te instanceof TileEntityNote && state.variant != null) {
            try {
                NoteTypes note = NoteTypes.fromValue(state.variant.getValue());
                if (note != null) {
                    ((TileEntityNote)te).note = (byte)note.ordinal();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static class XMLBlockState {
        IBlockState state;
        Colour colour;
        Facing face;
        Variation variant;
        BlockType type;

        public XMLBlockState(IBlockState state) {
            this.state = state;
        }

        public XMLBlockState(BlockType type, Colour colour, Facing face, Variation variant) {
            this.type = type;
            IBlockState blockType = MinecraftTypeHelper.ParseBlockType(type.value());
            if (blockType != null) {
                this.state = blockType = BlockDrawingHelper.applyModifications(blockType, colour, face, variant);
            }
            this.colour = colour;
            this.face = face;
            this.variant = variant;
        }

        public XMLBlockState(IBlockState state, Colour colour, Facing face, Variation variant) {
            if (state != null) {
                this.state = state = BlockDrawingHelper.applyModifications(state, colour, face, variant);
            }
            this.colour = colour;
            this.face = face;
            this.variant = variant;
        }

        public Block getBlock() {
            return this.state != null ? this.state.getBlock() : null;
        }

        public boolean isValid() {
            return this.state != null;
        }
    }

    private class StateCheck {
        IBlockState desiredState;
        BlockPos pos;
        List<IProperty> propertiesToCheck;

        private StateCheck() {
        }
    }
}

