/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.Malmo.MissionHandlers.RewardForCollectingItemImplementation;
import com.microsoft.Malmo.MissionHandlers.RewardForDiscardingItemImplementation;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingHelper {
    private static Map<EntityPlayerMP, Integer> fuelCaches = new HashMap<EntityPlayerMP, Integer>();

    public static void reset() {
        fuelCaches = new HashMap<EntityPlayerMP, Integer>();
    }

    public static List<ItemStack> getIngredients(IRecipe recipe) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        if (recipe instanceof ShapelessRecipes) {
            List items = ((ShapelessRecipes)recipe).recipeItems;
            for (Object obj : items) {
                if (!(obj instanceof ItemStack)) continue;
                ingredients.add((ItemStack)obj);
            }
        } else if (recipe instanceof ShapelessOreRecipe) {
            NonNullList objs = ((ShapelessOreRecipe)recipe).getInput();
            for (Object o : objs) {
                if (o == null) continue;
                if (o instanceof ItemStack) {
                    ingredients.add((ItemStack)o);
                    continue;
                }
                if (!(o instanceof List)) continue;
                List stacks = (List)o;
                for (Object stack : stacks) {
                    if (!(stack instanceof ItemStack)) continue;
                    ingredients.add((ItemStack)stack);
                }
            }
        } else if (recipe instanceof ShapedRecipes) {
            ItemStack[] stack = ((ShapedRecipes)recipe).recipeItems;
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i] == null) continue;
                ingredients.add(stack[i]);
            }
        } else if (recipe instanceof ShapedOreRecipe) {
            Object[] items = ((ShapedOreRecipe)recipe).getInput();
            for (int i = 0; i < items.length; ++i) {
                Object obj = items[i];
                if (obj == null) continue;
                if (obj instanceof ItemStack) {
                    ingredients.add((ItemStack)obj);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                List stacks = (List)items[i];
                for (Object stack : stacks) {
                    if (!(stack instanceof ItemStack)) continue;
                    ingredients.add((ItemStack)stack);
                }
            }
        } else {
            return null;
        }
        return CraftingHelper.consolidateItemStacks(ingredients);
    }

    public static List<ItemStack> consolidateItemStacks(List<ItemStack> inputStacks) {
        ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>();
        for (ItemStack sourceIS : inputStacks) {
            boolean bFound = false;
            for (ItemStack destIS : outputStacks) {
                if (destIS == null || sourceIS == null || !CraftingHelper.itemStackIngredientsMatch(destIS, sourceIS)) continue;
                bFound = true;
                destIS.setCount(destIS.getCount() + sourceIS.getCount());
            }
            if (bFound) continue;
            outputStacks.add(sourceIS.copy());
        }
        return outputStacks;
    }

    public static boolean playerHasIngredients(EntityPlayerMP player, List<ItemStack> ingredients) {
        NonNullList main = player.inventory.mainInventory;
        NonNullList arm = player.inventory.armorInventory;
        for (ItemStack isIngredient : ingredients) {
            int target = isIngredient.getCount();
            for (int i = 0; i < main.size() + arm.size() && target > 0; ++i) {
                ItemStack isPlayer;
                ItemStack itemStack = isPlayer = i >= main.size() ? (ItemStack)arm.get(i - main.size()) : (ItemStack)main.get(i);
                if (isPlayer == null || isIngredient == null || !CraftingHelper.itemStackIngredientsMatch(isPlayer, isIngredient)) continue;
                target -= isPlayer.getCount();
            }
            if (target <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean playerHasIngredients(EntityPlayerSP player, List<ItemStack> ingredients) {
        NonNullList main = player.inventory.mainInventory;
        NonNullList arm = player.inventory.armorInventory;
        for (ItemStack isIngredient : ingredients) {
            int target = isIngredient.getCount();
            for (int i = 0; i < main.size() + arm.size() && target > 0; ++i) {
                ItemStack isPlayer;
                ItemStack itemStack = isPlayer = i >= main.size() ? (ItemStack)arm.get(i - main.size()) : (ItemStack)main.get(i);
                if (isPlayer == null || isIngredient == null || !CraftingHelper.itemStackIngredientsMatch(isPlayer, isIngredient)) continue;
                target -= isPlayer.getCount();
            }
            if (target <= 0) continue;
            return false;
        }
        return true;
    }

    private static boolean itemStackIngredientsMatch(ItemStack A, ItemStack B) {
        if (A == null && B == null) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        if (A.getMetadata() == Short.MAX_VALUE || B.getMetadata() == Short.MAX_VALUE) {
            return A.getItem() == B.getItem();
        }
        return ItemStack.areItemsEqual((ItemStack)A, (ItemStack)B);
    }

    public static int totalBurnTimeInInventory(EntityPlayerMP player) {
        Integer fromCache = fuelCaches.get(player);
        int total = fromCache != null ? fromCache : 0;
        for (int i = 0; i < player.inventory.mainInventory.size(); ++i) {
            ItemStack is = (ItemStack)player.inventory.mainInventory.get(i);
            total += is.getCount() * TileEntityFurnace.getItemBurnTime((ItemStack)is);
        }
        return total;
    }

    public static void burnInventory(EntityPlayerMP player, int burnAmount, ItemStack input) {
        if (!fuelCaches.containsKey(player)) {
            fuelCaches.put(player, -burnAmount);
        } else {
            fuelCaches.put(player, fuelCaches.get(player) - burnAmount);
        }
        int index = 0;
        while (fuelCaches.get(player) < 0 && index < player.inventory.mainInventory.size()) {
            ItemStack is = (ItemStack)player.inventory.mainInventory.get(index);
            if (is != null) {
                int burnTime = TileEntityFurnace.getItemBurnTime((ItemStack)is);
                if (burnTime != 0) {
                    if (is.getCount() > 1) {
                        is.setCount(is.getCount() - 1);
                    } else {
                        if (is.getItem() == Items.LAVA_BUCKET) {
                            if (input.getItem() == Item.getItemFromBlock((Block)Blocks.SPONGE) && input.getMetadata() == 1) {
                                player.inventory.mainInventory.set(index, (Object)new ItemStack(Items.WATER_BUCKET));
                            } else {
                                player.inventory.mainInventory.set(index, (Object)new ItemStack(Items.BUCKET));
                            }
                        } else {
                            ((ItemStack)player.inventory.mainInventory.get(index)).setCount(0);
                        }
                        ++index;
                    }
                    fuelCaches.put(player, fuelCaches.get(player) + burnTime);
                    continue;
                }
                ++index;
                continue;
            }
            ++index;
        }
    }

    public static void removeIngredientsFromPlayer(EntityPlayerMP player, List<ItemStack> ingredients) {
        NonNullList main = player.inventory.mainInventory;
        NonNullList arm = player.inventory.armorInventory;
        for (ItemStack isIngredient : ingredients) {
            int target = isIngredient.getCount();
            for (int i = 0; i < main.size() + arm.size() && target > 0; ++i) {
                ItemStack isPlayer;
                ItemStack itemStack = isPlayer = i >= main.size() ? (ItemStack)arm.get(i - main.size()) : (ItemStack)main.get(i);
                if (!CraftingHelper.itemStackIngredientsMatch(isPlayer, isIngredient)) continue;
                if (target >= isPlayer.getCount()) {
                    target -= isPlayer.getCount();
                    if (i >= main.size()) {
                        ((ItemStack)arm.get(i - main.size())).setCount(0);
                        continue;
                    }
                    ((ItemStack)main.get(i)).setCount(0);
                    continue;
                }
                isPlayer.setCount(isPlayer.getCount() - target);
                target = 0;
            }
            ItemStack resultForReward = isIngredient.copy();
            RewardForDiscardingItemImplementation.LoseItemEvent event = new RewardForDiscardingItemImplementation.LoseItemEvent(resultForReward);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public static List<IRecipe> getRecipesForRequestedOutput(String output, boolean variant) {
        ArrayList<IRecipe> matchingRecipes = new ArrayList<IRecipe>();
        ItemStack target = MinecraftTypeHelper.getItemStackFromParameterString(output);
        List recipes = CraftingManager.getInstance().getRecipeList();
        for (Object obj : recipes) {
            if (obj == null || !(obj instanceof IRecipe)) continue;
            ItemStack is = ((IRecipe)obj).getRecipeOutput();
            if (target == null) continue;
            if (variant && ItemStack.areItemsEqual((ItemStack)is, (ItemStack)target)) {
                matchingRecipes.add((IRecipe)obj);
                continue;
            }
            if (variant || is.getItem() != target.getItem()) continue;
            matchingRecipes.add((IRecipe)obj);
        }
        return matchingRecipes;
    }

    public static List<IRecipe> getRecipesForRequestedOutput(ItemStack output, boolean variant) {
        ArrayList<IRecipe> matchingRecipes = new ArrayList<IRecipe>();
        List recipes = CraftingManager.getInstance().getRecipeList();
        for (Object obj : recipes) {
            if (obj == null || !(obj instanceof IRecipe)) continue;
            ItemStack is = ((IRecipe)obj).getRecipeOutput();
            if (output == null) continue;
            if (variant && ItemStack.areItemsEqual((ItemStack)is, (ItemStack)output)) {
                matchingRecipes.add((IRecipe)obj);
                continue;
            }
            if (variant || is.getItem() != output.getItem()) continue;
            matchingRecipes.add((IRecipe)obj);
        }
        return matchingRecipes;
    }

    public static ItemStack getSmeltingRecipeForRequestedOutput(String output) {
        ItemStack target = MinecraftTypeHelper.getItemStackFromParameterString(output);
        for (ItemStack isInput : FurnaceRecipes.instance().getSmeltingList().keySet()) {
            ItemStack isOutput = (ItemStack)FurnaceRecipes.instance().getSmeltingList().get(isInput);
            if (!CraftingHelper.itemStackIngredientsMatch(target, isOutput)) continue;
            return isInput;
        }
        return null;
    }

    public static boolean attemptCrafting(EntityPlayerMP player, IRecipe recipe) {
        if (player == null || recipe == null) {
            return false;
        }
        ItemStack is = recipe.getRecipeOutput();
        List<ItemStack> ingredients = CraftingHelper.getIngredients(recipe);
        if (CraftingHelper.playerHasIngredients(player, ingredients)) {
            CraftingHelper.removeIngredientsFromPlayer(player, ingredients);
            ItemStack resultForInventory = is.copy();
            ItemStack resultForReward = is.copy();
            player.inventory.addItemStackToInventory(resultForInventory);
            RewardForCollectingItemImplementation.GainItemEvent event = new RewardForCollectingItemImplementation.GainItemEvent(resultForReward);
            event.setCause(1);
            MinecraftForge.EVENT_BUS.post((Event)event);
            List<IRecipe> recipes = CraftingHelper.getRecipesForRequestedOutput(resultForReward, true);
            for (IRecipe iRecipe : recipes) {
                InventoryCrafting craftMatrix;
                if (iRecipe instanceof ShapedRecipes) {
                    ShapedRecipes shapedRecipe = (ShapedRecipes)iRecipe;
                    craftMatrix = shapedRecipe.recipeItems.length <= 4 ? new InventoryCrafting(player.inventoryContainer, 2, 2) : new InventoryCrafting(player.inventoryContainer, 3, 3);
                    for (int i = 0; i < shapedRecipe.recipeItems.length; ++i) {
                        craftMatrix.setInventorySlotContents(i, shapedRecipe.recipeItems[i]);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemCraftedEvent((EntityPlayer)player, resultForReward, (IInventory)craftMatrix));
                    break;
                }
                if (iRecipe instanceof ShapelessRecipes) {
                    ShapelessRecipes shapelessRecipe = (ShapelessRecipes)iRecipe;
                    if (shapelessRecipe.recipeItems.size() <= 4) {
                        craftMatrix = new InventoryCrafting(player.inventoryContainer, 2, 2);
                        for (int i = 0; i < shapelessRecipe.recipeItems.size(); ++i) {
                            craftMatrix.setInventorySlotContents(i, (ItemStack)shapelessRecipe.recipeItems.get(i));
                        }
                    } else {
                        craftMatrix = new InventoryCrafting(player.inventoryContainer, 3, 3);
                        for (int i = 0; i < shapelessRecipe.recipeItems.size(); ++i) {
                            craftMatrix.setInventorySlotContents(i, (ItemStack)shapelessRecipe.recipeItems.get(i));
                        }
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemCraftedEvent((EntityPlayer)player, resultForReward, (IInventory)craftMatrix));
                    break;
                }
                if (!(iRecipe instanceof ShapedOreRecipe)) continue;
                ShapedOreRecipe oreRecipe = (ShapedOreRecipe)iRecipe;
                Object[] input = oreRecipe.getInput();
                InventoryCrafting craftMatrix2 = new InventoryCrafting(player.inventoryContainer, 3, 3);
                for (int i = 0; i < input.length; ++i) {
                    if (input[i] instanceof ItemStack) {
                        craftMatrix2.setInventorySlotContents(i, (ItemStack)input[i]);
                        continue;
                    }
                    if (!(input[i] instanceof NonNullList) || ((NonNullList)input[i]).size() == 0) continue;
                    craftMatrix2.setInventorySlotContents(i, (ItemStack)((NonNullList)input[i]).get(0));
                }
                MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemCraftedEvent((EntityPlayer)player, resultForReward, (IInventory)craftMatrix2));
            }
            return true;
        }
        return false;
    }

    public static boolean attemptSmelting(EntityPlayerMP player, ItemStack input) {
        if (player == null || input == null) {
            return false;
        }
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ingredients.add(input);
        ItemStack isOutput = (ItemStack)FurnaceRecipes.instance().getSmeltingList().get(input);
        if (isOutput == null) {
            return false;
        }
        int cookingTime = 200;
        if (CraftingHelper.playerHasIngredients(player, ingredients) && CraftingHelper.totalBurnTimeInInventory(player) >= cookingTime) {
            CraftingHelper.removeIngredientsFromPlayer(player, ingredients);
            CraftingHelper.burnInventory(player, cookingTime, input);
            ItemStack resultForInventory = isOutput.copy();
            ItemStack resultForReward = isOutput.copy();
            player.inventory.addItemStackToInventory(resultForInventory);
            RewardForCollectingItemImplementation.GainItemEvent event = new RewardForCollectingItemImplementation.GainItemEvent(resultForReward);
            event.setCause(2);
            MinecraftForge.EVENT_BUS.post((Event)event);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemSmeltedEvent((EntityPlayer)player, resultForReward));
            return true;
        }
        return false;
    }

    public static void dumpItemProperties(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream("..//..//build//install//Python_Examples//item_database.json");
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
        BufferedWriter writer = new BufferedWriter(osw);
        JsonArray itemTypes = new JsonArray();
        for (ResourceLocation i : Item.REGISTRY.getKeys()) {
            Item item = (Item)Item.REGISTRY.getObject((Object)i);
            if (item == null) continue;
            JsonObject json = new JsonObject();
            json.addProperty("type", ((ResourceLocation)Item.REGISTRY.getNameForObject((Object)item)).toString().replace("minecraft:", ""));
            json.addProperty("damageable", Boolean.valueOf(item.isDamageable()));
            json.addProperty("rendersIn3D", Boolean.valueOf(item.isFull3D()));
            json.addProperty("repairable", Boolean.valueOf(item.isRepairable()));
            CreativeTabs tab = item.getCreativeTab();
            json.addProperty("tab", tab != null ? item.getCreativeTab().getTabLabel() : "none");
            ItemStack is = item.getDefaultInstance();
            json.addProperty("stackable", Boolean.valueOf(is.isStackable()));
            json.addProperty("enchantable", Boolean.valueOf(is.isItemEnchantable()));
            json.addProperty("rare", Boolean.valueOf(is.getRarity() == EnumRarity.RARE));
            json.addProperty("action", is.getItemUseAction().toString());
            json.addProperty("hasSubtypes", Boolean.valueOf(item.getHasSubtypes()));
            json.addProperty("maxDamage", (Number)is.getMaxDamage());
            json.addProperty("maxUseDuration", (Number)is.getMaxItemUseDuration());
            json.addProperty("block", Boolean.valueOf(item instanceof ItemBlock));
            json.addProperty("hasContainerItem", Boolean.valueOf(item.hasContainerItem()));
            if (item instanceof ItemBlock) {
                ItemBlock ib = (ItemBlock)item;
                Block b = ib.getBlock();
                IBlockState bs = b.getDefaultState();
                json.addProperty("slipperiness", (Number)Float.valueOf(b.slipperiness));
                json.addProperty("hardness", (Number)Float.valueOf(bs.getBlockHardness(null, null)));
                json.addProperty("causesSuffocation", Boolean.valueOf(bs.causesSuffocation()));
                json.addProperty("canProvidePower", Boolean.valueOf(bs.canProvidePower()));
                json.addProperty("translucent", Boolean.valueOf(bs.isTranslucent()));
                Material mat = bs.getMaterial();
                if (mat != null) {
                    json.addProperty("canBurn", Boolean.valueOf(mat.getCanBurn()));
                    json.addProperty("isLiquid", Boolean.valueOf(mat.isLiquid()));
                    json.addProperty("blocksMovement", Boolean.valueOf(mat.blocksMovement()));
                    json.addProperty("needsNoTool", Boolean.valueOf(mat.isToolNotRequired()));
                    json.addProperty("isReplaceable", Boolean.valueOf(mat.isReplaceable()));
                    json.addProperty("pistonPushable", Boolean.valueOf(mat.getMobilityFlag() == EnumPushReaction.NORMAL));
                    json.addProperty("woodenMaterial", Boolean.valueOf(mat == Material.WOOD));
                    json.addProperty("ironMaterial", Boolean.valueOf(mat == Material.IRON));
                    json.addProperty("glassyMaterial", Boolean.valueOf(mat == Material.GLASS));
                    json.addProperty("clothMaterial", Boolean.valueOf(mat == Material.CLOTH));
                }
                boolean hasDirection = false;
                boolean hasColour = false;
                boolean hasVariant = false;
                for (IProperty prop : bs.getProperties().keySet()) {
                    System.out.println(((ResourceLocation)Item.REGISTRY.getNameForObject((Object)item)).toString() + " -- " + prop);
                    if (prop instanceof PropertyDirection) {
                        hasDirection = true;
                    }
                    if (prop instanceof PropertyEnum && prop.getName().equals("color")) {
                        hasColour = true;
                    }
                    if (!(prop instanceof PropertyEnum) || !prop.getName().equals("variant")) continue;
                    hasVariant = true;
                    json.addProperty("variant", bs.getValue(prop).toString());
                }
                json.addProperty("hasDirection", Boolean.valueOf(hasDirection));
                json.addProperty("hasColour", Boolean.valueOf(hasColour));
                json.addProperty("hasVariant", Boolean.valueOf(hasVariant));
            }
            itemTypes.add((JsonElement)json);
        }
        writer.write(itemTypes.toString());
        writer.close();
    }

    public static void dumpRecipes(String filename) throws IOException {
        String s;
        FileOutputStream fos = new FileOutputStream(filename);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
        BufferedWriter writer = new BufferedWriter(osw);
        List recipes = CraftingManager.getInstance().getRecipeList();
        for (Object obj : recipes) {
            ItemStack is;
            if (obj == null || !(obj instanceof IRecipe) || (is = ((IRecipe)obj).getRecipeOutput()) == null) continue;
            s = is.getCount() + "x" + is.getUnlocalizedName() + " = ";
            List<ItemStack> ingredients = CraftingHelper.getIngredients((IRecipe)obj);
            if (ingredients == null) continue;
            boolean first = true;
            for (ItemStack isIngredient : ingredients) {
                if (!first) {
                    s = s + ", ";
                }
                s = s + isIngredient.getCount() + "x" + isIngredient.getUnlocalizedName();
                s = s + "(" + isIngredient.getDisplayName() + ")";
                first = false;
            }
            s = s + "\n";
            writer.write(s);
        }
        for (ItemStack isInput : FurnaceRecipes.instance().getSmeltingList().keySet()) {
            ItemStack isOutput = (ItemStack)FurnaceRecipes.instance().getSmeltingList().get(isInput);
            s = isOutput.getCount() + "x" + isOutput.getUnlocalizedName() + " = FUEL + " + isInput.getCount() + "x" + isInput.getUnlocalizedName() + "\n";
            writer.write(s);
        }
        writer.close();
    }
}

