/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import java.util.Arrays;
import java.util.Random;
import java.util.Stack;

public class EvaluationHelper {
    static final String[] functions = new String[]{"sin", "cos", "tan", "asin", "acos", "atan", "abs"};
    static final String[] tokens = new String[]{"t", "+", "-", "/", "*", "%", "^", "rand", "(", ")"};

    public static void test() {
        Random rand = new Random();
        String[] tests = new String[]{"2^(abs(t) % 3)", "200*(rand-0.5)", "-1--t", "sin(-t)", "t^2", "1.0/(abs(t)+1)"};
        for (int i = 0; i > -10; --i) {
            System.out.println("For t = " + i);
            for (int t = 0; t < tests.length; ++t) {
                try {
                    System.out.println(tests[t] + " = " + EvaluationHelper.eval(tests[t], i, rand));
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public static float eval(String expression, float t, Random rand) throws Exception {
        Stack<Float> values = new Stack<Float>();
        Stack<String> operators = new Stack<String>();
        boolean mustBeUnaryMinus = true;
        while (!expression.isEmpty()) {
            String number = "";
            expression = expression.trim();
            while (!expression.isEmpty() && expression.substring(0, 1).matches("[0-9\\.]")) {
                number = number + expression.substring(0, 1);
                expression = expression.substring(1);
            }
            if (!number.isEmpty()) {
                Float f = Float.valueOf(number);
                values.push(f);
                mustBeUnaryMinus = false;
                continue;
            }
            String op = null;
            for (int i = 0; i < functions.length + tokens.length; ++i) {
                String tok;
                String string = tok = i < functions.length ? functions[i] : tokens[i - functions.length];
                if (!expression.startsWith(tok)) continue;
                op = tok;
                expression = expression.substring(op.length());
                break;
            }
            if (op == null) {
                throw new Exception("Unrecognised token at start of " + expression + " in eval()");
            }
            if (op.equals("-") && mustBeUnaryMinus) {
                op = "unary_minus";
            }
            if (op.equals("t")) {
                values.push(Float.valueOf(t));
                mustBeUnaryMinus = false;
                continue;
            }
            if (op.equals("rand")) {
                values.push(Float.valueOf(rand.nextFloat()));
                mustBeUnaryMinus = false;
                continue;
            }
            if (op.equals("(")) {
                operators.push(op);
                mustBeUnaryMinus = true;
                continue;
            }
            if (op.equals(")")) {
                while (!operators.isEmpty() && !(op = operators.pop()).equals("(")) {
                    EvaluationHelper.doOp(op, values, operators, rand);
                }
                mustBeUnaryMinus = false;
                continue;
            }
            if (EvaluationHelper.isFunction(op)) {
                operators.push(op);
                continue;
            }
            int precedence = EvaluationHelper.getPrecedence(op);
            if (EvaluationHelper.isRightAssociative(op)) {
                ++precedence;
            }
            while (!operators.isEmpty() && !operators.peek().equals("(") && precedence <= EvaluationHelper.getPrecedence(operators.peek())) {
                String op2 = operators.pop();
                EvaluationHelper.doOp(op2, values, operators, rand);
            }
            operators.push(op);
            mustBeUnaryMinus = true;
        }
        while (!operators.empty()) {
            String op = (String)operators.pop();
            EvaluationHelper.doOp(op, values, operators, rand);
        }
        return ((Float)values.pop()).floatValue();
    }

    private static boolean isFunction(String op) {
        return Arrays.asList(functions).contains(op);
    }

    private static int getPrecedence(String op) {
        if (op.equals("+") || op.equals("-")) {
            return 2;
        }
        if (op.equals("*") || op.equals("/")) {
            return 3;
        }
        if (op.equals("^")) {
            return 4;
        }
        if (op.equals("unary_minus")) {
            return 5;
        }
        return 6;
    }

    private static boolean isRightAssociative(String op) {
        return op.equals("unary_minus") || op.equals("^");
    }

    private static void doOp(String op, Stack<Float> values, Stack<String> operators, Random rand) {
        if (op.equals("+")) {
            values.push(Float.valueOf(values.pop().floatValue() + values.pop().floatValue()));
        } else if (op.equals("-")) {
            values.push(Float.valueOf(-(values.pop().floatValue() - values.pop().floatValue())));
        } else if (op.equals("*")) {
            values.push(Float.valueOf(values.pop().floatValue() * values.pop().floatValue()));
        } else if (op.equals("/")) {
            Float b = values.pop();
            Float a = values.pop();
            values.push(Float.valueOf(a.floatValue() / b.floatValue()));
        } else if (op.equals("%")) {
            int b = Math.round(values.pop().floatValue());
            int a = Math.round(values.pop().floatValue());
            values.push(Float.valueOf(a % b));
        } else if (op.equals("^")) {
            Float b = values.pop();
            Float a = values.pop();
            values.push(Float.valueOf((float)Math.pow(a.floatValue(), b.floatValue())));
        } else if (op.equals("sin")) {
            values.push(Float.valueOf((float)Math.sin(values.pop().floatValue())));
        } else if (op.equals("cos")) {
            values.push(Float.valueOf((float)Math.cos(values.pop().floatValue())));
        } else if (op.equals("tan")) {
            values.push(Float.valueOf((float)Math.tan(values.pop().floatValue())));
        } else if (op.equals("asin")) {
            values.push(Float.valueOf((float)Math.asin(values.pop().floatValue())));
        } else if (op.equals("acos")) {
            values.push(Float.valueOf((float)Math.acos(values.pop().floatValue())));
        } else if (op.equals("atan")) {
            values.push(Float.valueOf((float)Math.atan(values.pop().floatValue())));
        } else if (op.equals("abs")) {
            values.push(Float.valueOf(Math.abs(values.pop().floatValue())));
        } else if (op.equals("unary_minus")) {
            values.push(Float.valueOf(-values.pop().floatValue()));
        }
    }
}

