/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class JSONWorldDataHelper {
    public static void buildAchievementStats(JsonObject json, EntityPlayerSP player) {
        if (Minecraft.getMinecraft().isIntegratedServerRunning()) {
            StatisticsManagerServer sfw = Minecraft.getMinecraft().getIntegratedServer().getPlayerList().getPlayerStatsFile((EntityPlayer)player);
            json.addProperty("DistanceTravelled", (Number)(sfw.readStat(StatList.WALK_ONE_CM) + sfw.readStat(StatList.SWIM_ONE_CM) + sfw.readStat(StatList.DIVE_ONE_CM) + sfw.readStat(StatList.FALL_ONE_CM)));
            json.addProperty("TimeAlive", (Number)sfw.readStat(StatList.TIME_SINCE_DEATH));
            json.addProperty("MobsKilled", (Number)sfw.readStat(StatList.MOB_KILLS));
            json.addProperty("PlayersKilled", (Number)sfw.readStat(StatList.PLAYER_KILLS));
            json.addProperty("DamageTaken", (Number)sfw.readStat(StatList.DAMAGE_TAKEN));
            json.addProperty("DamageDealt", (Number)sfw.readStat(StatList.DAMAGE_DEALT));
        }
    }

    public static void buildLifeStats(JsonObject json, EntityPlayerSP player) {
        json.addProperty("Life", (Number)Float.valueOf(player.getHealth()));
        json.addProperty("Score", (Number)player.getScore());
        json.addProperty("Food", (Number)player.getFoodStats().getFoodLevel());
        json.addProperty("XP", (Number)player.experienceTotal);
        json.addProperty("IsAlive", Boolean.valueOf(!player.isDead));
        json.addProperty("Air", (Number)player.getAir());
        json.addProperty("Name", player.getName());
    }

    public static void buildPositionStats(JsonObject json, EntityPlayerSP player) {
        json.addProperty("XPos", (Number)player.posX);
        json.addProperty("YPos", (Number)player.posY);
        json.addProperty("ZPos", (Number)player.posZ);
        json.addProperty("Pitch", (Number)Float.valueOf(player.rotationPitch));
        json.addProperty("Yaw", (Number)Float.valueOf(player.rotationYaw));
    }

    public static void buildEnvironmentStats(JsonObject json, EntityPlayerSP player) {
        json.addProperty("WorldTime", (Number)player.world.getWorldTime());
        json.addProperty("TotalTime", (Number)player.world.getTotalWorldTime());
    }

    public static void buildGridData(JsonObject json, GridDimensions environmentDimensions, EntityPlayerMP player, String jsonName) {
        if (player == null || json == null) {
            return;
        }
        JsonArray arr = new JsonArray();
        BlockPos pos = new BlockPos(player.posX, player.posY, player.posZ);
        for (int y = environmentDimensions.yMin; y <= environmentDimensions.yMax; ++y) {
            for (int z = environmentDimensions.zMin; z <= environmentDimensions.zMax; ++z) {
                for (int x = environmentDimensions.xMin; x <= environmentDimensions.xMax; ++x) {
                    BlockPos p = environmentDimensions.absoluteCoords ? new BlockPos(x, y, z) : pos.add(x, y, z);
                    String name = "";
                    IBlockState state = player.world.getBlockState(p);
                    Object blockName = Block.REGISTRY.getNameForObject((Object)state.getBlock());
                    if (blockName instanceof ResourceLocation) {
                        name = ((ResourceLocation)blockName).getResourcePath();
                    }
                    JsonPrimitive element = new JsonPrimitive(name);
                    arr.add((JsonElement)element);
                }
            }
        }
        json.add(jsonName, (JsonElement)arr);
    }

    public static class GridDimensions {
        public int xMin;
        public int xMax;
        public int yMin;
        public int yMax;
        public int zMin;
        public int zMax;
        public boolean absoluteCoords;

        public GridDimensions() {
            this.xMin = -1;
            this.xMax = 1;
            this.zMin = -1;
            this.zMax = 1;
            this.yMin = -1;
            this.yMax = 2;
            this.absoluteCoords = false;
        }

        public GridDimensions(int xMargin, int yMargin, int zMargin) {
            this.xMin = -xMargin;
            this.xMax = xMargin;
            this.yMin = -yMargin;
            this.yMax = yMargin + 1;
            this.zMin = -zMargin;
            this.zMax = zMargin;
            this.absoluteCoords = false;
        }

        public GridDimensions(int xMargin, int zMargin) {
            this.xMin = -xMargin;
            this.xMax = xMargin;
            this.yMin = -1;
            this.yMax = -1;
            this.zMin = -zMargin;
            this.zMax = zMargin;
            this.absoluteCoords = false;
        }
    }
}

