/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.Utils.AddressHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.io.FileUtils;

public class MapFileHelper {
    static final String tempMark = "TEMP_";

    public static File copyMapFiles(File mapFile, boolean isTemporary) {
        System.out.println("Current directory: " + System.getProperty("user.dir"));
        File savesDir = FMLClientHandler.instance().getSavesDir();
        File dst = null;
        if (mapFile != null && mapFile.exists()) {
            dst = new File(savesDir, MapFileHelper.getNewSaveFileLocation(isTemporary));
            try {
                FileUtils.copyDirectory((File)mapFile, (File)dst);
            }
            catch (IOException e) {
                System.out.println("Failed to load file: " + mapFile.getPath());
                return null;
            }
        }
        return dst;
    }

    public static String getNewSaveFileLocation(boolean isTemporary) {
        String s;
        File dst;
        File savesDir = FMLClientHandler.instance().getSavesDir();
        do {
            s = UUID.randomUUID().toString();
            s = AddressHelper.getMissionControlPort() + "_" + s;
            if (!isTemporary) continue;
            s = tempMark + s;
        } while ((dst = new File(savesDir, s)).exists());
        return dst.getName();
    }

    public static boolean createAndLaunchWorld(WorldSettings worldsettings, boolean isTemporary) {
        String s = MapFileHelper.getNewSaveFileLocation(isTemporary);
        Minecraft.getMinecraft().launchIntegratedServer(s, s, worldsettings);
        MapFileHelper.cleanupTemporaryWorlds(s);
        return true;
    }

    public static void cleanupTemporaryWorlds(String currentWorld) {
        List saveList;
        ISaveFormat isaveformat = Minecraft.getMinecraft().getSaveLoader();
        isaveformat.flushCache();
        try {
            saveList = isaveformat.getSaveList();
        }
        catch (AnvilConverterException e) {
            e.printStackTrace();
            return;
        }
        String searchString = tempMark + AddressHelper.getMissionControlPort() + "_";
        for (WorldSummary s : saveList) {
            String folderName = s.getFileName();
            if (!folderName.startsWith(searchString) || folderName.equals(currentWorld)) continue;
            isaveformat.deleteWorldDirectory(folderName);
        }
    }
}

