/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.Schemas.AgentSection;
import com.microsoft.Malmo.Schemas.Mission;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.Reward;
import com.microsoft.Malmo.Utils.SchemaHelper;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ScoreHelper {
    private static final int DEFAULT_NO_SCORING = 0;
    private static final int LOG_EACH_REWARD = 1;
    private static final int TOTAL_ALL_REWARDS = 2;
    private static final int TOTAL_WITH_MISSION_XML = 3;
    private static int scoringPolicy = 0;
    private static Logger logger = Logger.getLogger("com.microsoft.Malmo.Scoring");
    private static Handler handler = null;
    private static boolean logging = false;
    private static Level loggingLevel;
    private static Double totalRewards;

    public static void update(Configuration configs) {
        scoringPolicy = configs.get("malmoscore", "policy", 0).getInt();
        if (scoringPolicy > 0) {
            String customLogHandler = configs.get("malmoscore", "handler", "").getString();
            ScoreHelper.setLogging(Level.INFO, customLogHandler);
        }
        if (logging) {
            ScoreHelper.log("<ScoreInit><Policy>" + scoringPolicy + "</Policy></ScoreInit>");
        }
    }

    public static boolean isScoring() {
        return scoringPolicy > 0;
    }

    public static void logMissionInit(MissionInit missionInit) throws JAXBException {
        String hash;
        if (!logging || !ScoreHelper.isScoring()) {
            return;
        }
        totalRewards = 0.0;
        String missionXml = SchemaHelper.serialiseObject(missionInit.getMission(), Mission.class);
        try {
            hash = ScoreHelper.digest(missionXml);
        }
        catch (NoSuchAlgorithmException e) {
            hash = "";
        }
        List<AgentSection> agents = missionInit.getMission().getAgentSection();
        String agentName = agents.get(missionInit.getClientRole()).getName();
        StringBuffer message = new StringBuffer("<MissionInit><MissionDigest>");
        message.append(hash);
        message.append("</MissionDigest>");
        message.append("<AgentName>");
        message.append(agentName);
        message.append("</AgentName></MissionInit>");
        if (scoringPolicy == 3) {
            message.append(missionXml);
        }
        ScoreHelper.log(message.toString());
    }

    public static void logReward(String reward) {
        if (!logging || !ScoreHelper.isScoring()) {
            return;
        }
        if (scoringPolicy == 1) {
            ScoreHelper.log("<Reward>" + reward + "</Reward>");
        } else if (scoringPolicy == 2 || scoringPolicy == 3) {
            int i = reward.indexOf(":");
            totalRewards = totalRewards + Double.parseDouble(reward.substring(i + 1));
        }
    }

    public static void logMissionEndRewards(Reward reward) throws JAXBException {
        if (!logging || !ScoreHelper.isScoring()) {
            return;
        }
        if (scoringPolicy == 1) {
            String rewardString = SchemaHelper.serialiseObject(reward, Reward.class);
            ScoreHelper.log("<MissionEnd>" + rewardString + "</MissionEnd>");
        } else if (scoringPolicy == 2 || scoringPolicy == 3) {
            List<Reward.Value> values = reward.getValue();
            for (Reward.Value v : values) {
                totalRewards = totalRewards + v.getValue().doubleValue();
            }
            ScoreHelper.log("<MissionTotal>" + totalRewards + "</MissionTotal>");
        }
        totalRewards = 0.0;
    }

    private static void log(String message) {
        logger.log(Level.INFO, message);
    }

    private static void setLogging(Level level, String customLogHandler) {
        logging = true;
        if (handler == null) {
            if (customLogHandler != null && customLogHandler != "") {
                System.out.println("Custom score handler " + customLogHandler);
                try {
                    Class<?> handlerClass = Class.forName(customLogHandler);
                    handler = (Handler)handlerClass.newInstance();
                }
                catch (Exception e) {
                    System.out.println("Failed to create custom score log " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                try {
                    Date d = new Date();
                    String filename = "Score" + DateFormatUtils.format((Date)d, (String)"yyyy-MM-dd HH-mm-ss") + ".log";
                    handler = new FileHandler("logs" + File.separator + filename);
                }
                catch (Exception e) {
                    System.out.println("Failed to create file score log " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (handler != null) {
                logger.setUseParentHandlers(false);
                logger.addHandler(handler);
            }
        }
        logger.setLevel(level);
        loggingLevel = level;
    }

    private static String digest(String message) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(message.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    static {
        totalRewards = 0.0;
    }
}

