/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ScreenHelper {
    protected Map<TextCategory, ArrayList<TextFragment>> fragments = new HashMap<TextCategory, ArrayList<TextFragment>>();
    protected Map<TextCategory, TextCategoryAttributes> attributes = new HashMap<TextCategory, TextCategoryAttributes>();
    protected static DebugOutputLevel outputLevel = DebugOutputLevel.OUTPUT_FRIENDLY;

    public static void hookIntoInGameGui() {
        Minecraft.getMinecraft().ingameGUI = new IngameGUIHook(Minecraft.getMinecraft());
    }

    public ScreenHelper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.attributes.put(TextCategory.TXT_INFO, new TextCategoryAttributes(800, 850, 0x4488FF, true, false, DebugOutputLevel.OUTPUT_INFO));
        this.attributes.put(TextCategory.TXT_SERVER_STATE, new TextCategoryAttributes(4, 4, 0xFFAAFF, false, false, DebugOutputLevel.OUTPUT_DEBUG));
        this.attributes.put(TextCategory.TXT_CLIENT_STATE, new TextCategoryAttributes(4, 34, 0xAAFFFF, false, false, DebugOutputLevel.OUTPUT_DEBUG));
        this.attributes.put(TextCategory.TXT_CLIENT_WARNING, new TextCategoryAttributes(4, 64, 0xFF0000, true, true, DebugOutputLevel.OUTPUT_WARNINGS));
        this.attributes.put(TextCategory.TXT_SERVER_WARNING, new TextCategoryAttributes(500, 64, 0xFF0000, true, true, DebugOutputLevel.OUTPUT_WARNINGS));
        this.attributes.put(TextCategory.TXT_AGENT_MESSAGE, new TextCategoryAttributes(4, 800, 0x8888FF, true, false, DebugOutputLevel.OUTPUT_FRIENDLY));
    }

    public static void setOutputLevel(DebugOutputLevel dol) {
        outputLevel = dol;
    }

    public void addFragment(String text, TextCategory category, Integer displayTimeMs) {
        TextFragment fragment = new TextFragment(text, category, displayTimeMs);
        this.addFragment(fragment);
    }

    public void addFragment(String text, TextCategory category, String handle) {
        TextFragment fragment = new TextFragment(text, category, null);
        fragment.handle = handle;
        this.addFragment(fragment);
    }

    public void clearFragment(String handle) {
        this.purgeExpiredFragments(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFragment(TextFragment fragment) {
        Map<TextCategory, ArrayList<TextFragment>> map = this.fragments;
        synchronized (map) {
            if (fragment == null) {
                return;
            }
            TextCategoryAttributes atts = this.attributes.get((Object)fragment.category);
            if (atts == null) {
                return;
            }
            ArrayList<TextFragment> frags = this.fragments.get((Object)fragment.category);
            if (frags == null) {
                frags = new ArrayList();
                this.fragments.put(fragment.category, frags);
            }
            if (!atts.list) {
                frags.clear();
            }
            boolean replaced = false;
            if (fragment.handle != null) {
                for (int i = 0; i < frags.size() && !replaced; ++i) {
                    if (frags.get((int)i).handle == null || !frags.get((int)i).handle.equals(fragment.handle)) continue;
                    frags.set(i, fragment);
                    replaced = true;
                }
            }
            if (!replaced) {
                frags.add(fragment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeExpiredFragments(String handle) {
        Map<TextCategory, ArrayList<TextFragment>> map = this.fragments;
        synchronized (map) {
            long timenow = System.currentTimeMillis();
            for (Map.Entry<TextCategory, ArrayList<TextFragment>> pair : this.fragments.entrySet()) {
                if (pair.getValue() == null) continue;
                Iterator<TextFragment> itFrag = pair.getValue().iterator();
                while (itFrag.hasNext()) {
                    TextFragment frag = itFrag.next();
                    if ((frag.expirationTime == -1L || frag.expirationTime >= timenow) && (handle == null || frag.handle == null || !frag.handle.equals(handle))) continue;
                    itFrag.remove();
                }
            }
        }
    }

    private boolean shouldDisplay(DebugOutputLevel dol) {
        return dol.ordinal() <= outputLevel.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        this.purgeExpiredFragments(null);
        if (Minecraft.getMinecraft().currentScreen != null && !(Minecraft.getMinecraft().currentScreen instanceof GuiMainMenu)) {
            return;
        }
        if (Minecraft.getMinecraft().gameSettings.showDebugInfo) {
            return;
        }
        ScaledResolution res = new ScaledResolution(Minecraft.getMinecraft());
        int width = res.getScaledWidth();
        int height = res.getScaledHeight();
        float rx = (float)width / 1000.0f;
        float ry = (float)height / 1000.0f;
        Map<TextCategory, ArrayList<TextFragment>> map = this.fragments;
        synchronized (map) {
            for (TextCategory cat : TextCategory.values()) {
                TextCategoryAttributes atts = this.attributes.get((Object)cat);
                if (atts == null || atts.flashing && System.currentTimeMillis() / 500L % 3L == 0L || !this.shouldDisplay(atts.displayLevel)) continue;
                int x = Math.round(rx * (float)atts.xOrg);
                int y = Math.round(ry * (float)atts.yOrg);
                ArrayList<TextFragment> frags = this.fragments.get((Object)cat);
                if (frags == null || frags.isEmpty()) continue;
                for (TextFragment frag : frags) {
                    ScreenHelper.drawText(frag.text, x, y, atts.colour);
                    y += 10;
                }
            }
        }
    }

    public static void drawText(String s, int x, int y, int colour) {
        FontRenderer frendo = Minecraft.getMinecraft().fontRendererObj;
        frendo.drawStringWithShadow(s, (float)x, (float)y, colour);
    }

    public static void update(Configuration config) {
        String[] values = new String[DebugOutputLevel.values().length];
        for (DebugOutputLevel level : DebugOutputLevel.values()) {
            values[level.ordinal()] = level.getDisplayName();
        }
        String debugOutputLevel = config.getString("debugDisplayLevel", "malmodiags", outputLevel.getDisplayName(), "Set the level of debugging information to be displayed on the Minecraft screen.", values);
        for (DebugOutputLevel level : DebugOutputLevel.values()) {
            if (!level.getDisplayName().equals(debugOutputLevel)) continue;
            outputLevel = level;
        }
    }

    public class TextCategoryAttributes {
        public int xOrg;
        public int yOrg;
        public int colour;
        public boolean list;
        public boolean flashing;
        public DebugOutputLevel displayLevel;

        public TextCategoryAttributes(int xorg, int yorg, int colour, boolean list, boolean flashing, DebugOutputLevel displayLevel) {
            this.xOrg = xorg;
            this.yOrg = yorg;
            this.colour = colour;
            this.list = list;
            this.flashing = flashing;
            this.displayLevel = displayLevel;
        }
    }

    public class TextFragment {
        public TextCategory category;
        public String text;
        public long expirationTime;
        public String handle = null;

        public TextFragment(String text, TextCategory category, Integer displayTimeMs) {
            this.text = text != null ? text : "";
            this.category = category;
            this.expirationTime = displayTimeMs != null ? System.currentTimeMillis() + (long)displayTimeMs.intValue() : -1L;
        }
    }

    public static enum DebugOutputLevel {
        OUTPUT_NONE("No display"),
        OUTPUT_FRIENDLY("Normal"),
        OUTPUT_INFO("Basic info"),
        OUTPUT_WARNINGS("Show warnings"),
        OUTPUT_DEBUG("Show debugging info"),
        OUTPUT_EVERYTHING("Show all diagnostics");

        private final String displayName;

        private DebugOutputLevel(String displayName) {
            this.displayName = displayName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum TextCategory {
        TXT_INFO,
        TXT_SERVER_STATE,
        TXT_CLIENT_STATE,
        TXT_SERVER_WARNING,
        TXT_CLIENT_WARNING,
        TXT_AGENT_MESSAGE;

    }

    public static class TitleChangeEvent
    extends Event {
        public final String title;
        public final String subtitle;

        public TitleChangeEvent(String title, String subtitle) {
            this.title = title;
            this.subtitle = subtitle;
        }
    }

    private static class IngameGUIHook
    extends GuiIngameForge {
        public IngameGUIHook(Minecraft mc) {
            super(mc);
        }

        public void displayTitle(String title, String subTitle, int timeFadeIn, int displayTime, int timeFadeOut) {
            TitleChangeEvent event = new TitleChangeEvent(title, subTitle);
            MinecraftForge.EVENT_BUS.post((Event)event);
            super.displayTitle(title, subTitle, timeFadeIn, displayTime, timeFadeOut);
        }
    }
}

