/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.Utils.TCPUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class TCPSocketChannel {
    private AsynchronousSocketChannel channel;
    private String address;
    private int port;
    private String logname;

    public TCPSocketChannel(String address, int port, String logname) {
        this.address = address;
        this.port = port;
        this.logname = logname;
        try {
            this.connectWithTimeout();
        }
        catch (IOException e) {
            this.Log(Level.SEVERE, "Failed to connectWithTimeout AsynchronousSocketChannel: " + e);
        }
        catch (ExecutionException e) {
            this.Log(Level.SEVERE, "Failed to connectWithTimeout AsynchronousSocketChannel: " + e);
        }
        catch (InterruptedException e) {
            this.Log(Level.SEVERE, "Failed to connectWithTimeout AsynchronousSocketChannel: " + e);
        }
        catch (TimeoutException e) {
            this.Log(Level.SEVERE, "AsynchronousSocketChannel connectWithTimeout timed out: " + e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isValid() {
        return this.channel != null;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    private void Log(Level level, String message) {
        TCPUtils.Log(level, "<-" + this.logname + "(" + this.address + ":" + this.port + ") " + message);
    }

    private void SysLog(Level level, String message) {
        TCPUtils.SysLog(level, "<-" + this.logname + "(" + this.address + ":" + this.port + ") " + message);
    }

    private void connectWithTimeout() throws IOException, ExecutionException, InterruptedException, TimeoutException {
        if (this.port == 0) {
            return;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.address, this.port);
        this.Log(Level.INFO, "Attempting to open SocketChannel with InetSocketAddress: " + inetSocketAddress);
        this.channel = AsynchronousSocketChannel.open();
        Future<Void> connected = this.channel.connect(inetSocketAddress);
        connected.get(30000L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.Log(Level.INFO, "Attempting to close channel.");
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                this.SysLog(Level.SEVERE, "Failed to close channel: " + e);
            }
        }
    }

    public boolean sendTCPString(String message) {
        return this.sendTCPString(message, 0);
    }

    public boolean sendTCPString(String message, int retries) {
        this.Log(Level.FINE, "About to send: " + message);
        byte[] bytes = message.getBytes();
        return this.sendTCPBytes(bytes, retries);
    }

    public boolean sendTCPBytes(byte[] buffer) {
        return this.sendTCPBytes(buffer, 0);
    }

    public boolean sendTCPBytes(byte[] bytes, int retries) {
        try {
            ByteBuffer header = this.createHeader(bytes.length);
            this.safeWrite(header);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.safeWrite(buffer);
        }
        catch (Exception e) {
            this.SysLog(Level.SEVERE, "Failed to send TCP bytes" + (retries > 0 ? " -- retrying " : "") + ": " + e);
            try {
                this.channel.close();
            }
            catch (IOException buffer) {
                // empty catch block
            }
            if (retries > 0) {
                try {
                    this.connectWithTimeout();
                }
                catch (Exception connectException) {
                    this.SysLog(Level.SEVERE, "Failed to reconnect: " + connectException);
                    return false;
                }
                return this.sendTCPBytes(bytes, retries - 1);
            }
            return false;
        }
        return true;
    }

    public boolean sendTCPBytes(ByteBuffer[] srcbuffers, int length) {
        boolean success = false;
        try {
            ByteBuffer header = this.createHeader(length);
            ByteBuffer[] buffers = new ByteBuffer[1 + srcbuffers.length];
            buffers[0] = header;
            for (int i = 0; i < srcbuffers.length; ++i) {
                buffers[i + 1] = srcbuffers[i];
            }
            if (TCPUtils.isLogging()) {
                long t1 = System.nanoTime();
                long bytesWritten = this.write(buffers);
                long t2 = System.nanoTime();
                double rate = 1.0E9 * (double)bytesWritten / (1024.0 * (double)(t2 - t1));
                this.Log(Level.INFO, "Sent " + bytesWritten + " bytes at " + rate + " Kb/s");
            } else {
                this.write(buffers);
            }
            success = true;
        }
        catch (Exception e) {
            this.SysLog(Level.SEVERE, "Failed to send TCP bytes: " + e);
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return success;
    }

    private ByteBuffer createHeader(int length) {
        ByteBuffer header = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(length);
        header.flip();
        return header;
    }

    private void safeWrite(ByteBuffer buffer) throws InterruptedException, TimeoutException, ExecutionException, IOException {
        while (buffer.remaining() > 0) {
            Future<Integer> future = this.channel.write(buffer);
            int bytesWritten = future.get(30000L, TimeUnit.MILLISECONDS);
            if (bytesWritten != 0) continue;
            throw new IOException("async write failed to send any bytes.");
        }
    }

    private long write(ByteBuffer[] buffers) throws InterruptedException, TimeoutException, ExecutionException, IOException {
        long bytesWritten = 0L;
        for (ByteBuffer b : buffers) {
            bytesWritten += (long)b.remaining();
            this.safeWrite(b);
        }
        return bytesWritten;
    }
}

