/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.microsoft.Malmo.MalmoMod;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.util.JsonException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class TextureHelper {
    private static Entity currentEntity = null;
    private static int shaderID = -1;
    private static boolean isInitialised;
    private static Map<String, Integer> idealMobColours;
    private static Map<Integer, Integer> texturesToColours;
    private static Map<String, Integer> miscTexturesToColours;
    private static IRenderHandler blankSkyRenderer;
    private static boolean isProducingColourMap;
    public static boolean colourmapFrame;

    public static void hookIntoRenderPipeline() {
        Minecraft.getMinecraft().entityRenderer = new MalmoEntityRenderer(Minecraft.getMinecraft(), Minecraft.getMinecraft().getResourceManager());
        MalmoRenderManager newRenderManager = new MalmoRenderManager(Minecraft.getMinecraft().renderEngine, Minecraft.getMinecraft().getRenderItem());
        boolean devEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        String mcRenderManagerName = devEnv ? "renderManager" : "field_175616_W";
        String globalRenderManagerName = devEnv ? "renderManager" : "field_175010_j";
        try {
            Field renderMan = Minecraft.class.getDeclaredField(mcRenderManagerName);
            renderMan.setAccessible(true);
            renderMan.set(Minecraft.getMinecraft(), (Object)newRenderManager);
            Field globalRenderMan = RenderGlobal.class.getDeclaredField(globalRenderManagerName);
            globalRenderMan.setAccessible(true);
            globalRenderMan.set(Minecraft.getMinecraft().renderGlobal, (Object)newRenderManager);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        if (!isInitialised) {
            shaderID = TextureHelper.createProgram("annotate");
            isInitialised = true;
        }
    }

    public static void setIsProducingColourMap(boolean usemap) {
        if (usemap && !isInitialised) {
            TextureHelper.init();
        }
        isProducingColourMap = usemap;
        if (!usemap) {
            OpenGlHelper.glUseProgram((int)0);
        }
    }

    public static void glBindTexture(int target, int texture) {
        if (isProducingColourMap && colourmapFrame && shaderID != -1) {
            Integer col = texturesToColours.get(texture);
            if (col == null) {
                if (currentEntity != null) {
                    if (idealMobColours != null) {
                        col = 0;
                        String entName = EntityList.getKey((Entity)currentEntity).toString();
                        for (String ent : idealMobColours.keySet()) {
                            if (!entName.equals(ent)) continue;
                            col = idealMobColours.get(ent);
                        }
                    } else {
                        Object ent = EntityList.getEntityString((Entity)currentEntity);
                        if (ent == null) {
                            ent = currentEntity.getClass().getName();
                        }
                        col = ((String)ent).hashCode() % 0xFFFFFF;
                    }
                    texturesToColours.put(texture, col);
                } else {
                    ITextureObject blockatlas;
                    for (String resID : miscTexturesToColours.keySet()) {
                        ITextureObject tex = Minecraft.getMinecraft().getTextureManager().getTexture(new ResourceLocation(resID));
                        if (tex == null || tex.getGlTextureId() != texture) continue;
                        col = miscTexturesToColours.get(resID);
                    }
                    if (col == null && (blockatlas = Minecraft.getMinecraft().getTextureManager().getTexture(new ResourceLocation("textures/atlas/blocks.png"))) != null && blockatlas.getGlTextureId() == texture) {
                        col = -1;
                    }
                    if (col != null) {
                        texturesToColours.put(texture, col);
                    }
                }
            }
            if (col != null) {
                OpenGlHelper.glUseProgram((int)shaderID);
                int entColUniformLocR = OpenGlHelper.glGetUniformLocation((int)shaderID, (CharSequence)"entityColourR");
                int entColUniformLocG = OpenGlHelper.glGetUniformLocation((int)shaderID, (CharSequence)"entityColourG");
                int entColUniformLocB = OpenGlHelper.glGetUniformLocation((int)shaderID, (CharSequence)"entityColourB");
                if (entColUniformLocR != -1 && entColUniformLocG != -1 && entColUniformLocB != -1) {
                    OpenGlHelper.glUniform1i((int)entColUniformLocR, (int)(col != -1 ? col >> 16 & 0xFF : -1));
                    OpenGlHelper.glUniform1i((int)entColUniformLocG, (int)(col != -1 ? col >> 8 & 0xFF : -1));
                    OpenGlHelper.glUniform1i((int)entColUniformLocB, (int)(col != -1 ? col & 0xFF : -1));
                }
            } else {
                OpenGlHelper.glUseProgram((int)0);
            }
        }
        GL11.glBindTexture((int)target, (int)texture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadShader(String filename, int shaderType) throws IOException {
        int shaderID = -1;
        InputStream stream = MalmoMod.class.getClassLoader().getResourceAsStream(filename);
        if (stream == null) {
            System.out.println("Cannot find shader.");
            return -1;
        }
        try {
            byte[] abyte = IOUtils.toByteArray((InputStream)new BufferedInputStream(stream));
            ByteBuffer bytebuffer = BufferUtils.createByteBuffer((int)abyte.length);
            bytebuffer.put(abyte);
            bytebuffer.position(0);
            shaderID = OpenGlHelper.glCreateShader((int)shaderType);
            OpenGlHelper.glShaderSource((int)shaderID, (ByteBuffer)bytebuffer);
            OpenGlHelper.glCompileShader((int)shaderID);
            if (OpenGlHelper.glGetShaderi((int)shaderID, (int)OpenGlHelper.GL_COMPILE_STATUS) == 0) {
                String s = StringUtils.trim((String)OpenGlHelper.glGetShaderInfoLog((int)shaderID, (int)32768));
                JsonException jsonexception = new JsonException("Couldn't compile shader program: " + s);
                throw jsonexception;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return shaderID;
    }

    public static int createProgram(String shader) {
        int prog = -1;
        try {
            int f_shader = TextureHelper.loadShader(shader + ".fsh", OpenGlHelper.GL_FRAGMENT_SHADER);
            int v_shader = TextureHelper.loadShader(shader + ".vsh", OpenGlHelper.GL_VERTEX_SHADER);
            prog = OpenGlHelper.glCreateProgram();
            OpenGlHelper.glAttachShader((int)prog, (int)v_shader);
            OpenGlHelper.glAttachShader((int)prog, (int)f_shader);
            OpenGlHelper.glLinkProgram((int)prog);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return prog;
    }

    public static void setSkyRenderer(IRenderHandler skyRenderer) {
        blankSkyRenderer = skyRenderer;
    }

    public static void setMobColours(Map<String, Integer> mobColours) {
        if (mobColours == null || mobColours.isEmpty()) {
            idealMobColours = null;
        } else {
            idealMobColours = new HashMap<String, Integer>();
            String id = null;
            for (String oldname : mobColours.keySet()) {
                for (EntityEntry ent : ForgeRegistries.ENTITIES) {
                    if (!ent.getName().equals(oldname)) continue;
                    id = ent.getRegistryName().toString();
                    break;
                }
                if (id == null) continue;
                idealMobColours.put(id, mobColours.get(oldname));
            }
        }
        texturesToColours.clear();
    }

    public static void setMiscTextureColours(Map<String, Integer> miscColours) {
        miscTexturesToColours = miscColours == null || miscColours.isEmpty() ? null : miscColours;
        texturesToColours.clear();
    }

    static {
        idealMobColours = null;
        texturesToColours = new HashMap<Integer, Integer>();
        miscTexturesToColours = new HashMap<String, Integer>();
        isProducingColourMap = false;
        colourmapFrame = false;
    }

    public static class BlankSkyRenderer
    extends IRenderHandler {
        private byte r = 0;
        private byte g = 0;
        private byte b = 0;

        public BlankSkyRenderer(byte[] col) {
            this.r = col[0];
            this.g = col[1];
            this.b = col[2];
        }

        public void render(float partialTicks, WorldClient world, Minecraft mc) {
            GlStateManager.disableFog();
            GlStateManager.disableAlpha();
            GlStateManager.disableBlend();
            RenderHelper.disableStandardItemLighting();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableTexture2D();
            Tessellator tessellator = Tessellator.getInstance();
            VertexBuffer vertexbuffer = tessellator.getBuffer();
            for (int i = 0; i < 6; ++i) {
                GlStateManager.pushMatrix();
                if (i == 1) {
                    GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 2) {
                    GlStateManager.rotate((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 3) {
                    GlStateManager.rotate((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 4) {
                    GlStateManager.rotate((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (i == 5) {
                    GlStateManager.rotate((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                vertexbuffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
                vertexbuffer.pos(-100.0, -100.0, -100.0).color((int)this.r, (int)this.g, (int)this.b, 255).endVertex();
                vertexbuffer.pos(-100.0, -100.0, 100.0).color((int)this.r, (int)this.g, (int)this.b, 255).endVertex();
                vertexbuffer.pos(100.0, -100.0, 100.0).color((int)this.r, (int)this.g, (int)this.b, 255).endVertex();
                vertexbuffer.pos(100.0, -100.0, -100.0).color((int)this.r, (int)this.g, (int)this.b, 255).endVertex();
                tessellator.draw();
                GlStateManager.popMatrix();
            }
            GlStateManager.depthMask((boolean)true);
            GlStateManager.enableTexture2D();
            GlStateManager.enableAlpha();
        }
    }

    public static class MalmoRenderManager
    extends RenderManager {
        public MalmoRenderManager(TextureManager renderEngineIn, RenderItem itemRendererIn) {
            super(renderEngineIn, itemRendererIn);
        }

        public void renderEntityStatic(Entity entityIn, float partialTicks, boolean p_188388_3_) {
            if (isProducingColourMap) {
                currentEntity = entityIn;
                super.renderEntityStatic(entityIn, partialTicks, p_188388_3_);
                currentEntity = null;
            } else {
                super.renderEntityStatic(entityIn, partialTicks, p_188388_3_);
            }
        }
    }

    public static class MalmoEntityRenderer
    extends EntityRenderer {
        public MalmoEntityRenderer(Minecraft mcIn, IResourceManager resourceManagerIn) {
            super(mcIn, resourceManagerIn);
        }

        public void renderWorld(float partialTicks, long finishTimeNano) {
            if (isProducingColourMap) {
                colourmapFrame = true;
                Minecraft.getMinecraft().world.provider.setSkyRenderer(blankSkyRenderer);
                super.renderWorld(partialTicks, finishTimeNano);
                Minecraft.getMinecraft().world.provider.setSkyRenderer(null);
                colourmapFrame = false;
                OpenGlHelper.glUseProgram((int)0);
                GlStateManager.clear((int)16640);
                Minecraft.getMinecraft().getFramebuffer().bindFramebuffer(true);
                GlStateManager.enableTexture2D();
            }
            super.renderWorld(partialTicks, finishTimeNano);
        }
    }
}

