from splight_lib.models.database import SplightDatabaseBaseModel
from splight_lib.settings import SplightAPIVersion, api_settings

# Get API version
api_version = api_settings.API_VERSION

# Import only the models for the current version
if api_version == SplightAPIVersion.V3:
    from splight_lib.models._v3 import (
        DB_MODEL_TYPE_MAPPING,
        Action,
        AdvancedFilter,
        Alert,
        AlertItem,
        Asset,
        AssetKind,
        AssetParams,
        AssetRelationship,
        Attribute,
        Boolean,
        Bus,
        Chart,
        ChartItem,
        Component,
        ComponentObject,
        ComponentObjectInstance,
        ComponentType,
        CustomType,
        Dashboard,
        DashboardActionListChart,
        DashboardAlertEventsChart,
        DashboardAlertListChart,
        DashboardAssetListChart,
        DashboardBarChart,
        DashboardBarGaugeChart,
        DashboardCommandListChart,
        DashboardGaugeChart,
        DashboardHistogramChart,
        DashboardImageChart,
        DashboardStatChart,
        DashboardTableChart,
        DashboardTextChart,
        DashboardTimeseriesChart,
        DataAddress,
        DataRequest,
        Endpoint,
        ExternalGrid,
        File,
        Filter,
        Function,
        FunctionItem,
        Generator,
        Grid,
        HubComponent,
        HubServer,
        InputDataAddress,
        InputParameter,
        Inverter,
        Line,
        Metadata,
        Number,
        Output,
        Parameter,
        PipelineStep,
        PrivacyPolicy,
        QueryFilter,
        Routine,
        RoutineEvaluation,
        RoutineObject,
        RoutineObjectInstance,
        Secret,
        Segment,
        Server,
        SetPoint,
        SlackGenerator,
        SlackLine,
        SplightDatalakeBaseModel,
        String,
        Tab,
        Tag,
        ThreeWindingTransformer,
        Trace,
        Transformer,
        get_field_value,
    )

    __all__ = [
        "Action",
        "AdvancedFilter",
        "Alert",
        "AlertItem",
        "Asset",
        "AssetParams",
        "AssetRelationship",
        "Tag",
        "AssetKind",
        "Attribute",
        "Boolean",
        "Chart",
        "DashboardActionListChart",
        "DashboardAlertEventsChart",
        "DashboardAlertListChart",
        "DashboardAssetListChart",
        "DashboardBarChart",
        "DashboardBarGaugeChart",
        "DashboardCommandListChart",
        "DashboardGaugeChart",
        "DashboardHistogramChart",
        "DashboardImageChart",
        "DashboardStatChart",
        "DashboardTableChart",
        "DashboardTextChart",
        "DashboardTimeseriesChart",
        "ChartItem",
        "Component",
        "ComponentObject",
        "ComponentObjectInstance",
        "ComponentType",
        "CustomType",
        "DataAddress",
        "Endpoint",
        "Output",
        "InputParameter",
        "InputDataAddress",
        "PrivacyPolicy",
        "Routine",
        "get_field_value",
        "Parameter",
        "DB_MODEL_TYPE_MAPPING",
        "Dashboard",
        "DataRequest",
        "File",
        "Filter",
        "Function",
        "FunctionItem",
        "HubComponent",
        "HubServer",
        "QueryFilter",
        "Metadata",
        "Number",
        "PipelineStep",
        "SplightDatalakeBaseModel",
        "Bus",
        "ExternalGrid",
        "Generator",
        "Grid",
        "Line",
        "Inverter",
        "SlackGenerator",
        "SlackLine",
        "ThreeWindingTransformer",
        "Transformer",
        "RoutineEvaluation",
        "Secret",
        "Segment",
        "Server",
        "SetPoint",
        "String",
        "RoutineObject",
        "RoutineObjectInstance",
        "Tab",
        "Trace",
        "SplightDatabaseBaseModel",
    ]
elif api_version == SplightAPIVersion.V4:
    from splight_lib.models._v4 import (
        DB_MODEL_TYPE_MAPPING,
        Asset,
        AssetKind,
        AssetRelationship,
        Attribute,
        # AttributeDocument,
        AttributeType,
        Battery,
        Boolean,
        Bus,
        Component,
        ComponentObject,
        ComponentObjectInstance,
        ComponentType,
        CustomType,
        DataAddress,
        Endpoint,
        ExternalGrid,
        File,
        Generator,
        Grid,
        HubComponent,
        HubServer,
        InputDataAddress,
        InputParameter,
        Line,
        Load,
        Metadata,
        Number,
        Output,
        Parameter,
        PrivacyPolicy,
        # Query,
        # Records,
        ResourceSummary,
        Routine,
        RoutineEvaluation,
        RoutineObject,
        RoutineObjectInstance,
        Secret,
        Segment,
        Server,
        SlackLine,
        SolutionOutputDocument,
        SplightDatalakeBaseModel,
        String,
        Tag,
        Transformer,
        ValueType,
        get_field_value,
    )

    __all__ = [
        "Asset",
        "AssetRelationship",
        "Component",
        "RoutineObjectInstance",
        "RoutineObject",
        "RoutineEvaluation",
        "ComponentObject",
        "ComponentObjectInstance",
        "ComponentType",
        "CustomType",
        "Endpoint",
        "InputParameter",
        "Output",
        "PrivacyPolicy",
        "Routine",
        "get_field_value",
        "Parameter",
        "DB_MODEL_TYPE_MAPPING",
        "SplightDatalakeBaseModel",
        "Query",
        "Records",
        "AttributeDocument",
        "SolutionOutputDocument",
        "File",
        "DataAddress",
        "InputDataAddress",
        "HubComponent",
        "HubServer",
        "Boolean",
        "Number",
        "String",
        "Secret",
        "Server",
        "Tag",
        "Metadata",
        "Attribute",
        "ResourceSummary",
        "AssetKind",
        "ValueType",
        "AttributeType",
        "Battery",
        "Bus",
        "ExternalGrid",
        "Generator",
        "Grid",
        "Line",
        "Load",
        "Segment",
        "SlackLine",
        "Transformer",
        "SplightDatabaseBaseModel",
    ]
else:
    raise ImportError(f"No models available for API version: '{api_version}'.")
