# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProjectIamResult',
    'GetProjectsProjectResult',
    'GetProjectsProjectIamResult',
]

@pulumi.output_type
class GetProjectIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: Unique identifier of the resource in the IAM
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with `ovh:`
        :param builtins.str urn: URN of the private database, used when writing IAM policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier of the resource in the IAM
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with `ovh:`
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        URN of the private database, used when writing IAM policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 access: builtins.str,
                 creation_date: builtins.str,
                 description: builtins.str,
                 expiration: builtins.str,
                 iam: 'outputs.GetProjectsProjectIamResult',
                 manual_quota: builtins.bool,
                 order_id: builtins.float,
                 plan_code: builtins.str,
                 project_id: builtins.str,
                 project_name: builtins.str,
                 service_name: builtins.str,
                 status: builtins.str,
                 unleash: builtins.bool):
        """
        :param builtins.str access: Project access
        :param builtins.str creation_date: Project creation date
        :param builtins.str description: Description of your project
        :param builtins.str expiration: Expiration date of your project. After this date, your project will be deleted
        :param 'GetProjectsProjectIamArgs' iam: IAM resource information
        :param builtins.bool manual_quota: Manual quota prevent automatic quota upgrade
        :param builtins.float order_id: Project order ID
        :param builtins.str plan_code: Order plan code
        :param builtins.str project_id: Project ID
        :param builtins.str project_name: Project name
        :param builtins.str service_name: ID of the public cloud project
        :param builtins.str status: Current status
        :param builtins.bool unleash: Project unleashed
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expiration", expiration)
        pulumi.set(__self__, "iam", iam)
        pulumi.set(__self__, "manual_quota", manual_quota)
        pulumi.set(__self__, "order_id", order_id)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "unleash", unleash)

    @property
    @pulumi.getter
    def access(self) -> builtins.str:
        """
        Project access
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> builtins.str:
        """
        Project creation date
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of your project
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expiration(self) -> builtins.str:
        """
        Expiration date of your project. After this date, your project will be deleted
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def iam(self) -> 'outputs.GetProjectsProjectIamResult':
        """
        IAM resource information
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter(name="manualQuota")
    def manual_quota(self) -> builtins.bool:
        """
        Manual quota prevent automatic quota upgrade
        """
        return pulumi.get(self, "manual_quota")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> builtins.float:
        """
        Project order ID
        """
        return pulumi.get(self, "order_id")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> builtins.str:
        """
        Order plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> builtins.str:
        """
        Project name
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        ID of the public cloud project
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def unleash(self) -> builtins.bool:
        """
        Project unleashed
        """
        return pulumi.get(self, "unleash")


@pulumi.output_type
class GetProjectsProjectIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: Unique identifier of the resource in the IAM
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with `ovh:`
        :param builtins.str urn: URN of the private database, used when writing IAM policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier of the resource in the IAM
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with `ovh:`
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        URN of the private database, used when writing IAM policies
        """
        return pulumi.get(self, "urn")


