# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudProjectSshKeyArgs', 'CloudProjectSshKey']

@pulumi.input_type
class CloudProjectSshKeyArgs:
    def __init__(__self__, *,
                 public_key: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CloudProjectSshKey resource.
        :param pulumi.Input[builtins.str] public_key: SSH public key
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] name: SSH key name
        :param pulumi.Input[builtins.str] region: Region to create SSH key
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "service_name", service_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[builtins.str]:
        """
        SSH public key
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSH key name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region to create SSH key
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _CloudProjectSshKeyState:
    def __init__(__self__, *,
                 finger_print: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudProjectSshKey resources.
        :param pulumi.Input[builtins.str] finger_print: SSH key fingerprint
        :param pulumi.Input[builtins.str] name: SSH key name
        :param pulumi.Input[builtins.str] public_key: SSH public key
        :param pulumi.Input[builtins.str] region: Region to create SSH key
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: SSH key regions
        :param pulumi.Input[builtins.str] service_name: Service name
        """
        if finger_print is not None:
            pulumi.set(__self__, "finger_print", finger_print)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSH key fingerprint
        """
        return pulumi.get(self, "finger_print")

    @finger_print.setter
    def finger_print(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "finger_print", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSH key name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSH public key
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region to create SSH key
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        SSH key regions
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.type_token("ovh:index/cloudProjectSshKey:CloudProjectSshKey")
class CloudProjectSshKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a SSH key in the given public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        key = ovh.CloudProjectSshKey("key",
            service_name="<public cloud project ID>",
            public_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQC9xPpdqP3sx2H+gcBm65tJEaUbuifQ1uGkgrWtNY0PRKNNPdy+3yoVOtxk6Vjo4YZ0EU/JhmQfnrK7X7Q5vhqYxmozi0LiTRt0BxgqHJ+4hWTWMIOgr+C2jLx7ZsCReRk+fy5AHr6h0PHQEuXVLXeUy/TDyuY2JPtUZ5jcqvLYgQ== my-key",
            name="new_key")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: SSH key name
        :param pulumi.Input[builtins.str] public_key: SSH public key
        :param pulumi.Input[builtins.str] region: Region to create SSH key
        :param pulumi.Input[builtins.str] service_name: Service name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudProjectSshKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SSH key in the given public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        key = ovh.CloudProjectSshKey("key",
            service_name="<public cloud project ID>",
            public_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQC9xPpdqP3sx2H+gcBm65tJEaUbuifQ1uGkgrWtNY0PRKNNPdy+3yoVOtxk6Vjo4YZ0EU/JhmQfnrK7X7Q5vhqYxmozi0LiTRt0BxgqHJ+4hWTWMIOgr+C2jLx7ZsCReRk+fy5AHr6h0PHQEuXVLXeUy/TDyuY2JPtUZ5jcqvLYgQ== my-key",
            name="new_key")
        ```

        :param str resource_name: The name of the resource.
        :param CloudProjectSshKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudProjectSshKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_key: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudProjectSshKeyArgs.__new__(CloudProjectSshKeyArgs)

            __props__.__dict__["name"] = name
            if public_key is None and not opts.urn:
                raise TypeError("Missing required property 'public_key'")
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["region"] = region
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["finger_print"] = None
            __props__.__dict__["regions"] = None
        super(CloudProjectSshKey, __self__).__init__(
            'ovh:index/cloudProjectSshKey:CloudProjectSshKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            finger_print: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            public_key: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None) -> 'CloudProjectSshKey':
        """
        Get an existing CloudProjectSshKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] finger_print: SSH key fingerprint
        :param pulumi.Input[builtins.str] name: SSH key name
        :param pulumi.Input[builtins.str] public_key: SSH public key
        :param pulumi.Input[builtins.str] region: Region to create SSH key
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] regions: SSH key regions
        :param pulumi.Input[builtins.str] service_name: Service name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudProjectSshKeyState.__new__(_CloudProjectSshKeyState)

        __props__.__dict__["finger_print"] = finger_print
        __props__.__dict__["name"] = name
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["region"] = region
        __props__.__dict__["regions"] = regions
        __props__.__dict__["service_name"] = service_name
        return CloudProjectSshKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> pulumi.Output[builtins.str]:
        """
        SSH key fingerprint
        """
        return pulumi.get(self, "finger_print")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        SSH key name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[builtins.str]:
        """
        SSH public key
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region to create SSH key
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        SSH key regions
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

