# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ContainerRegistryIPRestrictionsManagementArgs', 'ContainerRegistryIPRestrictionsManagement']

@pulumi.input_type
class ContainerRegistryIPRestrictionsManagementArgs:
    def __init__(__self__, *,
                 ip_restrictions: pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]],
                 registry_id: pulumi.Input[builtins.str],
                 service_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ContainerRegistryIPRestrictionsManagement resource.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] ip_restrictions: IP restrictions applied on Harbor UI and API.
        :param pulumi.Input[builtins.str] registry_id: The id of the Managed Private Registry.
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        pulumi.set(__self__, "registry_id", registry_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]:
        """
        IP restrictions applied on Harbor UI and API.
        """
        return pulumi.get(self, "ip_restrictions")

    @ip_restrictions.setter
    def ip_restrictions(self, value: pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]):
        pulumi.set(self, "ip_restrictions", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the Managed Private Registry.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "registry_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _ContainerRegistryIPRestrictionsManagementState:
    def __init__(__self__, *,
                 ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerRegistryIPRestrictionsManagement resources.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] ip_restrictions: IP restrictions applied on Harbor UI and API.
        :param pulumi.Input[builtins.str] registry_id: The id of the Managed Private Registry.
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        if ip_restrictions is not None:
            pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]:
        """
        IP restrictions applied on Harbor UI and API.
        """
        return pulumi.get(self, "ip_restrictions")

    @ip_restrictions.setter
    def ip_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "ip_restrictions", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the Managed Private Registry.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.type_token("ovh:CloudProject/containerRegistryIPRestrictionsManagement:ContainerRegistryIPRestrictionsManagement")
class ContainerRegistryIPRestrictionsManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Apply IP restrictions container registry associated with a public cloud project on Harbor UI and API.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        registry = ovh.CloudProject.get_container_registry(service_name="XXXXXX",
            registry_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx")
        my_mgt_iprestrictions = ovh.cloud_project.ContainerRegistryIPRestrictionsManagement("my_mgt_iprestrictions",
            service_name=registry_ovh_cloud_project_containerregistry["serviceName"],
            registry_id=registry_ovh_cloud_project_containerregistry["id"],
            ip_restrictions=[{
                "ip_block": "xxx.xxx.xxx.xxx/xx",
                "description": "xxxxxxx",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] ip_restrictions: IP restrictions applied on Harbor UI and API.
        :param pulumi.Input[builtins.str] registry_id: The id of the Managed Private Registry.
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerRegistryIPRestrictionsManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Apply IP restrictions container registry associated with a public cloud project on Harbor UI and API.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        registry = ovh.CloudProject.get_container_registry(service_name="XXXXXX",
            registry_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx")
        my_mgt_iprestrictions = ovh.cloud_project.ContainerRegistryIPRestrictionsManagement("my_mgt_iprestrictions",
            service_name=registry_ovh_cloud_project_containerregistry["serviceName"],
            registry_id=registry_ovh_cloud_project_containerregistry["id"],
            ip_restrictions=[{
                "ip_block": "xxx.xxx.xxx.xxx/xx",
                "description": "xxxxxxx",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ContainerRegistryIPRestrictionsManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerRegistryIPRestrictionsManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerRegistryIPRestrictionsManagementArgs.__new__(ContainerRegistryIPRestrictionsManagementArgs)

            if ip_restrictions is None and not opts.urn:
                raise TypeError("Missing required property 'ip_restrictions'")
            __props__.__dict__["ip_restrictions"] = ip_restrictions
            if registry_id is None and not opts.urn:
                raise TypeError("Missing required property 'registry_id'")
            __props__.__dict__["registry_id"] = registry_id
            __props__.__dict__["service_name"] = service_name
        super(ContainerRegistryIPRestrictionsManagement, __self__).__init__(
            'ovh:CloudProject/containerRegistryIPRestrictionsManagement:ContainerRegistryIPRestrictionsManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
            registry_id: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None) -> 'ContainerRegistryIPRestrictionsManagement':
        """
        Get an existing ContainerRegistryIPRestrictionsManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] ip_restrictions: IP restrictions applied on Harbor UI and API.
        :param pulumi.Input[builtins.str] registry_id: The id of the Managed Private Registry.
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerRegistryIPRestrictionsManagementState.__new__(_ContainerRegistryIPRestrictionsManagementState)

        __props__.__dict__["ip_restrictions"] = ip_restrictions
        __props__.__dict__["registry_id"] = registry_id
        __props__.__dict__["service_name"] = service_name
        return ContainerRegistryIPRestrictionsManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> pulumi.Output[Sequence[Mapping[str, builtins.str]]]:
        """
        IP restrictions applied on Harbor UI and API.
        """
        return pulumi.get(self, "ip_restrictions")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the Managed Private Registry.
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

