# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[builtins.str],
                 flavor: pulumi.Input[builtins.str],
                 nodes: pulumi.Input[Sequence[pulumi.Input['DatabaseNodeArgs']]],
                 plan: pulumi.Input[builtins.str],
                 version: pulumi.Input[builtins.str],
                 advanced_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 backup_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backup_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseIpRestrictionArgs']]]] = None,
                 kafka_rest_api: Optional[pulumi.Input[builtins.bool]] = None,
                 kafka_schema_registry: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenance_time: Optional[pulumi.Input[builtins.str]] = None,
                 opensearch_acls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[builtins.str] engine: The database engine you want to deploy. To get a full list of available engine visit. [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
        :param pulumi.Input[builtins.str] flavor: A valid OVHcloud public cloud database flavor name in which the nodes will be started. Ex: "db1-7". Changing this value upgrade the nodes with the new flavor. You can find the list of flavor names: https://www.ovhcloud.com/fr/public-cloud/prices/
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseNodeArgs']]] nodes: List of nodes object. Multi region cluster are not yet available, all node should be identical.
        :param pulumi.Input[builtins.str] plan: Plan of the cluster.
               * MongoDB: Enum: "discovery", "production", "advanced".
               * Mysql, PosgreSQL, Cassandra, M3DB, : Enum: "essential", "business", "enterprise".
               * M3 Aggregator: "business", "enterprise".
               * Redis: "essential", "business".
               * Valkey: "essential", "business".
        :param pulumi.Input[builtins.str] version: The version of the engine in which the service should be deployed
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] advanced_configuration: Advanced configuration key / value.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_regions: List of region where backups are pushed. Not more than 1 regions for MongoDB. Not more than 2 regions for the other engines with one being the same as the nodes[].region field
        :param pulumi.Input[builtins.str] backup_time: Time on which backups start every day (this parameter is not usable on the following engines: "m3db", "grafana", "kafka", "kafkaconnect", "kafkamirrormaker", "opensearch", "m3aggregator").
        :param pulumi.Input[builtins.str] description: Small description of the database service.
        :param pulumi.Input[builtins.int] disk_size: The disk size (in GB) of the database service.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseIpRestrictionArgs']]] ip_restrictions: IP Blocks authorized to access to the cluster.
        :param pulumi.Input[builtins.bool] kafka_rest_api: Defines whether the REST API is enabled on a kafka cluster
        :param pulumi.Input[builtins.bool] kafka_schema_registry: Defines whether the schema registry is enabled on a Kafka cluster
        :param pulumi.Input[builtins.str] maintenance_time: Time on which maintenances can start every day.
        :param pulumi.Input[builtins.bool] opensearch_acls_enabled: Defines whether the ACLs are enabled on an OpenSearch cluster
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "version", version)
        if advanced_configuration is not None:
            pulumi.set(__self__, "advanced_configuration", advanced_configuration)
        if backup_regions is not None:
            pulumi.set(__self__, "backup_regions", backup_regions)
        if backup_time is not None:
            pulumi.set(__self__, "backup_time", backup_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if ip_restrictions is not None:
            pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        if kafka_rest_api is not None:
            pulumi.set(__self__, "kafka_rest_api", kafka_rest_api)
        if kafka_schema_registry is not None:
            pulumi.set(__self__, "kafka_schema_registry", kafka_schema_registry)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if opensearch_acls_enabled is not None:
            pulumi.set(__self__, "opensearch_acls_enabled", opensearch_acls_enabled)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[builtins.str]:
        """
        The database engine you want to deploy. To get a full list of available engine visit. [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[builtins.str]:
        """
        A valid OVHcloud public cloud database flavor name in which the nodes will be started. Ex: "db1-7". Changing this value upgrade the nodes with the new flavor. You can find the list of flavor names: https://www.ovhcloud.com/fr/public-cloud/prices/
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Input[Sequence[pulumi.Input['DatabaseNodeArgs']]]:
        """
        List of nodes object. Multi region cluster are not yet available, all node should be identical.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: pulumi.Input[Sequence[pulumi.Input['DatabaseNodeArgs']]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[builtins.str]:
        """
        Plan of the cluster.
        * MongoDB: Enum: "discovery", "production", "advanced".
        * Mysql, PosgreSQL, Cassandra, M3DB, : Enum: "essential", "business", "enterprise".
        * M3 Aggregator: "business", "enterprise".
        * Redis: "essential", "business".
        * Valkey: "essential", "business".
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the engine in which the service should be deployed
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="advancedConfiguration")
    def advanced_configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Advanced configuration key / value.
        """
        return pulumi.get(self, "advanced_configuration")

    @advanced_configuration.setter
    def advanced_configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "advanced_configuration", value)

    @property
    @pulumi.getter(name="backupRegions")
    def backup_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of region where backups are pushed. Not more than 1 regions for MongoDB. Not more than 2 regions for the other engines with one being the same as the nodes[].region field
        """
        return pulumi.get(self, "backup_regions")

    @backup_regions.setter
    def backup_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backup_regions", value)

    @property
    @pulumi.getter(name="backupTime")
    def backup_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time on which backups start every day (this parameter is not usable on the following engines: "m3db", "grafana", "kafka", "kafkaconnect", "kafkamirrormaker", "opensearch", "m3aggregator").
        """
        return pulumi.get(self, "backup_time")

    @backup_time.setter
    def backup_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Small description of the database service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The disk size (in GB) of the database service.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseIpRestrictionArgs']]]]:
        """
        IP Blocks authorized to access to the cluster.
        """
        return pulumi.get(self, "ip_restrictions")

    @ip_restrictions.setter
    def ip_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseIpRestrictionArgs']]]]):
        pulumi.set(self, "ip_restrictions", value)

    @property
    @pulumi.getter(name="kafkaRestApi")
    def kafka_rest_api(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether the REST API is enabled on a kafka cluster
        """
        return pulumi.get(self, "kafka_rest_api")

    @kafka_rest_api.setter
    def kafka_rest_api(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kafka_rest_api", value)

    @property
    @pulumi.getter(name="kafkaSchemaRegistry")
    def kafka_schema_registry(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether the schema registry is enabled on a Kafka cluster
        """
        return pulumi.get(self, "kafka_schema_registry")

    @kafka_schema_registry.setter
    def kafka_schema_registry(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kafka_schema_registry", value)

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time on which maintenances can start every day.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_time", value)

    @property
    @pulumi.getter(name="opensearchAclsEnabled")
    def opensearch_acls_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether the ACLs are enabled on an OpenSearch cluster
        """
        return pulumi.get(self, "opensearch_acls_enabled")

    @opensearch_acls_enabled.setter
    def opensearch_acls_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "opensearch_acls_enabled", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 advanced_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 backup_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backup_time: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseEndpointArgs']]]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 flavor: Optional[pulumi.Input[builtins.str]] = None,
                 ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseIpRestrictionArgs']]]] = None,
                 kafka_rest_api: Optional[pulumi.Input[builtins.bool]] = None,
                 kafka_schema_registry: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenance_time: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseNodeArgs']]]] = None,
                 opensearch_acls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] advanced_configuration: Advanced configuration key / value.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_regions: List of region where backups are pushed. Not more than 1 regions for MongoDB. Not more than 2 regions for the other engines with one being the same as the nodes[].region field
        :param pulumi.Input[builtins.str] backup_time: Time on which backups start every day (this parameter is not usable on the following engines: "m3db", "grafana", "kafka", "kafkaconnect", "kafkamirrormaker", "opensearch", "m3aggregator").
        :param pulumi.Input[builtins.str] created_at: Date of the creation of the cluster.
        :param pulumi.Input[builtins.str] description: Small description of the database service.
        :param pulumi.Input[builtins.int] disk_size: The disk size (in GB) of the database service.
        :param pulumi.Input[builtins.str] disk_type: Defines the disk type of the database service.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseEndpointArgs']]] endpoints: List of all endpoints objects of the service.
        :param pulumi.Input[builtins.str] engine: The database engine you want to deploy. To get a full list of available engine visit. [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
        :param pulumi.Input[builtins.str] flavor: A valid OVHcloud public cloud database flavor name in which the nodes will be started. Ex: "db1-7". Changing this value upgrade the nodes with the new flavor. You can find the list of flavor names: https://www.ovhcloud.com/fr/public-cloud/prices/
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseIpRestrictionArgs']]] ip_restrictions: IP Blocks authorized to access to the cluster.
        :param pulumi.Input[builtins.bool] kafka_rest_api: Defines whether the REST API is enabled on a kafka cluster
        :param pulumi.Input[builtins.bool] kafka_schema_registry: Defines whether the schema registry is enabled on a Kafka cluster
        :param pulumi.Input[builtins.str] maintenance_time: Time on which maintenances can start every day.
        :param pulumi.Input[builtins.str] network_type: Type of network of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseNodeArgs']]] nodes: List of nodes object. Multi region cluster are not yet available, all node should be identical.
        :param pulumi.Input[builtins.bool] opensearch_acls_enabled: Defines whether the ACLs are enabled on an OpenSearch cluster
        :param pulumi.Input[builtins.str] plan: Plan of the cluster.
               * MongoDB: Enum: "discovery", "production", "advanced".
               * Mysql, PosgreSQL, Cassandra, M3DB, : Enum: "essential", "business", "enterprise".
               * M3 Aggregator: "business", "enterprise".
               * Redis: "essential", "business".
               * Valkey: "essential", "business".
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[builtins.str] status: Current status of the cluster.
        :param pulumi.Input[builtins.str] version: The version of the engine in which the service should be deployed
        """
        if advanced_configuration is not None:
            pulumi.set(__self__, "advanced_configuration", advanced_configuration)
        if backup_regions is not None:
            pulumi.set(__self__, "backup_regions", backup_regions)
        if backup_time is not None:
            pulumi.set(__self__, "backup_time", backup_time)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if ip_restrictions is not None:
            pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        if kafka_rest_api is not None:
            pulumi.set(__self__, "kafka_rest_api", kafka_rest_api)
        if kafka_schema_registry is not None:
            pulumi.set(__self__, "kafka_schema_registry", kafka_schema_registry)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if opensearch_acls_enabled is not None:
            pulumi.set(__self__, "opensearch_acls_enabled", opensearch_acls_enabled)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="advancedConfiguration")
    def advanced_configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Advanced configuration key / value.
        """
        return pulumi.get(self, "advanced_configuration")

    @advanced_configuration.setter
    def advanced_configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "advanced_configuration", value)

    @property
    @pulumi.getter(name="backupRegions")
    def backup_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of region where backups are pushed. Not more than 1 regions for MongoDB. Not more than 2 regions for the other engines with one being the same as the nodes[].region field
        """
        return pulumi.get(self, "backup_regions")

    @backup_regions.setter
    def backup_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "backup_regions", value)

    @property
    @pulumi.getter(name="backupTime")
    def backup_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time on which backups start every day (this parameter is not usable on the following engines: "m3db", "grafana", "kafka", "kafkaconnect", "kafkamirrormaker", "opensearch", "m3aggregator").
        """
        return pulumi.get(self, "backup_time")

    @backup_time.setter
    def backup_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_time", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date of the creation of the cluster.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Small description of the database service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The disk size (in GB) of the database service.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the disk type of the database service.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseEndpointArgs']]]]:
        """
        List of all endpoints objects of the service.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database engine you want to deploy. To get a full list of available engine visit. [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A valid OVHcloud public cloud database flavor name in which the nodes will be started. Ex: "db1-7". Changing this value upgrade the nodes with the new flavor. You can find the list of flavor names: https://www.ovhcloud.com/fr/public-cloud/prices/
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseIpRestrictionArgs']]]]:
        """
        IP Blocks authorized to access to the cluster.
        """
        return pulumi.get(self, "ip_restrictions")

    @ip_restrictions.setter
    def ip_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseIpRestrictionArgs']]]]):
        pulumi.set(self, "ip_restrictions", value)

    @property
    @pulumi.getter(name="kafkaRestApi")
    def kafka_rest_api(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether the REST API is enabled on a kafka cluster
        """
        return pulumi.get(self, "kafka_rest_api")

    @kafka_rest_api.setter
    def kafka_rest_api(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kafka_rest_api", value)

    @property
    @pulumi.getter(name="kafkaSchemaRegistry")
    def kafka_schema_registry(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether the schema registry is enabled on a Kafka cluster
        """
        return pulumi.get(self, "kafka_schema_registry")

    @kafka_schema_registry.setter
    def kafka_schema_registry(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "kafka_schema_registry", value)

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time on which maintenances can start every day.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_time", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of network of the cluster.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseNodeArgs']]]]:
        """
        List of nodes object. Multi region cluster are not yet available, all node should be identical.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="opensearchAclsEnabled")
    def opensearch_acls_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether the ACLs are enabled on an OpenSearch cluster
        """
        return pulumi.get(self, "opensearch_acls_enabled")

    @opensearch_acls_enabled.setter
    def opensearch_acls_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "opensearch_acls_enabled", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Plan of the cluster.
        * MongoDB: Enum: "discovery", "production", "advanced".
        * Mysql, PosgreSQL, Cassandra, M3DB, : Enum: "essential", "business", "enterprise".
        * M3 Aggregator: "business", "enterprise".
        * Redis: "essential", "business".
        * Valkey: "essential", "business".
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current status of the cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the engine in which the service should be deployed
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("ovh:CloudProject/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 backup_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backup_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 flavor: Optional[pulumi.Input[builtins.str]] = None,
                 ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseIpRestrictionArgs', 'DatabaseIpRestrictionArgsDict']]]]] = None,
                 kafka_rest_api: Optional[pulumi.Input[builtins.bool]] = None,
                 kafka_schema_registry: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenance_time: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseNodeArgs', 'DatabaseNodeArgsDict']]]]] = None,
                 opensearch_acls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        Minimum settings for each engine (region choice is up to the user):

        ```python
        import pulumi
        import pulumi_ovh as ovh

        cassandradb = ovh.cloud_project.Database("cassandradb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-cassandra",
            engine="cassandra",
            version="4.0",
            plan="essential",
            nodes=[
                {
                    "region": "BHS",
                },
                {
                    "region": "BHS",
                },
                {
                    "region": "BHS",
                },
            ],
            flavor="db1-4")
        kafkadb = ovh.cloud_project.Database("kafkadb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-kafka",
            engine="kafka",
            version="3.8",
            flavor="db1-4",
            plan="business",
            kafka_rest_api=True,
            kafka_schema_registry=True,
            nodes=[
                {
                    "region": "DE",
                },
                {
                    "region": "DE",
                },
                {
                    "region": "DE",
                },
            ])
        m3db = ovh.cloud_project.Database("m3db",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-m3db",
            engine="m3db",
            version="1.2",
            plan="essential",
            nodes=[{
                "region": "BHS",
            }],
            flavor="db1-7")
        mongodb = ovh.cloud_project.Database("mongodb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-mongodb",
            engine="mongodb",
            version="5.0",
            plan="discovery",
            nodes=[{
                "region": "GRA",
            }],
            flavor="db1-2")
        mysqldb = ovh.cloud_project.Database("mysqldb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-mysql",
            engine="mysql",
            version="8",
            plan="essential",
            nodes=[{
                "region": "SBG",
            }],
            flavor="db1-4",
            advanced_configuration={
                "mysql.sql_mode": "ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES",
                "mysql.sql_require_primary_key": "true",
            })
        opensearchdb = ovh.cloud_project.Database("opensearchdb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-opensearch",
            engine="opensearch",
            version="1",
            plan="essential",
            opensearch_acls_enabled=True,
            nodes=[{
                "region": "UK",
            }],
            flavor="db1-4")
        pgsqldb = ovh.cloud_project.Database("pgsqldb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-postgresql",
            engine="postgresql",
            version="14",
            plan="essential",
            nodes=[{
                "region": "WAW",
            }],
            flavor="db1-4",
            ip_restrictions=[
                {
                    "description": "ip 1",
                    "ip": "178.97.6.0/24",
                },
                {
                    "description": "ip 2",
                    "ip": "178.97.7.0/24",
                },
            ])
        redisdb = ovh.cloud_project.Database("redisdb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-redis",
            engine="redis",
            version="6.2",
            plan="essential",
            nodes=[{
                "region": "BHS",
            }],
            flavor="db1-4")
        grafana = ovh.cloud_project.Database("grafana",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-grafana",
            engine="grafana",
            version="9.1",
            plan="essential",
            nodes=[{
                "region": "GRA",
            }],
            flavor="db1-4")
        valkeydb = ovh.cloud_project.Database("valkeydb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-valkey",
            engine="valkey",
            version="8.0",
            plan="essential",
            nodes=[{
                "region": "BHS",
            }],
            flavor="db1-4")
        ```

        To deploy a business PostgreSQL service with two nodes on public network:

        ```python
        import pulumi
        import pulumi_ovh as ovh

        postgresql = ovh.cloud_project.Database("postgresql",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-postgresql",
            engine="postgresql",
            version="14",
            plan="business",
            nodes=[
                {
                    "region": "GRA",
                },
                {
                    "region": "GRA",
                },
            ],
            flavor="db1-15")
        ```

        To deploy an enterprise MongoDB service with three nodes on private network:

        ```python
        import pulumi
        import pulumi_ovh as ovh

        mongodb = ovh.cloud_project.Database("mongodb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-mongodb",
            engine="mongodb",
            version="5.0",
            plan="production",
            nodes=[
                {
                    "region": "SBG",
                    "subnet_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                    "network_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                },
                {
                    "region": "SBG",
                    "subnet_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                    "network_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                },
                {
                    "region": "SBG",
                    "subnet_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                    "network_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                },
            ],
            flavor="db1-30")
        ```

        ## Import

        OVHcloud Managed database clusters can be imported using the `service_name`, `engine`, `id` of the cluster, separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:CloudProject/database:Database my_database_cluster service_name/engine/id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] advanced_configuration: Advanced configuration key / value.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_regions: List of region where backups are pushed. Not more than 1 regions for MongoDB. Not more than 2 regions for the other engines with one being the same as the nodes[].region field
        :param pulumi.Input[builtins.str] backup_time: Time on which backups start every day (this parameter is not usable on the following engines: "m3db", "grafana", "kafka", "kafkaconnect", "kafkamirrormaker", "opensearch", "m3aggregator").
        :param pulumi.Input[builtins.str] description: Small description of the database service.
        :param pulumi.Input[builtins.int] disk_size: The disk size (in GB) of the database service.
        :param pulumi.Input[builtins.str] engine: The database engine you want to deploy. To get a full list of available engine visit. [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
        :param pulumi.Input[builtins.str] flavor: A valid OVHcloud public cloud database flavor name in which the nodes will be started. Ex: "db1-7". Changing this value upgrade the nodes with the new flavor. You can find the list of flavor names: https://www.ovhcloud.com/fr/public-cloud/prices/
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseIpRestrictionArgs', 'DatabaseIpRestrictionArgsDict']]]] ip_restrictions: IP Blocks authorized to access to the cluster.
        :param pulumi.Input[builtins.bool] kafka_rest_api: Defines whether the REST API is enabled on a kafka cluster
        :param pulumi.Input[builtins.bool] kafka_schema_registry: Defines whether the schema registry is enabled on a Kafka cluster
        :param pulumi.Input[builtins.str] maintenance_time: Time on which maintenances can start every day.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseNodeArgs', 'DatabaseNodeArgsDict']]]] nodes: List of nodes object. Multi region cluster are not yet available, all node should be identical.
        :param pulumi.Input[builtins.bool] opensearch_acls_enabled: Defines whether the ACLs are enabled on an OpenSearch cluster
        :param pulumi.Input[builtins.str] plan: Plan of the cluster.
               * MongoDB: Enum: "discovery", "production", "advanced".
               * Mysql, PosgreSQL, Cassandra, M3DB, : Enum: "essential", "business", "enterprise".
               * M3 Aggregator: "business", "enterprise".
               * Redis: "essential", "business".
               * Valkey: "essential", "business".
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[builtins.str] version: The version of the engine in which the service should be deployed
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Minimum settings for each engine (region choice is up to the user):

        ```python
        import pulumi
        import pulumi_ovh as ovh

        cassandradb = ovh.cloud_project.Database("cassandradb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-cassandra",
            engine="cassandra",
            version="4.0",
            plan="essential",
            nodes=[
                {
                    "region": "BHS",
                },
                {
                    "region": "BHS",
                },
                {
                    "region": "BHS",
                },
            ],
            flavor="db1-4")
        kafkadb = ovh.cloud_project.Database("kafkadb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-kafka",
            engine="kafka",
            version="3.8",
            flavor="db1-4",
            plan="business",
            kafka_rest_api=True,
            kafka_schema_registry=True,
            nodes=[
                {
                    "region": "DE",
                },
                {
                    "region": "DE",
                },
                {
                    "region": "DE",
                },
            ])
        m3db = ovh.cloud_project.Database("m3db",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-m3db",
            engine="m3db",
            version="1.2",
            plan="essential",
            nodes=[{
                "region": "BHS",
            }],
            flavor="db1-7")
        mongodb = ovh.cloud_project.Database("mongodb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-mongodb",
            engine="mongodb",
            version="5.0",
            plan="discovery",
            nodes=[{
                "region": "GRA",
            }],
            flavor="db1-2")
        mysqldb = ovh.cloud_project.Database("mysqldb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-mysql",
            engine="mysql",
            version="8",
            plan="essential",
            nodes=[{
                "region": "SBG",
            }],
            flavor="db1-4",
            advanced_configuration={
                "mysql.sql_mode": "ANSI,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION,NO_ZERO_DATE,NO_ZERO_IN_DATE,STRICT_ALL_TABLES",
                "mysql.sql_require_primary_key": "true",
            })
        opensearchdb = ovh.cloud_project.Database("opensearchdb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-opensearch",
            engine="opensearch",
            version="1",
            plan="essential",
            opensearch_acls_enabled=True,
            nodes=[{
                "region": "UK",
            }],
            flavor="db1-4")
        pgsqldb = ovh.cloud_project.Database("pgsqldb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-postgresql",
            engine="postgresql",
            version="14",
            plan="essential",
            nodes=[{
                "region": "WAW",
            }],
            flavor="db1-4",
            ip_restrictions=[
                {
                    "description": "ip 1",
                    "ip": "178.97.6.0/24",
                },
                {
                    "description": "ip 2",
                    "ip": "178.97.7.0/24",
                },
            ])
        redisdb = ovh.cloud_project.Database("redisdb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-redis",
            engine="redis",
            version="6.2",
            plan="essential",
            nodes=[{
                "region": "BHS",
            }],
            flavor="db1-4")
        grafana = ovh.cloud_project.Database("grafana",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-grafana",
            engine="grafana",
            version="9.1",
            plan="essential",
            nodes=[{
                "region": "GRA",
            }],
            flavor="db1-4")
        valkeydb = ovh.cloud_project.Database("valkeydb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-valkey",
            engine="valkey",
            version="8.0",
            plan="essential",
            nodes=[{
                "region": "BHS",
            }],
            flavor="db1-4")
        ```

        To deploy a business PostgreSQL service with two nodes on public network:

        ```python
        import pulumi
        import pulumi_ovh as ovh

        postgresql = ovh.cloud_project.Database("postgresql",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-postgresql",
            engine="postgresql",
            version="14",
            plan="business",
            nodes=[
                {
                    "region": "GRA",
                },
                {
                    "region": "GRA",
                },
            ],
            flavor="db1-15")
        ```

        To deploy an enterprise MongoDB service with three nodes on private network:

        ```python
        import pulumi
        import pulumi_ovh as ovh

        mongodb = ovh.cloud_project.Database("mongodb",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            description="my-first-mongodb",
            engine="mongodb",
            version="5.0",
            plan="production",
            nodes=[
                {
                    "region": "SBG",
                    "subnet_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                    "network_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                },
                {
                    "region": "SBG",
                    "subnet_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                    "network_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                },
                {
                    "region": "SBG",
                    "subnet_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                    "network_id": "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX",
                },
            ],
            flavor="db1-30")
        ```

        ## Import

        OVHcloud Managed database clusters can be imported using the `service_name`, `engine`, `id` of the cluster, separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:CloudProject/database:Database my_database_cluster service_name/engine/id
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 backup_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backup_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 flavor: Optional[pulumi.Input[builtins.str]] = None,
                 ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseIpRestrictionArgs', 'DatabaseIpRestrictionArgsDict']]]]] = None,
                 kafka_rest_api: Optional[pulumi.Input[builtins.bool]] = None,
                 kafka_schema_registry: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenance_time: Optional[pulumi.Input[builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseNodeArgs', 'DatabaseNodeArgsDict']]]]] = None,
                 opensearch_acls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["advanced_configuration"] = advanced_configuration
            __props__.__dict__["backup_regions"] = backup_regions
            __props__.__dict__["backup_time"] = backup_time
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_size"] = disk_size
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["ip_restrictions"] = ip_restrictions
            __props__.__dict__["kafka_rest_api"] = kafka_rest_api
            __props__.__dict__["kafka_schema_registry"] = kafka_schema_registry
            __props__.__dict__["maintenance_time"] = maintenance_time
            if nodes is None and not opts.urn:
                raise TypeError("Missing required property 'nodes'")
            __props__.__dict__["nodes"] = nodes
            __props__.__dict__["opensearch_acls_enabled"] = opensearch_acls_enabled
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            __props__.__dict__["service_name"] = service_name
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["created_at"] = None
            __props__.__dict__["disk_type"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["network_type"] = None
            __props__.__dict__["status"] = None
        super(Database, __self__).__init__(
            'ovh:CloudProject/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            backup_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            backup_time: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disk_size: Optional[pulumi.Input[builtins.int]] = None,
            disk_type: Optional[pulumi.Input[builtins.str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseEndpointArgs', 'DatabaseEndpointArgsDict']]]]] = None,
            engine: Optional[pulumi.Input[builtins.str]] = None,
            flavor: Optional[pulumi.Input[builtins.str]] = None,
            ip_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseIpRestrictionArgs', 'DatabaseIpRestrictionArgsDict']]]]] = None,
            kafka_rest_api: Optional[pulumi.Input[builtins.bool]] = None,
            kafka_schema_registry: Optional[pulumi.Input[builtins.bool]] = None,
            maintenance_time: Optional[pulumi.Input[builtins.str]] = None,
            network_type: Optional[pulumi.Input[builtins.str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseNodeArgs', 'DatabaseNodeArgsDict']]]]] = None,
            opensearch_acls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            plan: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] advanced_configuration: Advanced configuration key / value.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] backup_regions: List of region where backups are pushed. Not more than 1 regions for MongoDB. Not more than 2 regions for the other engines with one being the same as the nodes[].region field
        :param pulumi.Input[builtins.str] backup_time: Time on which backups start every day (this parameter is not usable on the following engines: "m3db", "grafana", "kafka", "kafkaconnect", "kafkamirrormaker", "opensearch", "m3aggregator").
        :param pulumi.Input[builtins.str] created_at: Date of the creation of the cluster.
        :param pulumi.Input[builtins.str] description: Small description of the database service.
        :param pulumi.Input[builtins.int] disk_size: The disk size (in GB) of the database service.
        :param pulumi.Input[builtins.str] disk_type: Defines the disk type of the database service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseEndpointArgs', 'DatabaseEndpointArgsDict']]]] endpoints: List of all endpoints objects of the service.
        :param pulumi.Input[builtins.str] engine: The database engine you want to deploy. To get a full list of available engine visit. [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
        :param pulumi.Input[builtins.str] flavor: A valid OVHcloud public cloud database flavor name in which the nodes will be started. Ex: "db1-7". Changing this value upgrade the nodes with the new flavor. You can find the list of flavor names: https://www.ovhcloud.com/fr/public-cloud/prices/
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseIpRestrictionArgs', 'DatabaseIpRestrictionArgsDict']]]] ip_restrictions: IP Blocks authorized to access to the cluster.
        :param pulumi.Input[builtins.bool] kafka_rest_api: Defines whether the REST API is enabled on a kafka cluster
        :param pulumi.Input[builtins.bool] kafka_schema_registry: Defines whether the schema registry is enabled on a Kafka cluster
        :param pulumi.Input[builtins.str] maintenance_time: Time on which maintenances can start every day.
        :param pulumi.Input[builtins.str] network_type: Type of network of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseNodeArgs', 'DatabaseNodeArgsDict']]]] nodes: List of nodes object. Multi region cluster are not yet available, all node should be identical.
        :param pulumi.Input[builtins.bool] opensearch_acls_enabled: Defines whether the ACLs are enabled on an OpenSearch cluster
        :param pulumi.Input[builtins.str] plan: Plan of the cluster.
               * MongoDB: Enum: "discovery", "production", "advanced".
               * Mysql, PosgreSQL, Cassandra, M3DB, : Enum: "essential", "business", "enterprise".
               * M3 Aggregator: "business", "enterprise".
               * Redis: "essential", "business".
               * Valkey: "essential", "business".
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[builtins.str] status: Current status of the cluster.
        :param pulumi.Input[builtins.str] version: The version of the engine in which the service should be deployed
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["advanced_configuration"] = advanced_configuration
        __props__.__dict__["backup_regions"] = backup_regions
        __props__.__dict__["backup_time"] = backup_time
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["disk_type"] = disk_type
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["engine"] = engine
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["ip_restrictions"] = ip_restrictions
        __props__.__dict__["kafka_rest_api"] = kafka_rest_api
        __props__.__dict__["kafka_schema_registry"] = kafka_schema_registry
        __props__.__dict__["maintenance_time"] = maintenance_time
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["opensearch_acls_enabled"] = opensearch_acls_enabled
        __props__.__dict__["plan"] = plan
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedConfiguration")
    def advanced_configuration(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Advanced configuration key / value.
        """
        return pulumi.get(self, "advanced_configuration")

    @property
    @pulumi.getter(name="backupRegions")
    def backup_regions(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of region where backups are pushed. Not more than 1 regions for MongoDB. Not more than 2 regions for the other engines with one being the same as the nodes[].region field
        """
        return pulumi.get(self, "backup_regions")

    @property
    @pulumi.getter(name="backupTime")
    def backup_time(self) -> pulumi.Output[builtins.str]:
        """
        Time on which backups start every day (this parameter is not usable on the following engines: "m3db", "grafana", "kafka", "kafkaconnect", "kafkamirrormaker", "opensearch", "m3aggregator").
        """
        return pulumi.get(self, "backup_time")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Date of the creation of the cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Small description of the database service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[builtins.int]:
        """
        The disk size (in GB) of the database service.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Output[builtins.str]:
        """
        Defines the disk type of the database service.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.DatabaseEndpoint']]:
        """
        List of all endpoints objects of the service.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[builtins.str]:
        """
        The database engine you want to deploy. To get a full list of available engine visit. [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[builtins.str]:
        """
        A valid OVHcloud public cloud database flavor name in which the nodes will be started. Ex: "db1-7". Changing this value upgrade the nodes with the new flavor. You can find the list of flavor names: https://www.ovhcloud.com/fr/public-cloud/prices/
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> pulumi.Output[Optional[Sequence['outputs.DatabaseIpRestriction']]]:
        """
        IP Blocks authorized to access to the cluster.
        """
        return pulumi.get(self, "ip_restrictions")

    @property
    @pulumi.getter(name="kafkaRestApi")
    def kafka_rest_api(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether the REST API is enabled on a kafka cluster
        """
        return pulumi.get(self, "kafka_rest_api")

    @property
    @pulumi.getter(name="kafkaSchemaRegistry")
    def kafka_schema_registry(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether the schema registry is enabled on a Kafka cluster
        """
        return pulumi.get(self, "kafka_schema_registry")

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> pulumi.Output[builtins.str]:
        """
        Time on which maintenances can start every day.
        """
        return pulumi.get(self, "maintenance_time")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of network of the cluster.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.DatabaseNode']]:
        """
        List of nodes object. Multi region cluster are not yet available, all node should be identical.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="opensearchAclsEnabled")
    def opensearch_acls_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether the ACLs are enabled on an OpenSearch cluster
        """
        return pulumi.get(self, "opensearch_acls_enabled")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[builtins.str]:
        """
        Plan of the cluster.
        * MongoDB: Enum: "discovery", "production", "advanced".
        * Mysql, PosgreSQL, Cassandra, M3DB, : Enum: "essential", "business", "enterprise".
        * M3 Aggregator: "business", "enterprise".
        * Redis: "essential", "business".
        * Valkey: "essential", "business".
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Current status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the engine in which the service should be deployed
        """
        return pulumi.get(self, "version")

