# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetContainerRegistryIPRestrictionsRegistryResult',
    'AwaitableGetContainerRegistryIPRestrictionsRegistryResult',
    'get_container_registry_ip_restrictions_registry',
    'get_container_registry_ip_restrictions_registry_output',
]

@pulumi.output_type
class GetContainerRegistryIPRestrictionsRegistryResult:
    """
    A collection of values returned by getContainerRegistryIPRestrictionsRegistry.
    """
    def __init__(__self__, id=None, ip_restrictions=None, registry_id=None, service_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_restrictions and not isinstance(ip_restrictions, list):
            raise TypeError("Expected argument 'ip_restrictions' to be a list")
        pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Sequence[Mapping[str, builtins.str]]:
        """
        IP restrictions applied on artifact manager component.
        """
        return pulumi.get(self, "ip_restrictions")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> builtins.str:
        """
        The ID of the Managed Private Registry.
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        The ID of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetContainerRegistryIPRestrictionsRegistryResult(GetContainerRegistryIPRestrictionsRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerRegistryIPRestrictionsRegistryResult(
            id=self.id,
            ip_restrictions=self.ip_restrictions,
            registry_id=self.registry_id,
            service_name=self.service_name)


def get_container_registry_ip_restrictions_registry(registry_id: Optional[builtins.str] = None,
                                                    service_name: Optional[builtins.str] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerRegistryIPRestrictionsRegistryResult:
    """
    Use this data source to get the list of Registry IP Restrictions of a container registry associated with a public cloud project.


    :param builtins.str registry_id: The id of the Managed Private Registry.
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['registryId'] = registry_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getContainerRegistryIPRestrictionsRegistry:getContainerRegistryIPRestrictionsRegistry', __args__, opts=opts, typ=GetContainerRegistryIPRestrictionsRegistryResult).value

    return AwaitableGetContainerRegistryIPRestrictionsRegistryResult(
        id=pulumi.get(__ret__, 'id'),
        ip_restrictions=pulumi.get(__ret__, 'ip_restrictions'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_container_registry_ip_restrictions_registry_output(registry_id: Optional[pulumi.Input[builtins.str]] = None,
                                                           service_name: Optional[pulumi.Input[builtins.str]] = None,
                                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerRegistryIPRestrictionsRegistryResult]:
    """
    Use this data source to get the list of Registry IP Restrictions of a container registry associated with a public cloud project.


    :param builtins.str registry_id: The id of the Managed Private Registry.
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['registryId'] = registry_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getContainerRegistryIPRestrictionsRegistry:getContainerRegistryIPRestrictionsRegistry', __args__, opts=opts, typ=GetContainerRegistryIPRestrictionsRegistryResult)
    return __ret__.apply(lambda __response__: GetContainerRegistryIPRestrictionsRegistryResult(
        id=pulumi.get(__response__, 'id'),
        ip_restrictions=pulumi.get(__response__, 'ip_restrictions'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        service_name=pulumi.get(__response__, 'service_name')))
