# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKubeResult',
    'AwaitableGetKubeResult',
    'get_kube',
    'get_kube_output',
]

@pulumi.output_type
class GetKubeResult:
    """
    A collection of values returned by getKube.
    """
    def __init__(__self__, control_plane_is_up_to_date=None, customization_apiservers=None, customization_kube_proxy=None, customizations=None, id=None, is_up_to_date=None, kube_id=None, kube_proxy_mode=None, load_balancers_subnet_id=None, name=None, next_upgrade_versions=None, nodes_subnet_id=None, nodes_url=None, private_network_id=None, region=None, service_name=None, status=None, update_policy=None, url=None, version=None):
        if control_plane_is_up_to_date and not isinstance(control_plane_is_up_to_date, bool):
            raise TypeError("Expected argument 'control_plane_is_up_to_date' to be a bool")
        pulumi.set(__self__, "control_plane_is_up_to_date", control_plane_is_up_to_date)
        if customization_apiservers and not isinstance(customization_apiservers, list):
            raise TypeError("Expected argument 'customization_apiservers' to be a list")
        pulumi.set(__self__, "customization_apiservers", customization_apiservers)
        if customization_kube_proxy and not isinstance(customization_kube_proxy, dict):
            raise TypeError("Expected argument 'customization_kube_proxy' to be a dict")
        pulumi.set(__self__, "customization_kube_proxy", customization_kube_proxy)
        if customizations and not isinstance(customizations, list):
            raise TypeError("Expected argument 'customizations' to be a list")
        pulumi.set(__self__, "customizations", customizations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_up_to_date and not isinstance(is_up_to_date, bool):
            raise TypeError("Expected argument 'is_up_to_date' to be a bool")
        pulumi.set(__self__, "is_up_to_date", is_up_to_date)
        if kube_id and not isinstance(kube_id, str):
            raise TypeError("Expected argument 'kube_id' to be a str")
        pulumi.set(__self__, "kube_id", kube_id)
        if kube_proxy_mode and not isinstance(kube_proxy_mode, str):
            raise TypeError("Expected argument 'kube_proxy_mode' to be a str")
        pulumi.set(__self__, "kube_proxy_mode", kube_proxy_mode)
        if load_balancers_subnet_id and not isinstance(load_balancers_subnet_id, str):
            raise TypeError("Expected argument 'load_balancers_subnet_id' to be a str")
        pulumi.set(__self__, "load_balancers_subnet_id", load_balancers_subnet_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if next_upgrade_versions and not isinstance(next_upgrade_versions, list):
            raise TypeError("Expected argument 'next_upgrade_versions' to be a list")
        pulumi.set(__self__, "next_upgrade_versions", next_upgrade_versions)
        if nodes_subnet_id and not isinstance(nodes_subnet_id, str):
            raise TypeError("Expected argument 'nodes_subnet_id' to be a str")
        pulumi.set(__self__, "nodes_subnet_id", nodes_subnet_id)
        if nodes_url and not isinstance(nodes_url, str):
            raise TypeError("Expected argument 'nodes_url' to be a str")
        pulumi.set(__self__, "nodes_url", nodes_url)
        if private_network_id and not isinstance(private_network_id, str):
            raise TypeError("Expected argument 'private_network_id' to be a str")
        pulumi.set(__self__, "private_network_id", private_network_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if update_policy and not isinstance(update_policy, str):
            raise TypeError("Expected argument 'update_policy' to be a str")
        pulumi.set(__self__, "update_policy", update_policy)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="controlPlaneIsUpToDate")
    def control_plane_is_up_to_date(self) -> builtins.bool:
        """
        True if control-plane is up-to-date.
        """
        return pulumi.get(self, "control_plane_is_up_to_date")

    @property
    @pulumi.getter(name="customizationApiservers")
    def customization_apiservers(self) -> Sequence['outputs.GetKubeCustomizationApiserverResult']:
        """
        Kubernetes API server customization
        """
        return pulumi.get(self, "customization_apiservers")

    @property
    @pulumi.getter(name="customizationKubeProxy")
    def customization_kube_proxy(self) -> Optional['outputs.GetKubeCustomizationKubeProxyResult']:
        """
        Kubernetes kube-proxy customization
        """
        return pulumi.get(self, "customization_kube_proxy")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use customization_apiserver instead""")
    def customizations(self) -> Sequence['outputs.GetKubeCustomizationResult']:
        """
        **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
        """
        return pulumi.get(self, "customizations")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isUpToDate")
    def is_up_to_date(self) -> builtins.bool:
        """
        True if all nodes and control-plane are up-to-date.
        """
        return pulumi.get(self, "is_up_to_date")

    @property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "kube_id")

    @property
    @pulumi.getter(name="kubeProxyMode")
    def kube_proxy_mode(self) -> Optional[builtins.str]:
        """
        Selected mode for kube-proxy.
        """
        return pulumi.get(self, "kube_proxy_mode")

    @property
    @pulumi.getter(name="loadBalancersSubnetId")
    def load_balancers_subnet_id(self) -> builtins.str:
        """
        Openstack private network (or vRack) ID to use for load balancers.
        """
        return pulumi.get(self, "load_balancers_subnet_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the managed kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextUpgradeVersions")
    def next_upgrade_versions(self) -> Sequence[builtins.str]:
        """
        Kubernetes versions available for upgrade.
        """
        return pulumi.get(self, "next_upgrade_versions")

    @property
    @pulumi.getter(name="nodesSubnetId")
    def nodes_subnet_id(self) -> builtins.str:
        """
        Openstack private network (or vRack) ID to use for nodes.
        """
        return pulumi.get(self, "nodes_subnet_id")

    @property
    @pulumi.getter(name="nodesUrl")
    def nodes_url(self) -> builtins.str:
        """
        Cluster nodes URL.
        """
        return pulumi.get(self, "nodes_url")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> builtins.str:
        """
        OpenStack private network (or vrack) ID to use.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The OVHcloud public cloud region ID of the managed kubernetes cluster.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Cluster status. Should be normally set to 'READY'.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[builtins.str]:
        """
        Cluster update policy. Choose between [ALWAYS_UPDATE,MINIMAL_DOWNTIME,NEVER_UPDATE]'.
        """
        return pulumi.get(self, "update_policy")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Management URL of your cluster.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Kubernetes version of the managed kubernetes cluster.
        """
        return pulumi.get(self, "version")


class AwaitableGetKubeResult(GetKubeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubeResult(
            control_plane_is_up_to_date=self.control_plane_is_up_to_date,
            customization_apiservers=self.customization_apiservers,
            customization_kube_proxy=self.customization_kube_proxy,
            customizations=self.customizations,
            id=self.id,
            is_up_to_date=self.is_up_to_date,
            kube_id=self.kube_id,
            kube_proxy_mode=self.kube_proxy_mode,
            load_balancers_subnet_id=self.load_balancers_subnet_id,
            name=self.name,
            next_upgrade_versions=self.next_upgrade_versions,
            nodes_subnet_id=self.nodes_subnet_id,
            nodes_url=self.nodes_url,
            private_network_id=self.private_network_id,
            region=self.region,
            service_name=self.service_name,
            status=self.status,
            update_policy=self.update_policy,
            url=self.url,
            version=self.version)


def get_kube(customization_apiservers: Optional[Sequence[Union['GetKubeCustomizationApiserverArgs', 'GetKubeCustomizationApiserverArgsDict']]] = None,
             customization_kube_proxy: Optional[Union['GetKubeCustomizationKubeProxyArgs', 'GetKubeCustomizationKubeProxyArgsDict']] = None,
             customizations: Optional[Sequence[Union['GetKubeCustomizationArgs', 'GetKubeCustomizationArgsDict']]] = None,
             kube_id: Optional[builtins.str] = None,
             kube_proxy_mode: Optional[builtins.str] = None,
             name: Optional[builtins.str] = None,
             region: Optional[builtins.str] = None,
             service_name: Optional[builtins.str] = None,
             update_policy: Optional[builtins.str] = None,
             version: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubeResult:
    """
    Use this data source to get a OVHcloud Managed Kubernetes Service cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_kube_cluster = ovh.CloudProject.get_kube(service_name="XXXXXX",
        kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx")
    pulumi.export("version", my_kube_cluster.version)
    ```


    :param Sequence[Union['GetKubeCustomizationApiserverArgs', 'GetKubeCustomizationApiserverArgsDict']] customization_apiservers: Kubernetes API server customization
    :param Union['GetKubeCustomizationKubeProxyArgs', 'GetKubeCustomizationKubeProxyArgsDict'] customization_kube_proxy: Kubernetes kube-proxy customization
    :param Sequence[Union['GetKubeCustomizationArgs', 'GetKubeCustomizationArgsDict']] customizations: **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
    :param builtins.str kube_id: The id of the managed kubernetes cluster.
    :param builtins.str kube_proxy_mode: Selected mode for kube-proxy.
    :param builtins.str name: The name of the managed kubernetes cluster.
    :param builtins.str region: The OVHcloud public cloud region ID of the managed kubernetes cluster.
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    :param builtins.str update_policy: Cluster update policy. Choose between [ALWAYS_UPDATE,MINIMAL_DOWNTIME,NEVER_UPDATE]'.
    :param builtins.str version: Kubernetes version of the managed kubernetes cluster.
    """
    __args__ = dict()
    __args__['customizationApiservers'] = customization_apiservers
    __args__['customizationKubeProxy'] = customization_kube_proxy
    __args__['customizations'] = customizations
    __args__['kubeId'] = kube_id
    __args__['kubeProxyMode'] = kube_proxy_mode
    __args__['name'] = name
    __args__['region'] = region
    __args__['serviceName'] = service_name
    __args__['updatePolicy'] = update_policy
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getKube:getKube', __args__, opts=opts, typ=GetKubeResult).value

    return AwaitableGetKubeResult(
        control_plane_is_up_to_date=pulumi.get(__ret__, 'control_plane_is_up_to_date'),
        customization_apiservers=pulumi.get(__ret__, 'customization_apiservers'),
        customization_kube_proxy=pulumi.get(__ret__, 'customization_kube_proxy'),
        customizations=pulumi.get(__ret__, 'customizations'),
        id=pulumi.get(__ret__, 'id'),
        is_up_to_date=pulumi.get(__ret__, 'is_up_to_date'),
        kube_id=pulumi.get(__ret__, 'kube_id'),
        kube_proxy_mode=pulumi.get(__ret__, 'kube_proxy_mode'),
        load_balancers_subnet_id=pulumi.get(__ret__, 'load_balancers_subnet_id'),
        name=pulumi.get(__ret__, 'name'),
        next_upgrade_versions=pulumi.get(__ret__, 'next_upgrade_versions'),
        nodes_subnet_id=pulumi.get(__ret__, 'nodes_subnet_id'),
        nodes_url=pulumi.get(__ret__, 'nodes_url'),
        private_network_id=pulumi.get(__ret__, 'private_network_id'),
        region=pulumi.get(__ret__, 'region'),
        service_name=pulumi.get(__ret__, 'service_name'),
        status=pulumi.get(__ret__, 'status'),
        update_policy=pulumi.get(__ret__, 'update_policy'),
        url=pulumi.get(__ret__, 'url'),
        version=pulumi.get(__ret__, 'version'))
def get_kube_output(customization_apiservers: Optional[pulumi.Input[Optional[Sequence[Union['GetKubeCustomizationApiserverArgs', 'GetKubeCustomizationApiserverArgsDict']]]]] = None,
                    customization_kube_proxy: Optional[pulumi.Input[Optional[Union['GetKubeCustomizationKubeProxyArgs', 'GetKubeCustomizationKubeProxyArgsDict']]]] = None,
                    customizations: Optional[pulumi.Input[Optional[Sequence[Union['GetKubeCustomizationArgs', 'GetKubeCustomizationArgsDict']]]]] = None,
                    kube_id: Optional[pulumi.Input[builtins.str]] = None,
                    kube_proxy_mode: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    service_name: Optional[pulumi.Input[builtins.str]] = None,
                    update_policy: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubeResult]:
    """
    Use this data source to get a OVHcloud Managed Kubernetes Service cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_kube_cluster = ovh.CloudProject.get_kube(service_name="XXXXXX",
        kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx")
    pulumi.export("version", my_kube_cluster.version)
    ```


    :param Sequence[Union['GetKubeCustomizationApiserverArgs', 'GetKubeCustomizationApiserverArgsDict']] customization_apiservers: Kubernetes API server customization
    :param Union['GetKubeCustomizationKubeProxyArgs', 'GetKubeCustomizationKubeProxyArgsDict'] customization_kube_proxy: Kubernetes kube-proxy customization
    :param Sequence[Union['GetKubeCustomizationArgs', 'GetKubeCustomizationArgsDict']] customizations: **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
    :param builtins.str kube_id: The id of the managed kubernetes cluster.
    :param builtins.str kube_proxy_mode: Selected mode for kube-proxy.
    :param builtins.str name: The name of the managed kubernetes cluster.
    :param builtins.str region: The OVHcloud public cloud region ID of the managed kubernetes cluster.
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    :param builtins.str update_policy: Cluster update policy. Choose between [ALWAYS_UPDATE,MINIMAL_DOWNTIME,NEVER_UPDATE]'.
    :param builtins.str version: Kubernetes version of the managed kubernetes cluster.
    """
    __args__ = dict()
    __args__['customizationApiservers'] = customization_apiservers
    __args__['customizationKubeProxy'] = customization_kube_proxy
    __args__['customizations'] = customizations
    __args__['kubeId'] = kube_id
    __args__['kubeProxyMode'] = kube_proxy_mode
    __args__['name'] = name
    __args__['region'] = region
    __args__['serviceName'] = service_name
    __args__['updatePolicy'] = update_policy
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getKube:getKube', __args__, opts=opts, typ=GetKubeResult)
    return __ret__.apply(lambda __response__: GetKubeResult(
        control_plane_is_up_to_date=pulumi.get(__response__, 'control_plane_is_up_to_date'),
        customization_apiservers=pulumi.get(__response__, 'customization_apiservers'),
        customization_kube_proxy=pulumi.get(__response__, 'customization_kube_proxy'),
        customizations=pulumi.get(__response__, 'customizations'),
        id=pulumi.get(__response__, 'id'),
        is_up_to_date=pulumi.get(__response__, 'is_up_to_date'),
        kube_id=pulumi.get(__response__, 'kube_id'),
        kube_proxy_mode=pulumi.get(__response__, 'kube_proxy_mode'),
        load_balancers_subnet_id=pulumi.get(__response__, 'load_balancers_subnet_id'),
        name=pulumi.get(__response__, 'name'),
        next_upgrade_versions=pulumi.get(__response__, 'next_upgrade_versions'),
        nodes_subnet_id=pulumi.get(__response__, 'nodes_subnet_id'),
        nodes_url=pulumi.get(__response__, 'nodes_url'),
        private_network_id=pulumi.get(__response__, 'private_network_id'),
        region=pulumi.get(__response__, 'region'),
        service_name=pulumi.get(__response__, 'service_name'),
        status=pulumi.get(__response__, 'status'),
        update_policy=pulumi.get(__response__, 'update_policy'),
        url=pulumi.get(__response__, 'url'),
        version=pulumi.get(__response__, 'version')))
