# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKubeNodePoolResult',
    'AwaitableGetKubeNodePoolResult',
    'get_kube_node_pool',
    'get_kube_node_pool_output',
]

@pulumi.output_type
class GetKubeNodePoolResult:
    """
    A collection of values returned by getKubeNodePool.
    """
    def __init__(__self__, anti_affinity=None, autoscale=None, autoscaling_scale_down_unneeded_time_seconds=None, autoscaling_scale_down_unready_time_seconds=None, autoscaling_scale_down_utilization_threshold=None, availability_zones=None, available_nodes=None, created_at=None, current_nodes=None, desired_nodes=None, flavor=None, flavor_name=None, id=None, kube_id=None, max_nodes=None, min_nodes=None, monthly_billed=None, name=None, project_id=None, service_name=None, size_status=None, status=None, template=None, up_to_date_nodes=None, updated_at=None):
        if anti_affinity and not isinstance(anti_affinity, bool):
            raise TypeError("Expected argument 'anti_affinity' to be a bool")
        pulumi.set(__self__, "anti_affinity", anti_affinity)
        if autoscale and not isinstance(autoscale, bool):
            raise TypeError("Expected argument 'autoscale' to be a bool")
        pulumi.set(__self__, "autoscale", autoscale)
        if autoscaling_scale_down_unneeded_time_seconds and not isinstance(autoscaling_scale_down_unneeded_time_seconds, int):
            raise TypeError("Expected argument 'autoscaling_scale_down_unneeded_time_seconds' to be a int")
        pulumi.set(__self__, "autoscaling_scale_down_unneeded_time_seconds", autoscaling_scale_down_unneeded_time_seconds)
        if autoscaling_scale_down_unready_time_seconds and not isinstance(autoscaling_scale_down_unready_time_seconds, int):
            raise TypeError("Expected argument 'autoscaling_scale_down_unready_time_seconds' to be a int")
        pulumi.set(__self__, "autoscaling_scale_down_unready_time_seconds", autoscaling_scale_down_unready_time_seconds)
        if autoscaling_scale_down_utilization_threshold and not isinstance(autoscaling_scale_down_utilization_threshold, float):
            raise TypeError("Expected argument 'autoscaling_scale_down_utilization_threshold' to be a float")
        pulumi.set(__self__, "autoscaling_scale_down_utilization_threshold", autoscaling_scale_down_utilization_threshold)
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if available_nodes and not isinstance(available_nodes, int):
            raise TypeError("Expected argument 'available_nodes' to be a int")
        pulumi.set(__self__, "available_nodes", available_nodes)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if current_nodes and not isinstance(current_nodes, int):
            raise TypeError("Expected argument 'current_nodes' to be a int")
        pulumi.set(__self__, "current_nodes", current_nodes)
        if desired_nodes and not isinstance(desired_nodes, int):
            raise TypeError("Expected argument 'desired_nodes' to be a int")
        pulumi.set(__self__, "desired_nodes", desired_nodes)
        if flavor and not isinstance(flavor, str):
            raise TypeError("Expected argument 'flavor' to be a str")
        pulumi.set(__self__, "flavor", flavor)
        if flavor_name and not isinstance(flavor_name, str):
            raise TypeError("Expected argument 'flavor_name' to be a str")
        pulumi.set(__self__, "flavor_name", flavor_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kube_id and not isinstance(kube_id, str):
            raise TypeError("Expected argument 'kube_id' to be a str")
        pulumi.set(__self__, "kube_id", kube_id)
        if max_nodes and not isinstance(max_nodes, int):
            raise TypeError("Expected argument 'max_nodes' to be a int")
        pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes and not isinstance(min_nodes, int):
            raise TypeError("Expected argument 'min_nodes' to be a int")
        pulumi.set(__self__, "min_nodes", min_nodes)
        if monthly_billed and not isinstance(monthly_billed, bool):
            raise TypeError("Expected argument 'monthly_billed' to be a bool")
        pulumi.set(__self__, "monthly_billed", monthly_billed)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if size_status and not isinstance(size_status, str):
            raise TypeError("Expected argument 'size_status' to be a str")
        pulumi.set(__self__, "size_status", size_status)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if template and not isinstance(template, dict):
            raise TypeError("Expected argument 'template' to be a dict")
        pulumi.set(__self__, "template", template)
        if up_to_date_nodes and not isinstance(up_to_date_nodes, int):
            raise TypeError("Expected argument 'up_to_date_nodes' to be a int")
        pulumi.set(__self__, "up_to_date_nodes", up_to_date_nodes)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> builtins.bool:
        """
        (Optional) should the pool use the anti-affinity feature. Default to `false`.
        """
        return pulumi.get(self, "anti_affinity")

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        """
        (Optional) Enable auto-scaling for the pool. Default to `false`.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="autoscalingScaleDownUnneededTimeSeconds")
    def autoscaling_scale_down_unneeded_time_seconds(self) -> builtins.int:
        """
        (Optional) scaleDownUnneededTimeSeconds autoscaling parameter How long a node should be unneeded before it is eligible for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_unneeded_time_seconds")

    @property
    @pulumi.getter(name="autoscalingScaleDownUnreadyTimeSeconds")
    def autoscaling_scale_down_unready_time_seconds(self) -> builtins.int:
        """
        (Optional) scaleDownUnreadyTimeSeconds autoscaling parameter How long an unready node should be unneeded before it is eligible for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_unready_time_seconds")

    @property
    @pulumi.getter(name="autoscalingScaleDownUtilizationThreshold")
    def autoscaling_scale_down_utilization_threshold(self) -> builtins.float:
        """
        (Optional) scaleDownUtilizationThreshold autoscaling parameter Node utilization level, defined as sum of requested resources divided by capacity, below which a node can be considered for scale down
        """
        return pulumi.get(self, "autoscaling_scale_down_utilization_threshold")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[builtins.str]]:
        """
        list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="availableNodes")
    def available_nodes(self) -> builtins.int:
        """
        Number of nodes which are actually ready in the pool
        """
        return pulumi.get(self, "available_nodes")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        Creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="currentNodes")
    def current_nodes(self) -> builtins.int:
        """
        Number of nodes present in the pool
        """
        return pulumi.get(self, "current_nodes")

    @property
    @pulumi.getter(name="desiredNodes")
    def desired_nodes(self) -> builtins.int:
        """
        Number of nodes you desire in the pool
        """
        return pulumi.get(self, "desired_nodes")

    @property
    @pulumi.getter
    def flavor(self) -> builtins.str:
        """
        Flavor name
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> builtins.str:
        """
        a valid OVHcloud public cloud flavor ID in which the nodes will be started. Ex: "b2-7". Changing this value recreates the resource. You can find the list of flavor IDs: https://www.ovhcloud.com/fr/public-cloud/prices/
        """
        return pulumi.get(self, "flavor_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "kube_id")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> builtins.int:
        """
        maximum number of nodes allowed in the pool. Setting `desired_nodes` over this value will raise an error.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> builtins.int:
        """
        minimum number of nodes allowed in the pool. Setting `desired_nodes` under this value will raise an error.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter(name="monthlyBilled")
    def monthly_billed(self) -> builtins.bool:
        """
        (Optional) should the nodes be billed on a monthly basis. Default to `false`.
        """
        return pulumi.get(self, "monthly_billed")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        (Optional) The name of the nodepool. Changing this value recreates the resource. Warning: "_" char is not allowed!
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project id
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sizeStatus")
    def size_status(self) -> builtins.str:
        """
        Status describing the state between number of nodes wanted and available ones
        """
        return pulumi.get(self, "size_status")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def template(self) -> Optional['outputs.GetKubeNodePoolTemplateResult']:
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="upToDateNodes")
    def up_to_date_nodes(self) -> builtins.int:
        """
        Number of nodes with the latest version installed in the pool
        """
        return pulumi.get(self, "up_to_date_nodes")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        Last update date
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetKubeNodePoolResult(GetKubeNodePoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubeNodePoolResult(
            anti_affinity=self.anti_affinity,
            autoscale=self.autoscale,
            autoscaling_scale_down_unneeded_time_seconds=self.autoscaling_scale_down_unneeded_time_seconds,
            autoscaling_scale_down_unready_time_seconds=self.autoscaling_scale_down_unready_time_seconds,
            autoscaling_scale_down_utilization_threshold=self.autoscaling_scale_down_utilization_threshold,
            availability_zones=self.availability_zones,
            available_nodes=self.available_nodes,
            created_at=self.created_at,
            current_nodes=self.current_nodes,
            desired_nodes=self.desired_nodes,
            flavor=self.flavor,
            flavor_name=self.flavor_name,
            id=self.id,
            kube_id=self.kube_id,
            max_nodes=self.max_nodes,
            min_nodes=self.min_nodes,
            monthly_billed=self.monthly_billed,
            name=self.name,
            project_id=self.project_id,
            service_name=self.service_name,
            size_status=self.size_status,
            status=self.status,
            template=self.template,
            up_to_date_nodes=self.up_to_date_nodes,
            updated_at=self.updated_at)


def get_kube_node_pool(availability_zones: Optional[Sequence[builtins.str]] = None,
                       kube_id: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       service_name: Optional[builtins.str] = None,
                       template: Optional[Union['GetKubeNodePoolTemplateArgs', 'GetKubeNodePoolTemplateArgsDict']] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubeNodePoolResult:
    """
    Use this data source to get a OVHcloud Managed Kubernetes node pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    nodepool = ovh.CloudProject.get_kube_node_pool(service_name="XXXXXX",
        kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxx",
        name="xxxxxx")
    pulumi.export("maxNodes", nodepool.max_nodes)
    ```


    :param Sequence[builtins.str] availability_zones: list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
    :param builtins.str kube_id: The id of the managed kubernetes cluster.
    :param builtins.str name: The name of the node pool.
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['availabilityZones'] = availability_zones
    __args__['kubeId'] = kube_id
    __args__['name'] = name
    __args__['serviceName'] = service_name
    __args__['template'] = template
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getKubeNodePool:getKubeNodePool', __args__, opts=opts, typ=GetKubeNodePoolResult).value

    return AwaitableGetKubeNodePoolResult(
        anti_affinity=pulumi.get(__ret__, 'anti_affinity'),
        autoscale=pulumi.get(__ret__, 'autoscale'),
        autoscaling_scale_down_unneeded_time_seconds=pulumi.get(__ret__, 'autoscaling_scale_down_unneeded_time_seconds'),
        autoscaling_scale_down_unready_time_seconds=pulumi.get(__ret__, 'autoscaling_scale_down_unready_time_seconds'),
        autoscaling_scale_down_utilization_threshold=pulumi.get(__ret__, 'autoscaling_scale_down_utilization_threshold'),
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        available_nodes=pulumi.get(__ret__, 'available_nodes'),
        created_at=pulumi.get(__ret__, 'created_at'),
        current_nodes=pulumi.get(__ret__, 'current_nodes'),
        desired_nodes=pulumi.get(__ret__, 'desired_nodes'),
        flavor=pulumi.get(__ret__, 'flavor'),
        flavor_name=pulumi.get(__ret__, 'flavor_name'),
        id=pulumi.get(__ret__, 'id'),
        kube_id=pulumi.get(__ret__, 'kube_id'),
        max_nodes=pulumi.get(__ret__, 'max_nodes'),
        min_nodes=pulumi.get(__ret__, 'min_nodes'),
        monthly_billed=pulumi.get(__ret__, 'monthly_billed'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        service_name=pulumi.get(__ret__, 'service_name'),
        size_status=pulumi.get(__ret__, 'size_status'),
        status=pulumi.get(__ret__, 'status'),
        template=pulumi.get(__ret__, 'template'),
        up_to_date_nodes=pulumi.get(__ret__, 'up_to_date_nodes'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_kube_node_pool_output(availability_zones: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                              kube_id: Optional[pulumi.Input[builtins.str]] = None,
                              name: Optional[pulumi.Input[builtins.str]] = None,
                              service_name: Optional[pulumi.Input[builtins.str]] = None,
                              template: Optional[pulumi.Input[Optional[Union['GetKubeNodePoolTemplateArgs', 'GetKubeNodePoolTemplateArgsDict']]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubeNodePoolResult]:
    """
    Use this data source to get a OVHcloud Managed Kubernetes node pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    nodepool = ovh.CloudProject.get_kube_node_pool(service_name="XXXXXX",
        kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxx",
        name="xxxxxx")
    pulumi.export("maxNodes", nodepool.max_nodes)
    ```


    :param Sequence[builtins.str] availability_zones: list of availability zones to associate the pool - **mandatory for multi-zone** cluster - only one zone is supported at the moment.
    :param builtins.str kube_id: The id of the managed kubernetes cluster.
    :param builtins.str name: The name of the node pool.
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['availabilityZones'] = availability_zones
    __args__['kubeId'] = kube_id
    __args__['name'] = name
    __args__['serviceName'] = service_name
    __args__['template'] = template
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getKubeNodePool:getKubeNodePool', __args__, opts=opts, typ=GetKubeNodePoolResult)
    return __ret__.apply(lambda __response__: GetKubeNodePoolResult(
        anti_affinity=pulumi.get(__response__, 'anti_affinity'),
        autoscale=pulumi.get(__response__, 'autoscale'),
        autoscaling_scale_down_unneeded_time_seconds=pulumi.get(__response__, 'autoscaling_scale_down_unneeded_time_seconds'),
        autoscaling_scale_down_unready_time_seconds=pulumi.get(__response__, 'autoscaling_scale_down_unready_time_seconds'),
        autoscaling_scale_down_utilization_threshold=pulumi.get(__response__, 'autoscaling_scale_down_utilization_threshold'),
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        available_nodes=pulumi.get(__response__, 'available_nodes'),
        created_at=pulumi.get(__response__, 'created_at'),
        current_nodes=pulumi.get(__response__, 'current_nodes'),
        desired_nodes=pulumi.get(__response__, 'desired_nodes'),
        flavor=pulumi.get(__response__, 'flavor'),
        flavor_name=pulumi.get(__response__, 'flavor_name'),
        id=pulumi.get(__response__, 'id'),
        kube_id=pulumi.get(__response__, 'kube_id'),
        max_nodes=pulumi.get(__response__, 'max_nodes'),
        min_nodes=pulumi.get(__response__, 'min_nodes'),
        monthly_billed=pulumi.get(__response__, 'monthly_billed'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        service_name=pulumi.get(__response__, 'service_name'),
        size_status=pulumi.get(__response__, 'size_status'),
        status=pulumi.get(__response__, 'status'),
        template=pulumi.get(__response__, 'template'),
        up_to_date_nodes=pulumi.get(__response__, 'up_to_date_nodes'),
        updated_at=pulumi.get(__response__, 'updated_at')))
