# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLoadBalancersResult',
    'AwaitableGetLoadBalancersResult',
    'get_load_balancers',
    'get_load_balancers_output',
]

@pulumi.output_type
class GetLoadBalancersResult:
    """
    A collection of values returned by getLoadBalancers.
    """
    def __init__(__self__, id=None, loadbalancers=None, region_name=None, service_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if loadbalancers and not isinstance(loadbalancers, list):
            raise TypeError("Expected argument 'loadbalancers' to be a list")
        pulumi.set(__self__, "loadbalancers", loadbalancers)
        if region_name and not isinstance(region_name, str):
            raise TypeError("Expected argument 'region_name' to be a str")
        pulumi.set(__self__, "region_name", region_name)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def loadbalancers(self) -> Sequence['outputs.GetLoadBalancersLoadbalancerResult']:
        """
        List of loadbalancer
        """
        return pulumi.get(self, "loadbalancers")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.str:
        """
        Region of the loadbalancers
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        ID of the public cloud project
        """
        return pulumi.get(self, "service_name")


class AwaitableGetLoadBalancersResult(GetLoadBalancersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancersResult(
            id=self.id,
            loadbalancers=self.loadbalancers,
            region_name=self.region_name,
            service_name=self.service_name)


def get_load_balancers(region_name: Optional[builtins.str] = None,
                       service_name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancersResult:
    """
    List your public cloud loadbalancers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    lbs = ovh.CloudProject.get_load_balancers(service_name="XXXXXX",
        region_name="XXX")
    pulumi.export("lbs", lbs)
    ```


    :param builtins.str region_name: Region of the loadbalancers.
    :param builtins.str service_name: The ID of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getLoadBalancers:getLoadBalancers', __args__, opts=opts, typ=GetLoadBalancersResult).value

    return AwaitableGetLoadBalancersResult(
        id=pulumi.get(__ret__, 'id'),
        loadbalancers=pulumi.get(__ret__, 'loadbalancers'),
        region_name=pulumi.get(__ret__, 'region_name'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_load_balancers_output(region_name: Optional[pulumi.Input[builtins.str]] = None,
                              service_name: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadBalancersResult]:
    """
    List your public cloud loadbalancers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    lbs = ovh.CloudProject.get_load_balancers(service_name="XXXXXX",
        region_name="XXX")
    pulumi.export("lbs", lbs)
    ```


    :param builtins.str region_name: Region of the loadbalancers.
    :param builtins.str service_name: The ID of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getLoadBalancers:getLoadBalancers', __args__, opts=opts, typ=GetLoadBalancersResult)
    return __ret__.apply(lambda __response__: GetLoadBalancersResult(
        id=pulumi.get(__response__, 'id'),
        loadbalancers=pulumi.get(__response__, 'loadbalancers'),
        region_name=pulumi.get(__response__, 'region_name'),
        service_name=pulumi.get(__response__, 'service_name')))
