# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMongoDbPrometheusResult',
    'AwaitableGetMongoDbPrometheusResult',
    'get_mongo_db_prometheus',
    'get_mongo_db_prometheus_output',
]

@pulumi.output_type
class GetMongoDbPrometheusResult:
    """
    A collection of values returned by getMongoDbPrometheus.
    """
    def __init__(__self__, cluster_id=None, id=None, service_name=None, srv_domain=None, username=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if srv_domain and not isinstance(srv_domain, str):
            raise TypeError("Expected argument 'srv_domain' to be a str")
        pulumi.set(__self__, "srv_domain", srv_domain)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="srvDomain")
    def srv_domain(self) -> builtins.str:
        """
        Name of the srv domain endpoint.
        """
        return pulumi.get(self, "srv_domain")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        name of the prometheus user.
        """
        return pulumi.get(self, "username")


class AwaitableGetMongoDbPrometheusResult(GetMongoDbPrometheusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMongoDbPrometheusResult(
            cluster_id=self.cluster_id,
            id=self.id,
            service_name=self.service_name,
            srv_domain=self.srv_domain,
            username=self.username)


def get_mongo_db_prometheus(cluster_id: Optional[builtins.str] = None,
                            service_name: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMongoDbPrometheusResult:
    """
    Use this data source to get information about a prometheus of a MongoDB cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    prometheus = ovh.CloudProject.get_mongo_db_prometheus(service_name="XXX",
        cluster_id="ZZZ")
    pulumi.export("name", prometheus.username)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getMongoDbPrometheus:getMongoDbPrometheus', __args__, opts=opts, typ=GetMongoDbPrometheusResult).value

    return AwaitableGetMongoDbPrometheusResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        service_name=pulumi.get(__ret__, 'service_name'),
        srv_domain=pulumi.get(__ret__, 'srv_domain'),
        username=pulumi.get(__ret__, 'username'))
def get_mongo_db_prometheus_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                   service_name: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMongoDbPrometheusResult]:
    """
    Use this data source to get information about a prometheus of a MongoDB cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    prometheus = ovh.CloudProject.get_mongo_db_prometheus(service_name="XXX",
        cluster_id="ZZZ")
    pulumi.export("name", prometheus.username)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getMongoDbPrometheus:getMongoDbPrometheus', __args__, opts=opts, typ=GetMongoDbPrometheusResult)
    return __ret__.apply(lambda __response__: GetMongoDbPrometheusResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        service_name=pulumi.get(__response__, 'service_name'),
        srv_domain=pulumi.get(__response__, 'srv_domain'),
        username=pulumi.get(__response__, 'username')))
