# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPrometheusResult',
    'AwaitableGetPrometheusResult',
    'get_prometheus',
    'get_prometheus_output',
]

@pulumi.output_type
class GetPrometheusResult:
    """
    A collection of values returned by getPrometheus.
    """
    def __init__(__self__, cluster_id=None, engine=None, id=None, service_name=None, targets=None, username=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def engine(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetPrometheusTargetResult']:
        """
        List of all endpoint targets.
        * `Host` - Host of the endpoint.
        * `Port` - Connection port for the endpoint.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        name of the prometheus user.
        """
        return pulumi.get(self, "username")


class AwaitableGetPrometheusResult(GetPrometheusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrometheusResult(
            cluster_id=self.cluster_id,
            engine=self.engine,
            id=self.id,
            service_name=self.service_name,
            targets=self.targets,
            username=self.username)


def get_prometheus(cluster_id: Optional[builtins.str] = None,
                   engine: Optional[builtins.str] = None,
                   service_name: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrometheusResult:
    """
    Use this data source to get information about a prometheus of a database cluster associated with a public cloud project. For mongodb, please use CloudProjectDatabase.MongoDbPrometheus datasource

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    prometheus = ovh.CloudProject.get_prometheus(service_name="XXX",
        engine="YYY",
        cluster_id="ZZZ")
    pulumi.export("name", prometheus.username)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str engine: The engine of the database cluster you want user information. To get a full list of available engine visit : [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases). Available engines:
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['engine'] = engine
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getPrometheus:getPrometheus', __args__, opts=opts, typ=GetPrometheusResult).value

    return AwaitableGetPrometheusResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        engine=pulumi.get(__ret__, 'engine'),
        id=pulumi.get(__ret__, 'id'),
        service_name=pulumi.get(__ret__, 'service_name'),
        targets=pulumi.get(__ret__, 'targets'),
        username=pulumi.get(__ret__, 'username'))
def get_prometheus_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                          engine: Optional[pulumi.Input[builtins.str]] = None,
                          service_name: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrometheusResult]:
    """
    Use this data source to get information about a prometheus of a database cluster associated with a public cloud project. For mongodb, please use CloudProjectDatabase.MongoDbPrometheus datasource

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    prometheus = ovh.CloudProject.get_prometheus(service_name="XXX",
        engine="YYY",
        cluster_id="ZZZ")
    pulumi.export("name", prometheus.username)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str engine: The engine of the database cluster you want user information. To get a full list of available engine visit : [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases). Available engines:
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['engine'] = engine
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getPrometheus:getPrometheus', __args__, opts=opts, typ=GetPrometheusResult)
    return __ret__.apply(lambda __response__: GetPrometheusResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        engine=pulumi.get(__response__, 'engine'),
        id=pulumi.get(__response__, 'id'),
        service_name=pulumi.get(__response__, 'service_name'),
        targets=pulumi.get(__response__, 'targets'),
        username=pulumi.get(__response__, 'username')))
