# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRancherPlanResult',
    'AwaitableGetRancherPlanResult',
    'get_rancher_plan',
    'get_rancher_plan_output',
]

@pulumi.output_type
class GetRancherPlanResult:
    """
    A collection of values returned by getRancherPlan.
    """
    def __init__(__self__, id=None, plans=None, project_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetRancherPlanPlanResult']:
        return pulumi.get(self, "plans")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")


class AwaitableGetRancherPlanResult(GetRancherPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRancherPlanResult(
            id=self.id,
            plans=self.plans,
            project_id=self.project_id)


def get_rancher_plan(project_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRancherPlanResult:
    """
    Use this datasource to retrieve information about the Managed Rancher plans available in the given public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    plans = ovh.CloudProject.get_rancher_plan(project_id="XXXXXX")
    ```


    :param builtins.str project_id: Project ID
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getRancherPlan:getRancherPlan', __args__, opts=opts, typ=GetRancherPlanResult).value

    return AwaitableGetRancherPlanResult(
        id=pulumi.get(__ret__, 'id'),
        plans=pulumi.get(__ret__, 'plans'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_rancher_plan_output(project_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRancherPlanResult]:
    """
    Use this datasource to retrieve information about the Managed Rancher plans available in the given public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    plans = ovh.CloudProject.get_rancher_plan(project_id="XXXXXX")
    ```


    :param builtins.str project_id: Project ID
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getRancherPlan:getRancherPlan', __args__, opts=opts, typ=GetRancherPlanResult)
    return __ret__.apply(lambda __response__: GetRancherPlanResult(
        id=pulumi.get(__response__, 'id'),
        plans=pulumi.get(__response__, 'plans'),
        project_id=pulumi.get(__response__, 'project_id')))
