# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRancherVersionResult',
    'AwaitableGetRancherVersionResult',
    'get_rancher_version',
    'get_rancher_version_output',
]

@pulumi.output_type
class GetRancherVersionResult:
    """
    A collection of values returned by getRancherVersion.
    """
    def __init__(__self__, id=None, project_id=None, versions=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetRancherVersionVersionResult']:
        return pulumi.get(self, "versions")


class AwaitableGetRancherVersionResult(GetRancherVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRancherVersionResult(
            id=self.id,
            project_id=self.project_id,
            versions=self.versions)


def get_rancher_version(project_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRancherVersionResult:
    """
    Use this datasource to retrieve information about the Managed Rancher available versions in the given public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    versions = ovh.CloudProject.get_rancher_version(project_id="XXXXXX")
    ```


    :param builtins.str project_id: Project ID
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getRancherVersion:getRancherVersion', __args__, opts=opts, typ=GetRancherVersionResult).value

    return AwaitableGetRancherVersionResult(
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        versions=pulumi.get(__ret__, 'versions'))
def get_rancher_version_output(project_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRancherVersionResult]:
    """
    Use this datasource to retrieve information about the Managed Rancher available versions in the given public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    versions = ovh.CloudProject.get_rancher_version(project_id="XXXXXX")
    ```


    :param builtins.str project_id: Project ID
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getRancherVersion:getRancherVersion', __args__, opts=opts, typ=GetRancherVersionResult)
    return __ret__.apply(lambda __response__: GetRancherVersionResult(
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        versions=pulumi.get(__response__, 'versions')))
