# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRedisUserResult',
    'AwaitableGetRedisUserResult',
    'get_redis_user',
    'get_redis_user_output',
]

@pulumi.output_type
class GetRedisUserResult:
    """
    A collection of values returned by getRedisUser.
    """
    def __init__(__self__, categories=None, channels=None, cluster_id=None, commands=None, created_at=None, id=None, keys=None, name=None, service_name=None, status=None):
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if channels and not isinstance(channels, list):
            raise TypeError("Expected argument 'channels' to be a list")
        pulumi.set(__self__, "channels", channels)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if commands and not isinstance(commands, list):
            raise TypeError("Expected argument 'commands' to be a list")
        pulumi.set(__self__, "commands", commands)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if keys and not isinstance(keys, list):
            raise TypeError("Expected argument 'keys' to be a list")
        pulumi.set(__self__, "keys", keys)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def categories(self) -> Sequence[builtins.str]:
        """
        Categories of the user.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def channels(self) -> Sequence[builtins.str]:
        """
        Channels of the user.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def commands(self) -> Sequence[builtins.str]:
        """
        Commands of the user.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        Date of the creation of the user.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[builtins.str]:
        """
        Keys of the user.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Current status of the user.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current status of the user.
        """
        return pulumi.get(self, "status")


class AwaitableGetRedisUserResult(GetRedisUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRedisUserResult(
            categories=self.categories,
            channels=self.channels,
            cluster_id=self.cluster_id,
            commands=self.commands,
            created_at=self.created_at,
            id=self.id,
            keys=self.keys,
            name=self.name,
            service_name=self.service_name,
            status=self.status)


def get_redis_user(cluster_id: Optional[builtins.str] = None,
                   name: Optional[builtins.str] = None,
                   service_name: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRedisUserResult:
    """
    Use this data source to get information about a user of a redis cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    redis_user = ovh.CloudProject.get_redis_user(service_name="XXX",
        cluster_id="YYY",
        name="ZZZ")
    pulumi.export("redisUserCommands", redis_user.commands)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str name: Name of the user
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getRedisUser:getRedisUser', __args__, opts=opts, typ=GetRedisUserResult).value

    return AwaitableGetRedisUserResult(
        categories=pulumi.get(__ret__, 'categories'),
        channels=pulumi.get(__ret__, 'channels'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        commands=pulumi.get(__ret__, 'commands'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        keys=pulumi.get(__ret__, 'keys'),
        name=pulumi.get(__ret__, 'name'),
        service_name=pulumi.get(__ret__, 'service_name'),
        status=pulumi.get(__ret__, 'status'))
def get_redis_user_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                          name: Optional[pulumi.Input[builtins.str]] = None,
                          service_name: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRedisUserResult]:
    """
    Use this data source to get information about a user of a redis cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    redis_user = ovh.CloudProject.get_redis_user(service_name="XXX",
        cluster_id="YYY",
        name="ZZZ")
    pulumi.export("redisUserCommands", redis_user.commands)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str name: Name of the user
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getRedisUser:getRedisUser', __args__, opts=opts, typ=GetRedisUserResult)
    return __ret__.apply(lambda __response__: GetRedisUserResult(
        categories=pulumi.get(__response__, 'categories'),
        channels=pulumi.get(__response__, 'channels'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        commands=pulumi.get(__response__, 'commands'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        keys=pulumi.get(__response__, 'keys'),
        name=pulumi.get(__response__, 'name'),
        service_name=pulumi.get(__response__, 'service_name'),
        status=pulumi.get(__response__, 'status')))
