# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRegionLoadBalancerLogSubscriptionResult',
    'AwaitableGetRegionLoadBalancerLogSubscriptionResult',
    'get_region_load_balancer_log_subscription',
    'get_region_load_balancer_log_subscription_output',
]

@pulumi.output_type
class GetRegionLoadBalancerLogSubscriptionResult:
    """
    A collection of values returned by getRegionLoadBalancerLogSubscription.
    """
    def __init__(__self__, created_at=None, id=None, kind=None, ldp_service_name=None, loadbalancer_id=None, region_name=None, resource_name=None, resource_type=None, service_name=None, stream_id=None, subscription_id=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if ldp_service_name and not isinstance(ldp_service_name, str):
            raise TypeError("Expected argument 'ldp_service_name' to be a str")
        pulumi.set(__self__, "ldp_service_name", ldp_service_name)
        if loadbalancer_id and not isinstance(loadbalancer_id, str):
            raise TypeError("Expected argument 'loadbalancer_id' to be a str")
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if region_name and not isinstance(region_name, str):
            raise TypeError("Expected argument 'region_name' to be a str")
        pulumi.set(__self__, "region_name", region_name)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if stream_id and not isinstance(stream_id, str):
            raise TypeError("Expected argument 'stream_id' to be a str")
        pulumi.set(__self__, "stream_id", stream_id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date of the subscription creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        Router used for forwarding log
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="ldpServiceName")
    def ldp_service_name(self) -> builtins.str:
        """
        LDP service name
        """
        return pulumi.get(self, "ldp_service_name")

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> builtins.str:
        """
        Loadbalancer id to get the logs
        """
        return pulumi.get(self, "loadbalancer_id")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.str:
        """
        A valid OVHcloud public cloud region name in which the loadbalancer will be available. Ex.: "GRA11".
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> builtins.str:
        """
        The resource name
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        The resource type
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        The id of the public cloud project.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> builtins.str:
        """
        Data stream id to use for the subscription
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription id
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The last update of the subscription
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetRegionLoadBalancerLogSubscriptionResult(GetRegionLoadBalancerLogSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionLoadBalancerLogSubscriptionResult(
            created_at=self.created_at,
            id=self.id,
            kind=self.kind,
            ldp_service_name=self.ldp_service_name,
            loadbalancer_id=self.loadbalancer_id,
            region_name=self.region_name,
            resource_name=self.resource_name,
            resource_type=self.resource_type,
            service_name=self.service_name,
            stream_id=self.stream_id,
            subscription_id=self.subscription_id,
            updated_at=self.updated_at)


def get_region_load_balancer_log_subscription(loadbalancer_id: Optional[builtins.str] = None,
                                              region_name: Optional[builtins.str] = None,
                                              service_name: Optional[builtins.str] = None,
                                              subscription_id: Optional[builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionLoadBalancerLogSubscriptionResult:
    """
    Get information about a subscription to a Managed Loadbalancer Logs Service in a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    sub = ovh.CloudProject.get_region_load_balancer_log_subscription(service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
        region_name="gggg",
        loadbalancer_id="aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
        subscription_id="zzzzzzzz-yyyy-xxxx-wwww-vvvvvvvvvvvv")
    ```


    :param builtins.str loadbalancer_id: Loadbalancer id to get the logs
    :param builtins.str region_name: A valid OVHcloud public cloud region name in which the loadbalancer is available. Ex.: "GRA11".
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    :param builtins.str subscription_id: Subscription id
    """
    __args__ = dict()
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getRegionLoadBalancerLogSubscription:getRegionLoadBalancerLogSubscription', __args__, opts=opts, typ=GetRegionLoadBalancerLogSubscriptionResult).value

    return AwaitableGetRegionLoadBalancerLogSubscriptionResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        ldp_service_name=pulumi.get(__ret__, 'ldp_service_name'),
        loadbalancer_id=pulumi.get(__ret__, 'loadbalancer_id'),
        region_name=pulumi.get(__ret__, 'region_name'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        service_name=pulumi.get(__ret__, 'service_name'),
        stream_id=pulumi.get(__ret__, 'stream_id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_region_load_balancer_log_subscription_output(loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                                                     region_name: Optional[pulumi.Input[builtins.str]] = None,
                                                     service_name: Optional[pulumi.Input[builtins.str]] = None,
                                                     subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionLoadBalancerLogSubscriptionResult]:
    """
    Get information about a subscription to a Managed Loadbalancer Logs Service in a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    sub = ovh.CloudProject.get_region_load_balancer_log_subscription(service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
        region_name="gggg",
        loadbalancer_id="aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
        subscription_id="zzzzzzzz-yyyy-xxxx-wwww-vvvvvvvvvvvv")
    ```


    :param builtins.str loadbalancer_id: Loadbalancer id to get the logs
    :param builtins.str region_name: A valid OVHcloud public cloud region name in which the loadbalancer is available. Ex.: "GRA11".
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    :param builtins.str subscription_id: Subscription id
    """
    __args__ = dict()
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getRegionLoadBalancerLogSubscription:getRegionLoadBalancerLogSubscription', __args__, opts=opts, typ=GetRegionLoadBalancerLogSubscriptionResult)
    return __ret__.apply(lambda __response__: GetRegionLoadBalancerLogSubscriptionResult(
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        ldp_service_name=pulumi.get(__response__, 'ldp_service_name'),
        loadbalancer_id=pulumi.get(__response__, 'loadbalancer_id'),
        region_name=pulumi.get(__response__, 'region_name'),
        resource_name=pulumi.get(__response__, 'resource_name'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        service_name=pulumi.get(__response__, 'service_name'),
        stream_id=pulumi.get(__response__, 'stream_id'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        updated_at=pulumi.get(__response__, 'updated_at')))
