# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetStorageObjectResult',
    'AwaitableGetStorageObjectResult',
    'get_storage_object',
    'get_storage_object_output',
]

@pulumi.output_type
class GetStorageObjectResult:
    """
    A collection of values returned by getStorageObject.
    """
    def __init__(__self__, etag=None, id=None, is_delete_marker=None, is_latest=None, key=None, last_modified=None, name=None, region_name=None, service_name=None, size=None, storage_class=None, version_id=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_delete_marker and not isinstance(is_delete_marker, bool):
            raise TypeError("Expected argument 'is_delete_marker' to be a bool")
        pulumi.set(__self__, "is_delete_marker", is_delete_marker)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region_name and not isinstance(region_name, str):
            raise TypeError("Expected argument 'region_name' to be a str")
        pulumi.set(__self__, "region_name", region_name)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if size and not isinstance(size, float):
            raise TypeError("Expected argument 'size' to be a float")
        pulumi.set(__self__, "size", size)
        if storage_class and not isinstance(storage_class, str):
            raise TypeError("Expected argument 'storage_class' to be a str")
        pulumi.set(__self__, "storage_class", storage_class)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        ETag
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDeleteMarker")
    def is_delete_marker(self) -> builtins.bool:
        """
        Whether this object is a delete marker
        """
        return pulumi.get(self, "is_delete_marker")

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> builtins.bool:
        """
        Whether this is the latest version of the object
        """
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> builtins.str:
        """
        Last modification date
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.str:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def size(self) -> builtins.float:
        """
        Size (bytes)
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> builtins.str:
        """
        Storage class
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> builtins.str:
        """
        Version ID of the object
        """
        return pulumi.get(self, "version_id")


class AwaitableGetStorageObjectResult(GetStorageObjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageObjectResult(
            etag=self.etag,
            id=self.id,
            is_delete_marker=self.is_delete_marker,
            is_latest=self.is_latest,
            key=self.key,
            last_modified=self.last_modified,
            name=self.name,
            region_name=self.region_name,
            service_name=self.service_name,
            size=self.size,
            storage_class=self.storage_class,
            version_id=self.version_id)


def get_storage_object(key: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       region_name: Optional[builtins.str] = None,
                       service_name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageObjectResult:
    """
    Get information about an object in a S3™* compatible storage container. \\* S3 is a trademark filed by Amazon Technologies,Inc. OVHcloud's service is not sponsored by, endorsed by, or otherwise affiliated with Amazon Technologies,Inc.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    object = ovh.CloudProject.get_storage_object(service_name="<public cloud project ID>",
        region_name="GRA",
        name="<bucket name>",
        key="<object name>")
    ```


    :param builtins.str key: Key
    :param builtins.str name: Name
    :param builtins.str region_name: Region name
    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['key'] = key
    __args__['name'] = name
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getStorageObject:getStorageObject', __args__, opts=opts, typ=GetStorageObjectResult).value

    return AwaitableGetStorageObjectResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        is_delete_marker=pulumi.get(__ret__, 'is_delete_marker'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        key=pulumi.get(__ret__, 'key'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        name=pulumi.get(__ret__, 'name'),
        region_name=pulumi.get(__ret__, 'region_name'),
        service_name=pulumi.get(__ret__, 'service_name'),
        size=pulumi.get(__ret__, 'size'),
        storage_class=pulumi.get(__ret__, 'storage_class'),
        version_id=pulumi.get(__ret__, 'version_id'))
def get_storage_object_output(key: Optional[pulumi.Input[builtins.str]] = None,
                              name: Optional[pulumi.Input[builtins.str]] = None,
                              region_name: Optional[pulumi.Input[builtins.str]] = None,
                              service_name: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageObjectResult]:
    """
    Get information about an object in a S3™* compatible storage container. \\* S3 is a trademark filed by Amazon Technologies,Inc. OVHcloud's service is not sponsored by, endorsed by, or otherwise affiliated with Amazon Technologies,Inc.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    object = ovh.CloudProject.get_storage_object(service_name="<public cloud project ID>",
        region_name="GRA",
        name="<bucket name>",
        key="<object name>")
    ```


    :param builtins.str key: Key
    :param builtins.str name: Name
    :param builtins.str region_name: Region name
    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['key'] = key
    __args__['name'] = name
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getStorageObject:getStorageObject', __args__, opts=opts, typ=GetStorageObjectResult)
    return __ret__.apply(lambda __response__: GetStorageObjectResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        is_delete_marker=pulumi.get(__response__, 'is_delete_marker'),
        is_latest=pulumi.get(__response__, 'is_latest'),
        key=pulumi.get(__response__, 'key'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        name=pulumi.get(__response__, 'name'),
        region_name=pulumi.get(__response__, 'region_name'),
        service_name=pulumi.get(__response__, 'service_name'),
        size=pulumi.get(__response__, 'size'),
        storage_class=pulumi.get(__response__, 'storage_class'),
        version_id=pulumi.get(__response__, 'version_id')))
