# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStorageObjectsResult',
    'AwaitableGetStorageObjectsResult',
    'get_storage_objects',
    'get_storage_objects_output',
]

@pulumi.output_type
class GetStorageObjectsResult:
    """
    A collection of values returned by getStorageObjects.
    """
    def __init__(__self__, id=None, key_marker=None, limit=None, name=None, objects=None, prefix=None, region_name=None, service_name=None, version_id_marker=None, with_versions=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_marker and not isinstance(key_marker, str):
            raise TypeError("Expected argument 'key_marker' to be a str")
        pulumi.set(__self__, "key_marker", key_marker)
        if limit and not isinstance(limit, float):
            raise TypeError("Expected argument 'limit' to be a float")
        pulumi.set(__self__, "limit", limit)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)
        if region_name and not isinstance(region_name, str):
            raise TypeError("Expected argument 'region_name' to be a str")
        pulumi.set(__self__, "region_name", region_name)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if version_id_marker and not isinstance(version_id_marker, str):
            raise TypeError("Expected argument 'version_id_marker' to be a str")
        pulumi.set(__self__, "version_id_marker", version_id_marker)
        if with_versions and not isinstance(with_versions, bool):
            raise TypeError("Expected argument 'with_versions' to be a bool")
        pulumi.set(__self__, "with_versions", with_versions)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyMarker")
    def key_marker(self) -> Optional[builtins.str]:
        """
        Key to start with when listing objects
        """
        return pulumi.get(self, "key_marker")

    @property
    @pulumi.getter
    def limit(self) -> Optional[builtins.float]:
        """
        Limit the number of objects returned (1000 maximum, defaults to 1000)
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def objects(self) -> Sequence['outputs.GetStorageObjectsObjectResult']:
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        List objects whose key begins with this prefix
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> builtins.str:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="versionIdMarker")
    def version_id_marker(self) -> Optional[builtins.str]:
        """
        Version ID to start listing from
        """
        return pulumi.get(self, "version_id_marker")

    @property
    @pulumi.getter(name="withVersions")
    def with_versions(self) -> Optional[builtins.bool]:
        """
        List object versions
        """
        return pulumi.get(self, "with_versions")


class AwaitableGetStorageObjectsResult(GetStorageObjectsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageObjectsResult(
            id=self.id,
            key_marker=self.key_marker,
            limit=self.limit,
            name=self.name,
            objects=self.objects,
            prefix=self.prefix,
            region_name=self.region_name,
            service_name=self.service_name,
            version_id_marker=self.version_id_marker,
            with_versions=self.with_versions)


def get_storage_objects(key_marker: Optional[builtins.str] = None,
                        limit: Optional[builtins.float] = None,
                        name: Optional[builtins.str] = None,
                        prefix: Optional[builtins.str] = None,
                        region_name: Optional[builtins.str] = None,
                        service_name: Optional[builtins.str] = None,
                        version_id_marker: Optional[builtins.str] = None,
                        with_versions: Optional[builtins.bool] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageObjectsResult:
    """
    Get objects of S3™* compatible storage containers. \\* S3 is a trademark filed by Amazon Technologies,Inc. OVHcloud's service is not sponsored by, endorsed by, or otherwise affiliated with Amazon Technologies,Inc.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    objects = ovh.CloudProject.get_storage_objects(service_name="<public cloud project ID>",
        region_name="GRA",
        name="<bucket name>")
    ```


    :param builtins.str key_marker: Key to start with when listing objects
    :param builtins.float limit: Limit the number of objects returned (1000 maximum, defaults to 1000)
    :param builtins.str name: Name
    :param builtins.str prefix: List objects whose key begins with this prefix
    :param builtins.str region_name: Region name
    :param builtins.str service_name: Service name
    :param builtins.str version_id_marker: Version ID to start listing from
    :param builtins.bool with_versions: List object versions
    """
    __args__ = dict()
    __args__['keyMarker'] = key_marker
    __args__['limit'] = limit
    __args__['name'] = name
    __args__['prefix'] = prefix
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    __args__['versionIdMarker'] = version_id_marker
    __args__['withVersions'] = with_versions
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getStorageObjects:getStorageObjects', __args__, opts=opts, typ=GetStorageObjectsResult).value

    return AwaitableGetStorageObjectsResult(
        id=pulumi.get(__ret__, 'id'),
        key_marker=pulumi.get(__ret__, 'key_marker'),
        limit=pulumi.get(__ret__, 'limit'),
        name=pulumi.get(__ret__, 'name'),
        objects=pulumi.get(__ret__, 'objects'),
        prefix=pulumi.get(__ret__, 'prefix'),
        region_name=pulumi.get(__ret__, 'region_name'),
        service_name=pulumi.get(__ret__, 'service_name'),
        version_id_marker=pulumi.get(__ret__, 'version_id_marker'),
        with_versions=pulumi.get(__ret__, 'with_versions'))
def get_storage_objects_output(key_marker: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               limit: Optional[pulumi.Input[Optional[builtins.float]]] = None,
                               name: Optional[pulumi.Input[builtins.str]] = None,
                               prefix: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               region_name: Optional[pulumi.Input[builtins.str]] = None,
                               service_name: Optional[pulumi.Input[builtins.str]] = None,
                               version_id_marker: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               with_versions: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageObjectsResult]:
    """
    Get objects of S3™* compatible storage containers. \\* S3 is a trademark filed by Amazon Technologies,Inc. OVHcloud's service is not sponsored by, endorsed by, or otherwise affiliated with Amazon Technologies,Inc.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    objects = ovh.CloudProject.get_storage_objects(service_name="<public cloud project ID>",
        region_name="GRA",
        name="<bucket name>")
    ```


    :param builtins.str key_marker: Key to start with when listing objects
    :param builtins.float limit: Limit the number of objects returned (1000 maximum, defaults to 1000)
    :param builtins.str name: Name
    :param builtins.str prefix: List objects whose key begins with this prefix
    :param builtins.str region_name: Region name
    :param builtins.str service_name: Service name
    :param builtins.str version_id_marker: Version ID to start listing from
    :param builtins.bool with_versions: List object versions
    """
    __args__ = dict()
    __args__['keyMarker'] = key_marker
    __args__['limit'] = limit
    __args__['name'] = name
    __args__['prefix'] = prefix
    __args__['regionName'] = region_name
    __args__['serviceName'] = service_name
    __args__['versionIdMarker'] = version_id_marker
    __args__['withVersions'] = with_versions
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProject/getStorageObjects:getStorageObjects', __args__, opts=opts, typ=GetStorageObjectsResult)
    return __ret__.apply(lambda __response__: GetStorageObjectsResult(
        id=pulumi.get(__response__, 'id'),
        key_marker=pulumi.get(__response__, 'key_marker'),
        limit=pulumi.get(__response__, 'limit'),
        name=pulumi.get(__response__, 'name'),
        objects=pulumi.get(__response__, 'objects'),
        prefix=pulumi.get(__response__, 'prefix'),
        region_name=pulumi.get(__response__, 'region_name'),
        service_name=pulumi.get(__response__, 'service_name'),
        version_id_marker=pulumi.get(__response__, 'version_id_marker'),
        with_versions=pulumi.get(__response__, 'with_versions')))
