# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 flavor_id: pulumi.Input[builtins.str],
                 network: pulumi.Input['LoadBalancerNetworkArgs'],
                 region_name: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[builtins.str] flavor_id: Loadbalancer flavor id
        :param pulumi.Input['LoadBalancerNetworkArgs'] network: Network information to create the loadbalancer
        :param pulumi.Input[builtins.str] region_name: Region name
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] description: Description of the loadbalancer
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]] listeners: Listeners to create with the loadbalancer
        :param pulumi.Input[builtins.str] name: Name of the resource
        """
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "service_name", service_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[builtins.str]:
        """
        Loadbalancer flavor id
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input['LoadBalancerNetworkArgs']:
        """
        Network information to create the loadbalancer
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input['LoadBalancerNetworkArgs']):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[builtins.str]:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the loadbalancer
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]]:
        """
        Listeners to create with the loadbalancer
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[builtins.str]] = None,
                 floating_ip: Optional[pulumi.Input['LoadBalancerFloatingIpArgs']] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input['LoadBalancerNetworkArgs']] = None,
                 operating_status: Optional[pulumi.Input[builtins.str]] = None,
                 provisioning_status: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 vip_address: Optional[pulumi.Input[builtins.str]] = None,
                 vip_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[builtins.str] created_at: The UTC date and timestamp when the resource was created
        :param pulumi.Input[builtins.str] description: Description of the loadbalancer
        :param pulumi.Input[builtins.str] flavor_id: Loadbalancer flavor id
        :param pulumi.Input['LoadBalancerFloatingIpArgs'] floating_ip: Information about floating IP
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]] listeners: Listeners to create with the loadbalancer
        :param pulumi.Input[builtins.str] name: Name of the resource
        :param pulumi.Input['LoadBalancerNetworkArgs'] network: Network information to create the loadbalancer
        :param pulumi.Input[builtins.str] operating_status: Operating status of the resource
        :param pulumi.Input[builtins.str] provisioning_status: Provisioning status of the resource
        :param pulumi.Input[builtins.str] region: Region of the resource
        :param pulumi.Input[builtins.str] region_name: Region name
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] updated_at: UTC date and timestamp when the resource was created
        :param pulumi.Input[builtins.str] vip_address: IP address of the Virtual IP
        :param pulumi.Input[builtins.str] vip_network_id: Openstack ID of the network for the Virtual IP
        :param pulumi.Input[builtins.str] vip_subnet_id: ID of the subnet for the Virtual IP
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if floating_ip is not None:
            pulumi.set(__self__, "floating_ip", floating_ip)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if operating_status is not None:
            pulumi.set(__self__, "operating_status", operating_status)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vip_address is not None:
            pulumi.set(__self__, "vip_address", vip_address)
        if vip_network_id is not None:
            pulumi.set(__self__, "vip_network_id", vip_network_id)
        if vip_subnet_id is not None:
            pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UTC date and timestamp when the resource was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the loadbalancer
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Loadbalancer flavor id
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="floatingIp")
    def floating_ip(self) -> Optional[pulumi.Input['LoadBalancerFloatingIpArgs']]:
        """
        Information about floating IP
        """
        return pulumi.get(self, "floating_ip")

    @floating_ip.setter
    def floating_ip(self, value: Optional[pulumi.Input['LoadBalancerFloatingIpArgs']]):
        pulumi.set(self, "floating_ip", value)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]]:
        """
        Listeners to create with the loadbalancer
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['LoadBalancerNetworkArgs']]:
        """
        Network information to create the loadbalancer
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['LoadBalancerNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operating status of the resource
        """
        return pulumi.get(self, "operating_status")

    @operating_status.setter
    def operating_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operating_status", value)

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provisioning status of the resource
        """
        return pulumi.get(self, "provisioning_status")

    @provisioning_status.setter
    def provisioning_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioning_status", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region of the resource
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UTC date and timestamp when the resource was created
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address of the Virtual IP
        """
        return pulumi.get(self, "vip_address")

    @vip_address.setter
    def vip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vip_address", value)

    @property
    @pulumi.getter(name="vipNetworkId")
    def vip_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Openstack ID of the network for the Virtual IP
        """
        return pulumi.get(self, "vip_network_id")

    @vip_network_id.setter
    def vip_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vip_network_id", value)

    @property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the subnet for the Virtual IP
        """
        return pulumi.get(self, "vip_subnet_id")

    @vip_subnet_id.setter
    def vip_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vip_subnet_id", value)


@pulumi.type_token("ovh:CloudProject/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[builtins.str]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerListenerArgs', 'LoadBalancerListenerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['LoadBalancerNetworkArgs', 'LoadBalancerNetworkArgsDict']]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        lb = ovh.cloud_project.LoadBalancer("lb",
            service_name="<public cloud project ID>",
            region_name="GRA9",
            flavor_id="<loadbalancer flavor ID>",
            network={
                "private": {
                    "network": {
                        "id": [region for region in mypriv["regionsAttributes"] if region["region"] == "GRA9"][0]["openstackid"],
                        "subnet_id": myprivsub["id"],
                    },
                },
            },
            description="My new LB",
            listeners=[
                {
                    "port": 34568,
                    "protocol": "tcp",
                },
                {
                    "port": 34569,
                    "protocol": "udp",
                },
            ])
        ```

        ### Example usage with network and subnet creation

        ```python
        import pulumi
        import pulumi_ovh as ovh

        priv = ovh.cloud_project.NetworkPrivate("priv",
            service_name="<public cloud project ID>",
            vlan_id=10,
            name="my_priv",
            regions=["GRA9"])
        privsub = ovh.cloud_project.NetworkPrivateSubnet("privsub",
            service_name=priv.service_name,
            network_id=priv.id,
            region="GRA9",
            start="10.0.0.2",
            end="10.0.255.254",
            network="10.0.0.0/16",
            dhcp=True)
        lb = ovh.cloud_project.LoadBalancer("lb",
            service_name=privsub.service_name,
            region_name=privsub.region,
            flavor_id="<loadbalancer flavor ID>",
            network={
                "private": {
                    "network": {
                        "id": priv.regions_attributes.apply(lambda regions_attributes: [region for region in regions_attributes if region.region == "GRA9"])[0].apply(lambda regions: regions.openstackid),
                        "subnet_id": privsub.id,
                    },
                },
            },
            description="My new LB",
            listeners=[
                {
                    "port": 34568,
                    "protocol": "tcp",
                },
                {
                    "port": 34569,
                    "protocol": "udp",
                },
            ])
        ```

        ## Import

        A load balancer in a public cloud project can be imported using the `service_name`, `region_name` and `id` attributes. Using the following configuration:

        terraform

        import {

          id = "<service_name>/<region_name>/<id>"

          to = ovh_cloud_project_loadbalancer.lb

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=lb.tf

        $ pulumi up

        The file `lb.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the loadbalancer
        :param pulumi.Input[builtins.str] flavor_id: Loadbalancer flavor id
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerListenerArgs', 'LoadBalancerListenerArgsDict']]]] listeners: Listeners to create with the loadbalancer
        :param pulumi.Input[builtins.str] name: Name of the resource
        :param pulumi.Input[Union['LoadBalancerNetworkArgs', 'LoadBalancerNetworkArgsDict']] network: Network information to create the loadbalancer
        :param pulumi.Input[builtins.str] region_name: Region name
        :param pulumi.Input[builtins.str] service_name: Service name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        lb = ovh.cloud_project.LoadBalancer("lb",
            service_name="<public cloud project ID>",
            region_name="GRA9",
            flavor_id="<loadbalancer flavor ID>",
            network={
                "private": {
                    "network": {
                        "id": [region for region in mypriv["regionsAttributes"] if region["region"] == "GRA9"][0]["openstackid"],
                        "subnet_id": myprivsub["id"],
                    },
                },
            },
            description="My new LB",
            listeners=[
                {
                    "port": 34568,
                    "protocol": "tcp",
                },
                {
                    "port": 34569,
                    "protocol": "udp",
                },
            ])
        ```

        ### Example usage with network and subnet creation

        ```python
        import pulumi
        import pulumi_ovh as ovh

        priv = ovh.cloud_project.NetworkPrivate("priv",
            service_name="<public cloud project ID>",
            vlan_id=10,
            name="my_priv",
            regions=["GRA9"])
        privsub = ovh.cloud_project.NetworkPrivateSubnet("privsub",
            service_name=priv.service_name,
            network_id=priv.id,
            region="GRA9",
            start="10.0.0.2",
            end="10.0.255.254",
            network="10.0.0.0/16",
            dhcp=True)
        lb = ovh.cloud_project.LoadBalancer("lb",
            service_name=privsub.service_name,
            region_name=privsub.region,
            flavor_id="<loadbalancer flavor ID>",
            network={
                "private": {
                    "network": {
                        "id": priv.regions_attributes.apply(lambda regions_attributes: [region for region in regions_attributes if region.region == "GRA9"])[0].apply(lambda regions: regions.openstackid),
                        "subnet_id": privsub.id,
                    },
                },
            },
            description="My new LB",
            listeners=[
                {
                    "port": 34568,
                    "protocol": "tcp",
                },
                {
                    "port": 34569,
                    "protocol": "udp",
                },
            ])
        ```

        ## Import

        A load balancer in a public cloud project can be imported using the `service_name`, `region_name` and `id` attributes. Using the following configuration:

        terraform

        import {

          id = "<service_name>/<region_name>/<id>"

          to = ovh_cloud_project_loadbalancer.lb

        }

        You can then run:

        bash

        $ pulumi preview -generate-config-out=lb.tf

        $ pulumi up

        The file `lb.tf` will then contain the imported resource's configuration, that can be copied next to the `import` block above. See https://developer.hashicorp.com/terraform/language/import/generating-configuration for more details.

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[builtins.str]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerListenerArgs', 'LoadBalancerListenerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['LoadBalancerNetworkArgs', 'LoadBalancerNetworkArgsDict']]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["description"] = description
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["listeners"] = listeners
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if region_name is None and not opts.urn:
                raise TypeError("Missing required property 'region_name'")
            __props__.__dict__["region_name"] = region_name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["floating_ip"] = None
            __props__.__dict__["operating_status"] = None
            __props__.__dict__["provisioning_status"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["vip_address"] = None
            __props__.__dict__["vip_network_id"] = None
            __props__.__dict__["vip_subnet_id"] = None
        super(LoadBalancer, __self__).__init__(
            'ovh:CloudProject/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            flavor_id: Optional[pulumi.Input[builtins.str]] = None,
            floating_ip: Optional[pulumi.Input[Union['LoadBalancerFloatingIpArgs', 'LoadBalancerFloatingIpArgsDict']]] = None,
            listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerListenerArgs', 'LoadBalancerListenerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[Union['LoadBalancerNetworkArgs', 'LoadBalancerNetworkArgsDict']]] = None,
            operating_status: Optional[pulumi.Input[builtins.str]] = None,
            provisioning_status: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            region_name: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            vip_address: Optional[pulumi.Input[builtins.str]] = None,
            vip_network_id: Optional[pulumi.Input[builtins.str]] = None,
            vip_subnet_id: Optional[pulumi.Input[builtins.str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The UTC date and timestamp when the resource was created
        :param pulumi.Input[builtins.str] description: Description of the loadbalancer
        :param pulumi.Input[builtins.str] flavor_id: Loadbalancer flavor id
        :param pulumi.Input[Union['LoadBalancerFloatingIpArgs', 'LoadBalancerFloatingIpArgsDict']] floating_ip: Information about floating IP
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerListenerArgs', 'LoadBalancerListenerArgsDict']]]] listeners: Listeners to create with the loadbalancer
        :param pulumi.Input[builtins.str] name: Name of the resource
        :param pulumi.Input[Union['LoadBalancerNetworkArgs', 'LoadBalancerNetworkArgsDict']] network: Network information to create the loadbalancer
        :param pulumi.Input[builtins.str] operating_status: Operating status of the resource
        :param pulumi.Input[builtins.str] provisioning_status: Provisioning status of the resource
        :param pulumi.Input[builtins.str] region: Region of the resource
        :param pulumi.Input[builtins.str] region_name: Region name
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] updated_at: UTC date and timestamp when the resource was created
        :param pulumi.Input[builtins.str] vip_address: IP address of the Virtual IP
        :param pulumi.Input[builtins.str] vip_network_id: Openstack ID of the network for the Virtual IP
        :param pulumi.Input[builtins.str] vip_subnet_id: ID of the subnet for the Virtual IP
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["floating_ip"] = floating_ip
        __props__.__dict__["listeners"] = listeners
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["operating_status"] = operating_status
        __props__.__dict__["provisioning_status"] = provisioning_status
        __props__.__dict__["region"] = region
        __props__.__dict__["region_name"] = region_name
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vip_address"] = vip_address
        __props__.__dict__["vip_network_id"] = vip_network_id
        __props__.__dict__["vip_subnet_id"] = vip_subnet_id
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The UTC date and timestamp when the resource was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the loadbalancer
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[builtins.str]:
        """
        Loadbalancer flavor id
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="floatingIp")
    def floating_ip(self) -> pulumi.Output['outputs.LoadBalancerFloatingIp']:
        """
        Information about floating IP
        """
        return pulumi.get(self, "floating_ip")

    @property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerListener']]]:
        """
        Listeners to create with the loadbalancer
        """
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output['outputs.LoadBalancerNetwork']:
        """
        Network information to create the loadbalancer
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> pulumi.Output[builtins.str]:
        """
        Operating status of the resource
        """
        return pulumi.get(self, "operating_status")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> pulumi.Output[builtins.str]:
        """
        Provisioning status of the resource
        """
        return pulumi.get(self, "provisioning_status")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region of the resource
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Output[builtins.str]:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        UTC date and timestamp when the resource was created
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> pulumi.Output[builtins.str]:
        """
        IP address of the Virtual IP
        """
        return pulumi.get(self, "vip_address")

    @property
    @pulumi.getter(name="vipNetworkId")
    def vip_network_id(self) -> pulumi.Output[builtins.str]:
        """
        Openstack ID of the network for the Virtual IP
        """
        return pulumi.get(self, "vip_network_id")

    @property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the subnet for the Virtual IP
        """
        return pulumi.get(self, "vip_subnet_id")

