# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectRegionArgs', 'ProjectRegion']

@pulumi.input_type
class ProjectRegionArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ProjectRegion resource.
        :param pulumi.Input[builtins.str] region: Region to add to your project
        :param pulumi.Input[builtins.str] service_name: Service name
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        Region to add to your project
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _ProjectRegionState:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 continent_code: Optional[pulumi.Input[builtins.str]] = None,
                 country_code: Optional[pulumi.Input[builtins.str]] = None,
                 datacenter_location: Optional[pulumi.Input[builtins.str]] = None,
                 ip_countries: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectRegionServiceArgs']]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectRegion resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: Availability zones of the region
        :param pulumi.Input[builtins.str] continent_code: Region continent code
        :param pulumi.Input[builtins.str] country_code: Region country code
        :param pulumi.Input[builtins.str] datacenter_location: Location of the datacenter where the region is
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_countries: Allowed countries for failover ip
        :param pulumi.Input[builtins.str] name: Region name
        :param pulumi.Input[builtins.str] region: Region to add to your project
        :param pulumi.Input[builtins.str] region_name: Region name
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[Sequence[pulumi.Input['ProjectRegionServiceArgs']]] services: Details about components status
        :param pulumi.Input[builtins.str] status: Openstack region status
        :param pulumi.Input[builtins.str] type: Region type
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if continent_code is not None:
            pulumi.set(__self__, "continent_code", continent_code)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if datacenter_location is not None:
            pulumi.set(__self__, "datacenter_location", datacenter_location)
        if ip_countries is not None:
            pulumi.set(__self__, "ip_countries", ip_countries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Availability zones of the region
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="continentCode")
    def continent_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region continent code
        """
        return pulumi.get(self, "continent_code")

    @continent_code.setter
    def continent_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "continent_code", value)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region country code
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter(name="datacenterLocation")
    def datacenter_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the datacenter where the region is
        """
        return pulumi.get(self, "datacenter_location")

    @datacenter_location.setter
    def datacenter_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datacenter_location", value)

    @property
    @pulumi.getter(name="ipCountries")
    def ip_countries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Allowed countries for failover ip
        """
        return pulumi.get(self, "ip_countries")

    @ip_countries.setter
    def ip_countries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_countries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region to add to your project
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectRegionServiceArgs']]]]:
        """
        Details about components status
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectRegionServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Openstack region status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("ovh:CloudProject/projectRegion:ProjectRegion")
class ProjectRegion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        region = ovh.cloud_project.ProjectRegion("region",
            service_name="<public cloud project ID>",
            region="EU-WEST-LZ-LUX-A")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: Region to add to your project
        :param pulumi.Input[builtins.str] service_name: Service name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectRegionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        region = ovh.cloud_project.ProjectRegion("region",
            service_name="<public cloud project ID>",
            region="EU-WEST-LZ-LUX-A")
        ```

        :param str resource_name: The name of the resource.
        :param ProjectRegionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectRegionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectRegionArgs.__new__(ProjectRegionArgs)

            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["availability_zones"] = None
            __props__.__dict__["continent_code"] = None
            __props__.__dict__["country_code"] = None
            __props__.__dict__["datacenter_location"] = None
            __props__.__dict__["ip_countries"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["region_name"] = None
            __props__.__dict__["services"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
        super(ProjectRegion, __self__).__init__(
            'ovh:CloudProject/projectRegion:ProjectRegion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            continent_code: Optional[pulumi.Input[builtins.str]] = None,
            country_code: Optional[pulumi.Input[builtins.str]] = None,
            datacenter_location: Optional[pulumi.Input[builtins.str]] = None,
            ip_countries: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            region_name: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectRegionServiceArgs', 'ProjectRegionServiceArgsDict']]]]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectRegion':
        """
        Get an existing ProjectRegion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: Availability zones of the region
        :param pulumi.Input[builtins.str] continent_code: Region continent code
        :param pulumi.Input[builtins.str] country_code: Region country code
        :param pulumi.Input[builtins.str] datacenter_location: Location of the datacenter where the region is
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_countries: Allowed countries for failover ip
        :param pulumi.Input[builtins.str] name: Region name
        :param pulumi.Input[builtins.str] region: Region to add to your project
        :param pulumi.Input[builtins.str] region_name: Region name
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectRegionServiceArgs', 'ProjectRegionServiceArgsDict']]]] services: Details about components status
        :param pulumi.Input[builtins.str] status: Openstack region status
        :param pulumi.Input[builtins.str] type: Region type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectRegionState.__new__(_ProjectRegionState)

        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["continent_code"] = continent_code
        __props__.__dict__["country_code"] = country_code
        __props__.__dict__["datacenter_location"] = datacenter_location
        __props__.__dict__["ip_countries"] = ip_countries
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["region_name"] = region_name
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["services"] = services
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return ProjectRegion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Availability zones of the region
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="continentCode")
    def continent_code(self) -> pulumi.Output[builtins.str]:
        """
        Region continent code
        """
        return pulumi.get(self, "continent_code")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[builtins.str]:
        """
        Region country code
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="datacenterLocation")
    def datacenter_location(self) -> pulumi.Output[builtins.str]:
        """
        Location of the datacenter where the region is
        """
        return pulumi.get(self, "datacenter_location")

    @property
    @pulumi.getter(name="ipCountries")
    def ip_countries(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Allowed countries for failover ip
        """
        return pulumi.get(self, "ip_countries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Region name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region to add to your project
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Output[builtins.str]:
        """
        Region name
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence['outputs.ProjectRegionService']]:
        """
        Details about components status
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Openstack region status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Region type
        """
        return pulumi.get(self, "type")

