# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegionLoadBalancerLogSubscriptionArgs', 'RegionLoadBalancerLogSubscription']

@pulumi.input_type
class RegionLoadBalancerLogSubscriptionArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[builtins.str],
                 loadbalancer_id: pulumi.Input[builtins.str],
                 region_name: pulumi.Input[builtins.str],
                 stream_id: pulumi.Input[builtins.str],
                 service_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RegionLoadBalancerLogSubscription resource.
        :param pulumi.Input[builtins.str] kind: haproxy **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] loadbalancer_id: Loadbalancer id to get the logs **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] region_name: A valid OVHcloud public cloud region name in which the loadbalancer will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] stream_id: Data stream id to use for the subscription **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "stream_id", stream_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[builtins.str]:
        """
        haproxy **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[builtins.str]:
        """
        Loadbalancer id to get the logs **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[builtins.str]:
        """
        A valid OVHcloud public cloud region name in which the loadbalancer will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Input[builtins.str]:
        """
        Data stream id to use for the subscription **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _RegionLoadBalancerLogSubscriptionState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 ldp_service_name: Optional[pulumi.Input[builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 operation_id: Optional[pulumi.Input[builtins.str]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionLoadBalancerLogSubscription resources.
        :param pulumi.Input[builtins.str] created_at: The date of the subscription creation
        :param pulumi.Input[builtins.str] kind: haproxy **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] ldp_service_name: LDP service name
        :param pulumi.Input[builtins.str] loadbalancer_id: Loadbalancer id to get the logs **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] operation_id: The operation ID
        :param pulumi.Input[builtins.str] region_name: A valid OVHcloud public cloud region name in which the loadbalancer will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] resource_name: The resource name
        :param pulumi.Input[builtins.str] resource_type: The resource type
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] stream_id: Data stream id to use for the subscription **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] subscription_id: The subscription id
        :param pulumi.Input[builtins.str] updated_at: The last update of the subscription
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if ldp_service_name is not None:
            pulumi.set(__self__, "ldp_service_name", ldp_service_name)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date of the subscription creation
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        haproxy **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="ldpServiceName")
    def ldp_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        LDP service name
        """
        return pulumi.get(self, "ldp_service_name")

    @ldp_service_name.setter
    def ldp_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ldp_service_name", value)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Loadbalancer id to get the logs **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The operation ID
        """
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation_id", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A valid OVHcloud public cloud region name in which the loadbalancer will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource type
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Data stream id to use for the subscription **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subscription id
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last update of the subscription
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("ovh:CloudProject/regionLoadBalancerLogSubscription:RegionLoadBalancerLogSubscription")
class RegionLoadBalancerLogSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Subscribe to a Managed Loadbalance Logs Service in a public cloud project.

        ## Example Usage

        Create a subscription

        ```python
        import pulumi
        import pulumi_ovh as ovh

        subscription = ovh.cloud_project.RegionLoadBalancerLogSubscription("subscription",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            region_name="yyyy",
            loadbalancer_id="aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
            kind="haproxy",
            stream_id="ffffffff-gggg-hhhh-iiii-jjjjjjjjjjjj")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] kind: haproxy **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] loadbalancer_id: Loadbalancer id to get the logs **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] region_name: A valid OVHcloud public cloud region name in which the loadbalancer will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] stream_id: Data stream id to use for the subscription **Changing this value recreates the resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionLoadBalancerLogSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Subscribe to a Managed Loadbalance Logs Service in a public cloud project.

        ## Example Usage

        Create a subscription

        ```python
        import pulumi
        import pulumi_ovh as ovh

        subscription = ovh.cloud_project.RegionLoadBalancerLogSubscription("subscription",
            service_name="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            region_name="yyyy",
            loadbalancer_id="aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
            kind="haproxy",
            stream_id="ffffffff-gggg-hhhh-iiii-jjjjjjjjjjjj")
        ```

        :param str resource_name: The name of the resource.
        :param RegionLoadBalancerLogSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionLoadBalancerLogSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionLoadBalancerLogSubscriptionArgs.__new__(RegionLoadBalancerLogSubscriptionArgs)

            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            if region_name is None and not opts.urn:
                raise TypeError("Missing required property 'region_name'")
            __props__.__dict__["region_name"] = region_name
            __props__.__dict__["service_name"] = service_name
            if stream_id is None and not opts.urn:
                raise TypeError("Missing required property 'stream_id'")
            __props__.__dict__["stream_id"] = stream_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["ldp_service_name"] = None
            __props__.__dict__["operation_id"] = None
            __props__.__dict__["resource_name"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["subscription_id"] = None
            __props__.__dict__["updated_at"] = None
        super(RegionLoadBalancerLogSubscription, __self__).__init__(
            'ovh:CloudProject/regionLoadBalancerLogSubscription:RegionLoadBalancerLogSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            ldp_service_name: Optional[pulumi.Input[builtins.str]] = None,
            loadbalancer_id: Optional[pulumi.Input[builtins.str]] = None,
            operation_id: Optional[pulumi.Input[builtins.str]] = None,
            region_name: Optional[pulumi.Input[builtins.str]] = None,
            resource_name_: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            stream_id: Optional[pulumi.Input[builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'RegionLoadBalancerLogSubscription':
        """
        Get an existing RegionLoadBalancerLogSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The date of the subscription creation
        :param pulumi.Input[builtins.str] kind: haproxy **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] ldp_service_name: LDP service name
        :param pulumi.Input[builtins.str] loadbalancer_id: Loadbalancer id to get the logs **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] operation_id: The operation ID
        :param pulumi.Input[builtins.str] region_name: A valid OVHcloud public cloud region name in which the loadbalancer will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] resource_name_: The resource name
        :param pulumi.Input[builtins.str] resource_type: The resource type
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] stream_id: Data stream id to use for the subscription **Changing this value recreates the resource.**
        :param pulumi.Input[builtins.str] subscription_id: The subscription id
        :param pulumi.Input[builtins.str] updated_at: The last update of the subscription
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionLoadBalancerLogSubscriptionState.__new__(_RegionLoadBalancerLogSubscriptionState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["kind"] = kind
        __props__.__dict__["ldp_service_name"] = ldp_service_name
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["operation_id"] = operation_id
        __props__.__dict__["region_name"] = region_name
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["stream_id"] = stream_id
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["updated_at"] = updated_at
        return RegionLoadBalancerLogSubscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date of the subscription creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        haproxy **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="ldpServiceName")
    def ldp_service_name(self) -> pulumi.Output[builtins.str]:
        """
        LDP service name
        """
        return pulumi.get(self, "ldp_service_name")

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[builtins.str]:
        """
        Loadbalancer id to get the logs **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "loadbalancer_id")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> pulumi.Output[builtins.str]:
        """
        The operation ID
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Output[builtins.str]:
        """
        A valid OVHcloud public cloud region name in which the loadbalancer will be available. Ex.: "GRA11". **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The resource type
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Output[builtins.str]:
        """
        Data stream id to use for the subscription **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[builtins.str]:
        """
        The subscription id
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The last update of the subscription
        """
        return pulumi.get(self, "updated_at")

