# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionNetworkArgs', 'RegionNetwork']

@pulumi.input_type
class RegionNetworkArgs:
    def __init__(__self__, *,
                 region_name: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 subnet: pulumi.Input['RegionNetworkSubnetArgs'],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[builtins.float]] = None):
        """
        The set of arguments for constructing a RegionNetwork resource.
        :param pulumi.Input[builtins.str] region_name: Network region
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project
        :param pulumi.Input['RegionNetworkSubnetArgs'] subnet: Parameters to create a subnet
        :param pulumi.Input[builtins.str] name: Name of the network
        :param pulumi.Input[builtins.float] vlan_id: VLAN ID, between 1 and 4000
        """
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "subnet", subnet)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[builtins.str]:
        """
        Network region
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        The id of the public cloud project
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input['RegionNetworkSubnetArgs']:
        """
        Parameters to create a subnet
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input['RegionNetworkSubnetArgs']):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the network
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        VLAN ID, between 1 and 4000
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.input_type
class _RegionNetworkState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input['RegionNetworkSubnetArgs']] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[builtins.float]] = None):
        """
        Input properties used for looking up and filtering RegionNetwork resources.
        :param pulumi.Input[builtins.str] name: Name of the network
        :param pulumi.Input[builtins.str] region: Network region returned by the API
        :param pulumi.Input[builtins.str] region_name: Network region
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project
        :param pulumi.Input['RegionNetworkSubnetArgs'] subnet: Parameters to create a subnet
        :param pulumi.Input[builtins.str] visibility: Network visibility
        :param pulumi.Input[builtins.float] vlan_id: VLAN ID, between 1 and 4000
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the network
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network region returned by the API
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network region
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the public cloud project
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['RegionNetworkSubnetArgs']]:
        """
        Parameters to create a subnet
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['RegionNetworkSubnetArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network visibility
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        VLAN ID, between 1 and 4000
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.type_token("ovh:CloudProject/regionNetwork:RegionNetwork")
class RegionNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[Union['RegionNetworkSubnetArgs', 'RegionNetworkSubnetArgsDict']]] = None,
                 vlan_id: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        """
        Creates a network in a public cloud project.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Name of the network
        :param pulumi.Input[builtins.str] region_name: Network region
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project
        :param pulumi.Input[Union['RegionNetworkSubnetArgs', 'RegionNetworkSubnetArgsDict']] subnet: Parameters to create a subnet
        :param pulumi.Input[builtins.float] vlan_id: VLAN ID, between 1 and 4000
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a network in a public cloud project.

        :param str resource_name: The name of the resource.
        :param RegionNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[Union['RegionNetworkSubnetArgs', 'RegionNetworkSubnetArgsDict']]] = None,
                 vlan_id: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionNetworkArgs.__new__(RegionNetworkArgs)

            __props__.__dict__["name"] = name
            if region_name is None and not opts.urn:
                raise TypeError("Missing required property 'region_name'")
            __props__.__dict__["region_name"] = region_name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if subnet is None and not opts.urn:
                raise TypeError("Missing required property 'subnet'")
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["region"] = None
            __props__.__dict__["visibility"] = None
        super(RegionNetwork, __self__).__init__(
            'ovh:CloudProject/regionNetwork:RegionNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            region_name: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            subnet: Optional[pulumi.Input[Union['RegionNetworkSubnetArgs', 'RegionNetworkSubnetArgsDict']]] = None,
            visibility: Optional[pulumi.Input[builtins.str]] = None,
            vlan_id: Optional[pulumi.Input[builtins.float]] = None) -> 'RegionNetwork':
        """
        Get an existing RegionNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Name of the network
        :param pulumi.Input[builtins.str] region: Network region returned by the API
        :param pulumi.Input[builtins.str] region_name: Network region
        :param pulumi.Input[builtins.str] service_name: The id of the public cloud project
        :param pulumi.Input[Union['RegionNetworkSubnetArgs', 'RegionNetworkSubnetArgsDict']] subnet: Parameters to create a subnet
        :param pulumi.Input[builtins.str] visibility: Network visibility
        :param pulumi.Input[builtins.float] vlan_id: VLAN ID, between 1 and 4000
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionNetworkState.__new__(_RegionNetworkState)

        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["region_name"] = region_name
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["visibility"] = visibility
        __props__.__dict__["vlan_id"] = vlan_id
        return RegionNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the network
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Network region returned by the API
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Output[builtins.str]:
        """
        Network region
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The id of the public cloud project
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output['outputs.RegionNetworkSubnet']:
        """
        Parameters to create a subnet
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[builtins.str]:
        """
        Network visibility
        """
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[builtins.float]:
        """
        VLAN ID, between 1 and 4000
        """
        return pulumi.get(self, "vlan_id")

