# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDatabaseIntegrationResult',
    'AwaitableGetDatabaseIntegrationResult',
    'get_database_integration',
    'get_database_integration_output',
]

@pulumi.output_type
class GetDatabaseIntegrationResult:
    """
    A collection of values returned by getDatabaseIntegration.
    """
    def __init__(__self__, cluster_id=None, destination_service_id=None, engine=None, id=None, parameters=None, service_name=None, source_service_id=None, status=None, type=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if destination_service_id and not isinstance(destination_service_id, str):
            raise TypeError("Expected argument 'destination_service_id' to be a str")
        pulumi.set(__self__, "destination_service_id", destination_service_id)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if source_service_id and not isinstance(source_service_id, str):
            raise TypeError("Expected argument 'source_service_id' to be a str")
        pulumi.set(__self__, "source_service_id", source_service_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="destinationServiceId")
    def destination_service_id(self) -> builtins.str:
        """
        ID of the destination service.
        """
        return pulumi.get(self, "destination_service_id")

    @property
    @pulumi.getter
    def engine(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, builtins.str]:
        """
        Parameters for the integration.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sourceServiceId")
    def source_service_id(self) -> builtins.str:
        """
        ID of the source service.
        """
        return pulumi.get(self, "source_service_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current status of the integration.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the integration.
        """
        return pulumi.get(self, "type")


class AwaitableGetDatabaseIntegrationResult(GetDatabaseIntegrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseIntegrationResult(
            cluster_id=self.cluster_id,
            destination_service_id=self.destination_service_id,
            engine=self.engine,
            id=self.id,
            parameters=self.parameters,
            service_name=self.service_name,
            source_service_id=self.source_service_id,
            status=self.status,
            type=self.type)


def get_database_integration(cluster_id: Optional[builtins.str] = None,
                             engine: Optional[builtins.str] = None,
                             id: Optional[builtins.str] = None,
                             service_name: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseIntegrationResult:
    """
    Use this data source to get information about an integration of a database cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    integration = ovh.CloudProjectDatabase.get_database_integration(service_name="XXX",
        engine="YYY",
        cluster_id="ZZZ",
        id="UUU")
    pulumi.export("integrationType", integration.type)
    ```


    :param builtins.str cluster_id: Cluster ID.
    :param builtins.str engine: The engine of the database cluster you want to add. You can find the complete list of available engine in the [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases). All engines available exept `mongodb`
    :param builtins.str id: Integration ID
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['engine'] = engine
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProjectDatabase/getDatabaseIntegration:getDatabaseIntegration', __args__, opts=opts, typ=GetDatabaseIntegrationResult).value

    return AwaitableGetDatabaseIntegrationResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        destination_service_id=pulumi.get(__ret__, 'destination_service_id'),
        engine=pulumi.get(__ret__, 'engine'),
        id=pulumi.get(__ret__, 'id'),
        parameters=pulumi.get(__ret__, 'parameters'),
        service_name=pulumi.get(__ret__, 'service_name'),
        source_service_id=pulumi.get(__ret__, 'source_service_id'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))
def get_database_integration_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                    engine: Optional[pulumi.Input[builtins.str]] = None,
                                    id: Optional[pulumi.Input[builtins.str]] = None,
                                    service_name: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseIntegrationResult]:
    """
    Use this data source to get information about an integration of a database cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    integration = ovh.CloudProjectDatabase.get_database_integration(service_name="XXX",
        engine="YYY",
        cluster_id="ZZZ",
        id="UUU")
    pulumi.export("integrationType", integration.type)
    ```


    :param builtins.str cluster_id: Cluster ID.
    :param builtins.str engine: The engine of the database cluster you want to add. You can find the complete list of available engine in the [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases). All engines available exept `mongodb`
    :param builtins.str id: Integration ID
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['engine'] = engine
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProjectDatabase/getDatabaseIntegration:getDatabaseIntegration', __args__, opts=opts, typ=GetDatabaseIntegrationResult)
    return __ret__.apply(lambda __response__: GetDatabaseIntegrationResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        destination_service_id=pulumi.get(__response__, 'destination_service_id'),
        engine=pulumi.get(__response__, 'engine'),
        id=pulumi.get(__response__, 'id'),
        parameters=pulumi.get(__response__, 'parameters'),
        service_name=pulumi.get(__response__, 'service_name'),
        source_service_id=pulumi.get(__response__, 'source_service_id'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type')))
