# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIpRestrictionsResult',
    'AwaitableGetIpRestrictionsResult',
    'get_ip_restrictions',
    'get_ip_restrictions_output',
]

@pulumi.output_type
class GetIpRestrictionsResult:
    """
    A collection of values returned by getIpRestrictions.
    """
    def __init__(__self__, cluster_id=None, engine=None, id=None, ips=None, service_name=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def engine(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ips(self) -> Sequence[builtins.str]:
        """
        The list of IP restriction of the database associated with the project.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetIpRestrictionsResult(GetIpRestrictionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpRestrictionsResult(
            cluster_id=self.cluster_id,
            engine=self.engine,
            id=self.id,
            ips=self.ips,
            service_name=self.service_name)


def get_ip_restrictions(cluster_id: Optional[builtins.str] = None,
                        engine: Optional[builtins.str] = None,
                        service_name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpRestrictionsResult:
    """
    Deprecated: Use ip_restrictions field in cloud_project_database datasource instead.

    Use this data source to get the list of IP restrictions associated with a public cloud project.

    ## Example Usage

    To get the list of IP restriction on a database cluster service:

    ```python
    import pulumi
    import pulumi_ovh as ovh

    ip_restrictions = ovh.CloudProjectDatabase.get_ip_restrictions(service_name="XXXXXX",
        engine="YYYY",
        cluster_id="ZZZZ")
    pulumi.export("ips", ip_restrictions.ips)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str engine: The engine of the database cluster you want to list IP restrictions. To get a full list of available engine visit: [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['engine'] = engine
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProjectDatabase/getIpRestrictions:getIpRestrictions', __args__, opts=opts, typ=GetIpRestrictionsResult).value

    return AwaitableGetIpRestrictionsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        engine=pulumi.get(__ret__, 'engine'),
        id=pulumi.get(__ret__, 'id'),
        ips=pulumi.get(__ret__, 'ips'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_ip_restrictions_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                               engine: Optional[pulumi.Input[builtins.str]] = None,
                               service_name: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpRestrictionsResult]:
    """
    Deprecated: Use ip_restrictions field in cloud_project_database datasource instead.

    Use this data source to get the list of IP restrictions associated with a public cloud project.

    ## Example Usage

    To get the list of IP restriction on a database cluster service:

    ```python
    import pulumi
    import pulumi_ovh as ovh

    ip_restrictions = ovh.CloudProjectDatabase.get_ip_restrictions(service_name="XXXXXX",
        engine="YYYY",
        cluster_id="ZZZZ")
    pulumi.export("ips", ip_restrictions.ips)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str engine: The engine of the database cluster you want to list IP restrictions. To get a full list of available engine visit: [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['engine'] = engine
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProjectDatabase/getIpRestrictions:getIpRestrictions', __args__, opts=opts, typ=GetIpRestrictionsResult)
    return __ret__.apply(lambda __response__: GetIpRestrictionsResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        engine=pulumi.get(__response__, 'engine'),
        id=pulumi.get(__response__, 'id'),
        ips=pulumi.get(__response__, 'ips'),
        service_name=pulumi.get(__response__, 'service_name')))
