# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKafkaSchemaRegistryAclResult',
    'AwaitableGetKafkaSchemaRegistryAclResult',
    'get_kafka_schema_registry_acl',
    'get_kafka_schema_registry_acl_output',
]

@pulumi.output_type
class GetKafkaSchemaRegistryAclResult:
    """
    A collection of values returned by getKafkaSchemaRegistryAcl.
    """
    def __init__(__self__, cluster_id=None, id=None, permission=None, resource=None, service_name=None, username=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if permission and not isinstance(permission, str):
            raise TypeError("Expected argument 'permission' to be a str")
        pulumi.set(__self__, "permission", permission)
        if resource and not isinstance(resource, str):
            raise TypeError("Expected argument 'resource' to be a str")
        pulumi.set(__self__, "resource", resource)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def permission(self) -> builtins.str:
        """
        Permission to give to this username on this topic.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        Resource affected by this ACL.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Username affected by this ACL.
        """
        return pulumi.get(self, "username")


class AwaitableGetKafkaSchemaRegistryAclResult(GetKafkaSchemaRegistryAclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaSchemaRegistryAclResult(
            cluster_id=self.cluster_id,
            id=self.id,
            permission=self.permission,
            resource=self.resource,
            service_name=self.service_name,
            username=self.username)


def get_kafka_schema_registry_acl(cluster_id: Optional[builtins.str] = None,
                                  id: Optional[builtins.str] = None,
                                  service_name: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaSchemaRegistryAclResult:
    """
    Use this data source to get information about a schema registry ACL of a kafka cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    schema_registry_acl = ovh.CloudProjectDatabase.get_kafka_schema_registry_acl(service_name="XXX",
        cluster_id="YYY",
        id="ZZZ")
    pulumi.export("aclPermission", schema_registry_acl.permission)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str id: Schema registry ACL ID
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProjectDatabase/getKafkaSchemaRegistryAcl:getKafkaSchemaRegistryAcl', __args__, opts=opts, typ=GetKafkaSchemaRegistryAclResult).value

    return AwaitableGetKafkaSchemaRegistryAclResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        permission=pulumi.get(__ret__, 'permission'),
        resource=pulumi.get(__ret__, 'resource'),
        service_name=pulumi.get(__ret__, 'service_name'),
        username=pulumi.get(__ret__, 'username'))
def get_kafka_schema_registry_acl_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                         id: Optional[pulumi.Input[builtins.str]] = None,
                                         service_name: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKafkaSchemaRegistryAclResult]:
    """
    Use this data source to get information about a schema registry ACL of a kafka cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    schema_registry_acl = ovh.CloudProjectDatabase.get_kafka_schema_registry_acl(service_name="XXX",
        cluster_id="YYY",
        id="ZZZ")
    pulumi.export("aclPermission", schema_registry_acl.permission)
    ```


    :param builtins.str cluster_id: Cluster ID
    :param builtins.str id: Schema registry ACL ID
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProjectDatabase/getKafkaSchemaRegistryAcl:getKafkaSchemaRegistryAcl', __args__, opts=opts, typ=GetKafkaSchemaRegistryAclResult)
    return __ret__.apply(lambda __response__: GetKafkaSchemaRegistryAclResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        permission=pulumi.get(__response__, 'permission'),
        resource=pulumi.get(__response__, 'resource'),
        service_name=pulumi.get(__response__, 'service_name'),
        username=pulumi.get(__response__, 'username')))
