# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPostgresSqlConnectionPoolResult',
    'AwaitableGetPostgresSqlConnectionPoolResult',
    'get_postgres_sql_connection_pool',
    'get_postgres_sql_connection_pool_output',
]

@pulumi.output_type
class GetPostgresSqlConnectionPoolResult:
    """
    A collection of values returned by getPostgresSqlConnectionPool.
    """
    def __init__(__self__, cluster_id=None, database_id=None, id=None, mode=None, name=None, port=None, service_name=None, size=None, ssl_mode=None, uri=None, user_id=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if ssl_mode and not isinstance(ssl_mode, str):
            raise TypeError("Expected argument 'ssl_mode' to be a str")
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        See Argument Reference above
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> builtins.str:
        """
        Database ID for a database that belongs to the Database cluster given above.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Connection mode to the connection pool Available modes:
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        See Argument Reference above
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port of the connection pool.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        See Argument Reference above
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        Size of the connection pool.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> builtins.str:
        """
        Ssl connection mode for the pool.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        Connection URI to the pool.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> builtins.str:
        """
        Database user authorized to connect to the pool, if none all the users are allowed.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetPostgresSqlConnectionPoolResult(GetPostgresSqlConnectionPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPostgresSqlConnectionPoolResult(
            cluster_id=self.cluster_id,
            database_id=self.database_id,
            id=self.id,
            mode=self.mode,
            name=self.name,
            port=self.port,
            service_name=self.service_name,
            size=self.size,
            ssl_mode=self.ssl_mode,
            uri=self.uri,
            user_id=self.user_id)


def get_postgres_sql_connection_pool(cluster_id: Optional[builtins.str] = None,
                                     name: Optional[builtins.str] = None,
                                     service_name: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPostgresSqlConnectionPoolResult:
    """
    Use this data source to get information about a connection pool of a postgresql cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    test_pool = ovh.CloudProjectDatabase.get_postgres_sql_connection_pool(service_name="XXX",
        cluster_id="YYY",
        name="ZZZ")
    pulumi.export("testPool", {
        "serviceName": test_pool.service_name,
        "clusterId": test_pool.cluster_id,
        "name": test_pool.name,
        "databaseId": test_pool.database_id,
        "mode": test_pool.mode,
        "size": test_pool.size,
        "port": test_pool.port,
        "sslMode": test_pool.ssl_mode,
        "uri": test_pool.uri,
        "userId": test_pool.user_id,
    })
    ```


    :param builtins.str cluster_id: Cluster ID.
    :param builtins.str name: Name of the Connection pool.
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProjectDatabase/getPostgresSqlConnectionPool:getPostgresSqlConnectionPool', __args__, opts=opts, typ=GetPostgresSqlConnectionPoolResult).value

    return AwaitableGetPostgresSqlConnectionPoolResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        database_id=pulumi.get(__ret__, 'database_id'),
        id=pulumi.get(__ret__, 'id'),
        mode=pulumi.get(__ret__, 'mode'),
        name=pulumi.get(__ret__, 'name'),
        port=pulumi.get(__ret__, 'port'),
        service_name=pulumi.get(__ret__, 'service_name'),
        size=pulumi.get(__ret__, 'size'),
        ssl_mode=pulumi.get(__ret__, 'ssl_mode'),
        uri=pulumi.get(__ret__, 'uri'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_postgres_sql_connection_pool_output(cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                            name: Optional[pulumi.Input[builtins.str]] = None,
                                            service_name: Optional[pulumi.Input[builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPostgresSqlConnectionPoolResult]:
    """
    Use this data source to get information about a connection pool of a postgresql cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    test_pool = ovh.CloudProjectDatabase.get_postgres_sql_connection_pool(service_name="XXX",
        cluster_id="YYY",
        name="ZZZ")
    pulumi.export("testPool", {
        "serviceName": test_pool.service_name,
        "clusterId": test_pool.cluster_id,
        "name": test_pool.name,
        "databaseId": test_pool.database_id,
        "mode": test_pool.mode,
        "size": test_pool.size,
        "port": test_pool.port,
        "sslMode": test_pool.ssl_mode,
        "uri": test_pool.uri,
        "userId": test_pool.user_id,
    })
    ```


    :param builtins.str cluster_id: Cluster ID.
    :param builtins.str name: Name of the Connection pool.
    :param builtins.str service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:CloudProjectDatabase/getPostgresSqlConnectionPool:getPostgresSqlConnectionPool', __args__, opts=opts, typ=GetPostgresSqlConnectionPoolResult)
    return __ret__.apply(lambda __response__: GetPostgresSqlConnectionPoolResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        database_id=pulumi.get(__response__, 'database_id'),
        id=pulumi.get(__response__, 'id'),
        mode=pulumi.get(__response__, 'mode'),
        name=pulumi.get(__response__, 'name'),
        port=pulumi.get(__response__, 'port'),
        service_name=pulumi.get(__response__, 'service_name'),
        size=pulumi.get(__response__, 'size'),
        ssl_mode=pulumi.get(__response__, 'ssl_mode'),
        uri=pulumi.get(__response__, 'uri'),
        user_id=pulumi.get(__response__, 'user_id')))
