# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OpensearchUserAcl',
    'PrometheusTarget',
    'GetCapabilitiesEngineResult',
    'GetCapabilitiesFlavorResult',
    'GetCapabilitiesOptionResult',
    'GetCapabilitiesPlanResult',
    'GetDatabaseEndpointResult',
    'GetDatabaseIpRestrictionResult',
    'GetDatabaseNodeResult',
]

@pulumi.output_type
class OpensearchUserAcl(dict):
    def __init__(__self__, *,
                 pattern: builtins.str,
                 permission: builtins.str):
        """
        :param builtins.str pattern: Pattern of the ACL.
        :param builtins.str permission: Permission of the ACL Available permission:
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def pattern(self) -> builtins.str:
        """
        Pattern of the ACL.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def permission(self) -> builtins.str:
        """
        Permission of the ACL Available permission:
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class PrometheusTarget(dict):
    def __init__(__self__, *,
                 host: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str host: Host of the endpoint
        :param builtins.int port: Connection port for the endpoint
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        """
        Host of the endpoint
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Connection port for the endpoint
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetCapabilitiesEngineResult(dict):
    def __init__(__self__, *,
                 default_version: builtins.str,
                 description: builtins.str,
                 name: builtins.str,
                 ssl_modes: Sequence[builtins.str],
                 versions: Sequence[builtins.str]):
        """
        :param builtins.str default_version: Default version used for the engine.
        :param builtins.str description: Description of the plan.
        :param builtins.str name: Name of the plan.
        :param Sequence[builtins.str] ssl_modes: SSL modes for this engine.
        :param Sequence[builtins.str] versions: Versions available for this engine.
        """
        pulumi.set(__self__, "default_version", default_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ssl_modes", ssl_modes)
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> builtins.str:
        """
        Default version used for the engine.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the plan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sslModes")
    def ssl_modes(self) -> Sequence[builtins.str]:
        """
        SSL modes for this engine.
        """
        return pulumi.get(self, "ssl_modes")

    @property
    @pulumi.getter
    def versions(self) -> Sequence[builtins.str]:
        """
        Versions available for this engine.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetCapabilitiesFlavorResult(dict):
    def __init__(__self__, *,
                 core: builtins.int,
                 memory: builtins.int,
                 name: builtins.str,
                 storage: builtins.int):
        """
        :param builtins.int core: Flavor core number.
        :param builtins.int memory: Flavor ram size in GB.
        :param builtins.str name: Name of the plan.
        :param builtins.int storage: Flavor disk size in GB.
        """
        pulumi.set(__self__, "core", core)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def core(self) -> builtins.int:
        """
        Flavor core number.
        """
        return pulumi.get(self, "core")

    @property
    @pulumi.getter
    def memory(self) -> builtins.int:
        """
        Flavor ram size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def storage(self) -> builtins.int:
        """
        Flavor disk size in GB.
        """
        return pulumi.get(self, "storage")


@pulumi.output_type
class GetCapabilitiesOptionResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str name: Name of the plan.
        :param builtins.str type: Type of the option.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the option.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCapabilitiesPlanResult(dict):
    def __init__(__self__, *,
                 backup_retention: builtins.str,
                 description: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str backup_retention: Automatic backup retention duration.
        :param builtins.str description: Description of the plan.
        :param builtins.str name: Name of the plan.
        """
        pulumi.set(__self__, "backup_retention", backup_retention)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backupRetention")
    def backup_retention(self) -> builtins.str:
        """
        Automatic backup retention duration.
        """
        return pulumi.get(self, "backup_retention")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the plan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the plan.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatabaseEndpointResult(dict):
    def __init__(__self__, *,
                 component: builtins.str,
                 domain: builtins.str,
                 path: builtins.str,
                 port: builtins.int,
                 scheme: builtins.str,
                 ssl: builtins.bool,
                 ssl_mode: builtins.str,
                 uri: builtins.str):
        """
        :param builtins.str component: Type of component the URI relates to.
        :param builtins.str domain: Domain of the cluster.
        :param builtins.str path: Path of the endpoint.
        :param builtins.int port: Connection port for the endpoint.
        :param builtins.str scheme: Scheme used to generate the URI.
        :param builtins.bool ssl: Defines whether the endpoint uses SSL.
        :param builtins.str ssl_mode: SSL mode used to connect to the service if the SSL is enabled.
        :param builtins.str uri: URI of the endpoint.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "ssl", ssl)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def component(self) -> builtins.str:
        """
        Type of component the URI relates to.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        Domain of the cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path of the endpoint.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Connection port for the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> builtins.str:
        """
        Scheme used to generate the URI.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def ssl(self) -> builtins.bool:
        """
        Defines whether the endpoint uses SSL.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> builtins.str:
        """
        SSL mode used to connect to the service if the SSL is enabled.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        URI of the endpoint.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetDatabaseIpRestrictionResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 ip: builtins.str,
                 status: builtins.str):
        """
        :param builtins.str description: Description of the IP restriction
        :param builtins.str ip: Authorized IP
        :param builtins.str status: Current status of the cluster.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the IP restriction
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        Authorized IP
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Current status of the cluster.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDatabaseNodeResult(dict):
    def __init__(__self__, *,
                 network_id: builtins.str,
                 region: builtins.str,
                 subnet_id: builtins.str):
        """
        :param builtins.str network_id: Private network id in which the node should be deployed. It's the regional openstackId of the private network
        :param builtins.str region: Public cloud region in which the node should be deployed.
        :param builtins.str subnet_id: Private subnet ID in which the node is.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        Private network id in which the node should be deployed. It's the regional openstackId of the private network
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Public cloud region in which the node should be deployed.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Private subnet ID in which the node is.
        """
        return pulumi.get(self, "subnet_id")


