# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLogsOutputOpenSearchIndexResult',
    'AwaitableGetLogsOutputOpenSearchIndexResult',
    'get_logs_output_open_search_index',
    'get_logs_output_open_search_index_output',
]

@pulumi.output_type
class GetLogsOutputOpenSearchIndexResult:
    """
    A collection of values returned by getLogsOutputOpenSearchIndex.
    """
    def __init__(__self__, alert_notify_enabled=None, created_at=None, current_size=None, description=None, id=None, index_id=None, is_editable=None, max_size=None, name=None, nb_shard=None, service_name=None, updated_at=None):
        if alert_notify_enabled and not isinstance(alert_notify_enabled, bool):
            raise TypeError("Expected argument 'alert_notify_enabled' to be a bool")
        pulumi.set(__self__, "alert_notify_enabled", alert_notify_enabled)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if current_size and not isinstance(current_size, int):
            raise TypeError("Expected argument 'current_size' to be a int")
        pulumi.set(__self__, "current_size", current_size)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if index_id and not isinstance(index_id, str):
            raise TypeError("Expected argument 'index_id' to be a str")
        pulumi.set(__self__, "index_id", index_id)
        if is_editable and not isinstance(is_editable, bool):
            raise TypeError("Expected argument 'is_editable' to be a bool")
        pulumi.set(__self__, "is_editable", is_editable)
        if max_size and not isinstance(max_size, int):
            raise TypeError("Expected argument 'max_size' to be a int")
        pulumi.set(__self__, "max_size", max_size)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nb_shard and not isinstance(nb_shard, int):
            raise TypeError("Expected argument 'nb_shard' to be a int")
        pulumi.set(__self__, "nb_shard", nb_shard)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="alertNotifyEnabled")
    def alert_notify_enabled(self) -> builtins.bool:
        """
        If set, notify when size is near 80, 90 or 100 % of its maximum capacity
        """
        return pulumi.get(self, "alert_notify_enabled")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        Index creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="currentSize")
    def current_size(self) -> builtins.int:
        """
        Current index size (in bytes)
        """
        return pulumi.get(self, "current_size")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Index description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> builtins.str:
        """
        Index ID
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="isEditable")
    def is_editable(self) -> builtins.bool:
        """
        Indicates if you are allowed to edit entry
        """
        return pulumi.get(self, "is_editable")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.int:
        """
        Maximum index size (in bytes)
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Index name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nbShard")
    def nb_shard(self) -> builtins.int:
        """
        Number of shard
        """
        return pulumi.get(self, "nb_shard")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        Index last update
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetLogsOutputOpenSearchIndexResult(GetLogsOutputOpenSearchIndexResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogsOutputOpenSearchIndexResult(
            alert_notify_enabled=self.alert_notify_enabled,
            created_at=self.created_at,
            current_size=self.current_size,
            description=self.description,
            id=self.id,
            index_id=self.index_id,
            is_editable=self.is_editable,
            max_size=self.max_size,
            name=self.name,
            nb_shard=self.nb_shard,
            service_name=self.service_name,
            updated_at=self.updated_at)


def get_logs_output_open_search_index(name: Optional[builtins.str] = None,
                                      nb_shard: Optional[builtins.int] = None,
                                      service_name: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogsOutputOpenSearchIndexResult:
    """
    Use this data source to retrieve information about a DBaas logs output opensearch index.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    index = ovh.Dbaas.get_logs_output_open_search_index(service_name="ldp-xx-xxxxx",
        name="index-name")
    ```


    :param builtins.str name: Index name
    :param builtins.int nb_shard: Number of shard
    :param builtins.str service_name: The service name. It's the ID of your Logs Data Platform instance.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['nbShard'] = nb_shard
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Dbaas/getLogsOutputOpenSearchIndex:getLogsOutputOpenSearchIndex', __args__, opts=opts, typ=GetLogsOutputOpenSearchIndexResult).value

    return AwaitableGetLogsOutputOpenSearchIndexResult(
        alert_notify_enabled=pulumi.get(__ret__, 'alert_notify_enabled'),
        created_at=pulumi.get(__ret__, 'created_at'),
        current_size=pulumi.get(__ret__, 'current_size'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        index_id=pulumi.get(__ret__, 'index_id'),
        is_editable=pulumi.get(__ret__, 'is_editable'),
        max_size=pulumi.get(__ret__, 'max_size'),
        name=pulumi.get(__ret__, 'name'),
        nb_shard=pulumi.get(__ret__, 'nb_shard'),
        service_name=pulumi.get(__ret__, 'service_name'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_logs_output_open_search_index_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                             nb_shard: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                             service_name: Optional[pulumi.Input[builtins.str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogsOutputOpenSearchIndexResult]:
    """
    Use this data source to retrieve information about a DBaas logs output opensearch index.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    index = ovh.Dbaas.get_logs_output_open_search_index(service_name="ldp-xx-xxxxx",
        name="index-name")
    ```


    :param builtins.str name: Index name
    :param builtins.int nb_shard: Number of shard
    :param builtins.str service_name: The service name. It's the ID of your Logs Data Platform instance.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['nbShard'] = nb_shard
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Dbaas/getLogsOutputOpenSearchIndex:getLogsOutputOpenSearchIndex', __args__, opts=opts, typ=GetLogsOutputOpenSearchIndexResult)
    return __ret__.apply(lambda __response__: GetLogsOutputOpenSearchIndexResult(
        alert_notify_enabled=pulumi.get(__response__, 'alert_notify_enabled'),
        created_at=pulumi.get(__response__, 'created_at'),
        current_size=pulumi.get(__response__, 'current_size'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        index_id=pulumi.get(__response__, 'index_id'),
        is_editable=pulumi.get(__response__, 'is_editable'),
        max_size=pulumi.get(__response__, 'max_size'),
        name=pulumi.get(__response__, 'name'),
        nb_shard=pulumi.get(__response__, 'nb_shard'),
        service_name=pulumi.get(__response__, 'service_name'),
        updated_at=pulumi.get(__response__, 'updated_at')))
