# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogsRolePermissionStreamArgs', 'LogsRolePermissionStream']

@pulumi.input_type
class LogsRolePermissionStreamArgs:
    def __init__(__self__, *,
                 role_id: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 stream_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a LogsRolePermissionStream resource.
        :param pulumi.Input[builtins.str] role_id: The DBaaS Logs role id
        :param pulumi.Input[builtins.str] service_name: The service name
        :param pulumi.Input[builtins.str] stream_id: The DBaaS Logs Graylog output stream id
        """
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "stream_id", stream_id)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[builtins.str]:
        """
        The DBaaS Logs role id
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        The service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Input[builtins.str]:
        """
        The DBaaS Logs Graylog output stream id
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stream_id", value)


@pulumi.input_type
class _LogsRolePermissionStreamState:
    def __init__(__self__, *,
                 permission_id: Optional[pulumi.Input[builtins.str]] = None,
                 permission_type: Optional[pulumi.Input[builtins.str]] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogsRolePermissionStream resources.
        :param pulumi.Input[builtins.str] permission_id: Permission ID
        :param pulumi.Input[builtins.str] permission_type: Permission type (e.g., READ_ONLY)
        :param pulumi.Input[builtins.str] role_id: The DBaaS Logs role id
        :param pulumi.Input[builtins.str] service_name: The service name
        :param pulumi.Input[builtins.str] stream_id: The DBaaS Logs Graylog output stream id
        """
        if permission_id is not None:
            pulumi.set(__self__, "permission_id", permission_id)
        if permission_type is not None:
            pulumi.set(__self__, "permission_type", permission_type)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)

    @property
    @pulumi.getter(name="permissionId")
    def permission_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Permission ID
        """
        return pulumi.get(self, "permission_id")

    @permission_id.setter
    def permission_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "permission_id", value)

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Permission type (e.g., READ_ONLY)
        """
        return pulumi.get(self, "permission_type")

    @permission_type.setter
    def permission_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "permission_type", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DBaaS Logs role id
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DBaaS Logs Graylog output stream id
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stream_id", value)


@pulumi.type_token("ovh:Dbaas/logsRolePermissionStream:LogsRolePermissionStream")
class LogsRolePermissionStream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Reference a DBaaS logs role stream permission.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        permission = ovh.dbaas.LogsRolePermissionStream("permission",
            service_name="ldp-xx-xxxxx",
            role_id=ro["id"],
            stream_id=mystream["streamId"])
        ```

        ## Import

        DBaaS logs role stream permission can be imported using the `service_name`, `role_id` and `id` of the permission, separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:Dbaas/logsRolePermissionStream:LogsRolePermissionStream  ovh_dbaas_logs_role_permission_stream.perm ldp-ra-XX/dc145bc2-eb01-4efe-a802-XXXXXX/e4818fa8-f426-11ef-a1f6-XXXXXXX
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] role_id: The DBaaS Logs role id
        :param pulumi.Input[builtins.str] service_name: The service name
        :param pulumi.Input[builtins.str] stream_id: The DBaaS Logs Graylog output stream id
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsRolePermissionStreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Reference a DBaaS logs role stream permission.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        permission = ovh.dbaas.LogsRolePermissionStream("permission",
            service_name="ldp-xx-xxxxx",
            role_id=ro["id"],
            stream_id=mystream["streamId"])
        ```

        ## Import

        DBaaS logs role stream permission can be imported using the `service_name`, `role_id` and `id` of the permission, separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:Dbaas/logsRolePermissionStream:LogsRolePermissionStream  ovh_dbaas_logs_role_permission_stream.perm ldp-ra-XX/dc145bc2-eb01-4efe-a802-XXXXXX/e4818fa8-f426-11ef-a1f6-XXXXXXX
        ```

        :param str resource_name: The name of the resource.
        :param LogsRolePermissionStreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsRolePermissionStreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsRolePermissionStreamArgs.__new__(LogsRolePermissionStreamArgs)

            if role_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_id'")
            __props__.__dict__["role_id"] = role_id
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if stream_id is None and not opts.urn:
                raise TypeError("Missing required property 'stream_id'")
            __props__.__dict__["stream_id"] = stream_id
            __props__.__dict__["permission_id"] = None
            __props__.__dict__["permission_type"] = None
        super(LogsRolePermissionStream, __self__).__init__(
            'ovh:Dbaas/logsRolePermissionStream:LogsRolePermissionStream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            permission_id: Optional[pulumi.Input[builtins.str]] = None,
            permission_type: Optional[pulumi.Input[builtins.str]] = None,
            role_id: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            stream_id: Optional[pulumi.Input[builtins.str]] = None) -> 'LogsRolePermissionStream':
        """
        Get an existing LogsRolePermissionStream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] permission_id: Permission ID
        :param pulumi.Input[builtins.str] permission_type: Permission type (e.g., READ_ONLY)
        :param pulumi.Input[builtins.str] role_id: The DBaaS Logs role id
        :param pulumi.Input[builtins.str] service_name: The service name
        :param pulumi.Input[builtins.str] stream_id: The DBaaS Logs Graylog output stream id
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsRolePermissionStreamState.__new__(_LogsRolePermissionStreamState)

        __props__.__dict__["permission_id"] = permission_id
        __props__.__dict__["permission_type"] = permission_type
        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["stream_id"] = stream_id
        return LogsRolePermissionStream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="permissionId")
    def permission_id(self) -> pulumi.Output[builtins.str]:
        """
        Permission ID
        """
        return pulumi.get(self, "permission_id")

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> pulumi.Output[builtins.str]:
        """
        Permission type (e.g., READ_ONLY)
        """
        return pulumi.get(self, "permission_type")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[builtins.str]:
        """
        The DBaaS Logs role id
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Output[builtins.str]:
        """
        The DBaaS Logs Graylog output stream id
        """
        return pulumi.get(self, "stream_id")

