# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ServerCustomizations',
    'ServerIam',
    'ServerNetworkingInterface',
    'ServerOrder',
    'ServerOrderDetail',
    'ServerPlan',
    'ServerPlanConfiguration',
    'ServerPlanOption',
    'ServerPlanOptionConfiguration',
    'ServerReinstallTaskCustomizations',
    'ServerReinstallTaskStorage',
    'ServerReinstallTaskStorageHardwareRaid',
    'ServerReinstallTaskStoragePartitioning',
    'ServerReinstallTaskStoragePartitioningLayout',
    'ServerReinstallTaskStoragePartitioningLayoutExtra',
    'ServerReinstallTaskStoragePartitioningLayoutExtraLv',
    'ServerReinstallTaskStoragePartitioningLayoutExtraZp',
    'ServerStorage',
    'ServerStorageHardwareRaid',
    'ServerStoragePartitioning',
    'ServerStoragePartitioningLayout',
    'ServerStoragePartitioningLayoutExtras',
    'ServerStoragePartitioningLayoutExtrasLv',
    'ServerStoragePartitioningLayoutExtrasZp',
    'GetCloudIamResult',
    'GetCloudVersionResult',
    'GetServerSpecificationsHardwareDefaultHardwareRaidSizeResult',
    'GetServerSpecificationsHardwareDiskGroupResult',
    'GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeResult',
    'GetServerSpecificationsHardwareDiskGroupDiskSizeResult',
    'GetServerSpecificationsHardwareExpansionCardResult',
    'GetServerSpecificationsHardwareMemorySizeResult',
    'GetServerSpecificationsHardwareUsbKeyResult',
    'GetServerSpecificationsNetworkBandwidthResult',
    'GetServerSpecificationsNetworkBandwidthInternetToOvhResult',
    'GetServerSpecificationsNetworkBandwidthOvhToInternetResult',
    'GetServerSpecificationsNetworkBandwidthOvhToOvhResult',
    'GetServerSpecificationsNetworkConnectionValResult',
    'GetServerSpecificationsNetworkOlaResult',
    'GetServerSpecificationsNetworkOlaAvailableModeResult',
    'GetServerSpecificationsNetworkOlaAvailableModeInterfaceResult',
    'GetServerSpecificationsNetworkRoutingResult',
    'GetServerSpecificationsNetworkRoutingIpv4Result',
    'GetServerSpecificationsNetworkRoutingIpv6Result',
    'GetServerSpecificationsNetworkSwitchingResult',
    'GetServerSpecificationsNetworkTrafficResult',
    'GetServerSpecificationsNetworkTrafficInputQuotaSizeResult',
    'GetServerSpecificationsNetworkTrafficInputQuotaUsedResult',
    'GetServerSpecificationsNetworkTrafficOutputQuotaSizeResult',
    'GetServerSpecificationsNetworkTrafficOutputQuotaUsedResult',
    'GetServerSpecificationsNetworkVmacResult',
    'GetServerSpecificationsNetworkVrackResult',
    'GetServerSpecificationsNetworkVrackBandwidthResult',
]

@pulumi.output_type
class ServerCustomizations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configDriveUserData":
            suggest = "config_drive_user_data"
        elif key == "efiBootloaderPath":
            suggest = "efi_bootloader_path"
        elif key == "httpHeaders":
            suggest = "http_headers"
        elif key == "imageCheckSum":
            suggest = "image_check_sum"
        elif key == "imageCheckSumType":
            suggest = "image_check_sum_type"
        elif key == "imageType":
            suggest = "image_type"
        elif key == "imageUrl":
            suggest = "image_url"
        elif key == "postInstallationScript":
            suggest = "post_installation_script"
        elif key == "postInstallationScriptExtension":
            suggest = "post_installation_script_extension"
        elif key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_drive_user_data: Optional[builtins.str] = None,
                 efi_bootloader_path: Optional[builtins.str] = None,
                 hostname: Optional[builtins.str] = None,
                 http_headers: Optional[Mapping[str, builtins.str]] = None,
                 image_check_sum: Optional[builtins.str] = None,
                 image_check_sum_type: Optional[builtins.str] = None,
                 image_type: Optional[builtins.str] = None,
                 image_url: Optional[builtins.str] = None,
                 language: Optional[builtins.str] = None,
                 post_installation_script: Optional[builtins.str] = None,
                 post_installation_script_extension: Optional[builtins.str] = None,
                 ssh_key: Optional[builtins.str] = None):
        """
        :param builtins.str config_drive_user_data: Config Drive UserData
        :param builtins.str efi_bootloader_path: Path of the EFI bootloader
        :param builtins.str hostname: Custom hostname
        :param Mapping[str, builtins.str] http_headers: Image HTTP Headers
        :param builtins.str image_check_sum: Image checksum
        :param builtins.str image_check_sum_type: Checksum type
        :param builtins.str image_type: Image Type
        :param builtins.str image_url: Image URL
        :param builtins.str language: Display Language
        :param builtins.str post_installation_script: Post-Installation Script
        :param builtins.str post_installation_script_extension: Post-Installation Script File Extension
        :param builtins.str ssh_key: SSH Public Key
        """
        if config_drive_user_data is not None:
            pulumi.set(__self__, "config_drive_user_data", config_drive_user_data)
        if efi_bootloader_path is not None:
            pulumi.set(__self__, "efi_bootloader_path", efi_bootloader_path)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if image_check_sum is not None:
            pulumi.set(__self__, "image_check_sum", image_check_sum)
        if image_check_sum_type is not None:
            pulumi.set(__self__, "image_check_sum_type", image_check_sum_type)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if post_installation_script is not None:
            pulumi.set(__self__, "post_installation_script", post_installation_script)
        if post_installation_script_extension is not None:
            pulumi.set(__self__, "post_installation_script_extension", post_installation_script_extension)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)

    @property
    @pulumi.getter(name="configDriveUserData")
    def config_drive_user_data(self) -> Optional[builtins.str]:
        """
        Config Drive UserData
        """
        return pulumi.get(self, "config_drive_user_data")

    @property
    @pulumi.getter(name="efiBootloaderPath")
    def efi_bootloader_path(self) -> Optional[builtins.str]:
        """
        Path of the EFI bootloader
        """
        return pulumi.get(self, "efi_bootloader_path")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        Custom hostname
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Image HTTP Headers
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter(name="imageCheckSum")
    def image_check_sum(self) -> Optional[builtins.str]:
        """
        Image checksum
        """
        return pulumi.get(self, "image_check_sum")

    @property
    @pulumi.getter(name="imageCheckSumType")
    def image_check_sum_type(self) -> Optional[builtins.str]:
        """
        Checksum type
        """
        return pulumi.get(self, "image_check_sum_type")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[builtins.str]:
        """
        Image Type
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[builtins.str]:
        """
        Image URL
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def language(self) -> Optional[builtins.str]:
        """
        Display Language
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="postInstallationScript")
    def post_installation_script(self) -> Optional[builtins.str]:
        """
        Post-Installation Script
        """
        return pulumi.get(self, "post_installation_script")

    @property
    @pulumi.getter(name="postInstallationScriptExtension")
    def post_installation_script_extension(self) -> Optional[builtins.str]:
        """
        Post-Installation Script File Extension
        """
        return pulumi.get(self, "post_installation_script_extension")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[builtins.str]:
        """
        SSH Public Key
        """
        return pulumi.get(self, "ssh_key")


@pulumi.output_type
class ServerIam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerIam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerIam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerIam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 urn: Optional[builtins.str] = None):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: Unique identifier of the resource in the IAM
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with `ovh:`
        :param builtins.str urn: URN of the private database, used when writing IAM policies
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the resource in the IAM
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Resource tags. Tags that were internally computed are prefixed with `ovh:`
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> Optional[builtins.str]:
        """
        URN of the private database, used when writing IAM policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class ServerNetworkingInterface(dict):
    def __init__(__self__, *,
                 macs: Sequence[builtins.str],
                 type: builtins.str):
        """
        :param Sequence[builtins.str] macs: Interface Mac address
        :param builtins.str type: Interface type
        """
        pulumi.set(__self__, "macs", macs)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def macs(self) -> Sequence[builtins.str]:
        """
        Interface Mac address
        """
        return pulumi.get(self, "macs")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Interface type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[builtins.str] = None,
                 details: Optional[Sequence['outputs.ServerOrderDetail']] = None,
                 expiration_date: Optional[builtins.str] = None,
                 order_id: Optional[builtins.float] = None):
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[builtins.str]:
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ServerOrderDetail']]:
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[builtins.str]:
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[builtins.float]:
        return pulumi.get(self, "order_id")


@pulumi.output_type
class ServerOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailType":
            suggest = "detail_type"
        elif key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 detail_type: Optional[builtins.str] = None,
                 domain: Optional[builtins.str] = None,
                 order_detail_id: Optional[builtins.float] = None,
                 quantity: Optional[builtins.str] = None):
        """
        :param builtins.str detail_type: Product type of item in order
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detail_type is not None:
            pulumi.set(__self__, "detail_type", detail_type)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> Optional[builtins.str]:
        """
        Product type of item in order
        """
        return pulumi.get(self, "detail_type")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[builtins.float]:
        return pulumi.get(self, "order_detail_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[builtins.str]:
        return pulumi.get(self, "quantity")


@pulumi.output_type
class ServerPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "itemId":
            suggest = "item_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: builtins.str,
                 plan_code: builtins.str,
                 pricing_mode: builtins.str,
                 configurations: Optional[Sequence['outputs.ServerPlanConfiguration']] = None,
                 item_id: Optional[builtins.float] = None,
                 quantity: Optional[builtins.float] = None):
        """
        :param builtins.str duration: Duration selected for the purchase of the product
        :param builtins.str plan_code: Identifier of the option offer
        :param builtins.str pricing_mode: Pricing mode selected for the purchase of the product
        :param builtins.float item_id: Cart item to be linked
        :param builtins.float quantity: Quantity of product desired
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if item_id is not None:
            pulumi.set(__self__, "item_id", item_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Duration selected for the purchase of the product
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> builtins.str:
        """
        Identifier of the option offer
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> builtins.str:
        """
        Pricing mode selected for the purchase of the product
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ServerPlanConfiguration']]:
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="itemId")
    def item_id(self) -> Optional[builtins.float]:
        """
        Cart item to be linked
        """
        return pulumi.get(self, "item_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[builtins.float]:
        """
        Quantity of product desired
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class ServerPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str label: Label for your configuration item
        :param builtins.str value: Value or resource URL on API.OVH.COM of your configuration item
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Label for your configuration item
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value or resource URL on API.OVH.COM of your configuration item
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServerPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: builtins.str,
                 plan_code: builtins.str,
                 pricing_mode: builtins.str,
                 quantity: builtins.float,
                 configurations: Optional[Sequence['outputs.ServerPlanOptionConfiguration']] = None):
        """
        :param builtins.str duration: Duration selected for the purchase of the product
        :param builtins.str plan_code: Identifier of the option offer
        :param builtins.str pricing_mode: Pricing mode selected for the purchase of the product
        :param builtins.float quantity: Quantity of product desired
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        pulumi.set(__self__, "quantity", quantity)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Duration selected for the purchase of the product
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> builtins.str:
        """
        Identifier of the option offer
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> builtins.str:
        """
        Pricing mode selected for the purchase of the product
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.float:
        """
        Quantity of product desired
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.ServerPlanOptionConfiguration']]:
        return pulumi.get(self, "configurations")


@pulumi.output_type
class ServerPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str label: Label for your configuration item
        :param builtins.str value: Value or resource URL on API.OVH.COM of your configuration item
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Label for your configuration item
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value or resource URL on API.OVH.COM of your configuration item
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServerReinstallTaskCustomizations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configDriveUserData":
            suggest = "config_drive_user_data"
        elif key == "efiBootloaderPath":
            suggest = "efi_bootloader_path"
        elif key == "httpHeaders":
            suggest = "http_headers"
        elif key == "imageCheckSum":
            suggest = "image_check_sum"
        elif key == "imageCheckSumType":
            suggest = "image_check_sum_type"
        elif key == "imageType":
            suggest = "image_type"
        elif key == "imageUrl":
            suggest = "image_url"
        elif key == "postInstallationScript":
            suggest = "post_installation_script"
        elif key == "postInstallationScriptExtension":
            suggest = "post_installation_script_extension"
        elif key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskCustomizations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskCustomizations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskCustomizations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_drive_user_data: Optional[builtins.str] = None,
                 efi_bootloader_path: Optional[builtins.str] = None,
                 hostname: Optional[builtins.str] = None,
                 http_headers: Optional[Mapping[str, builtins.str]] = None,
                 image_check_sum: Optional[builtins.str] = None,
                 image_check_sum_type: Optional[builtins.str] = None,
                 image_type: Optional[builtins.str] = None,
                 image_url: Optional[builtins.str] = None,
                 language: Optional[builtins.str] = None,
                 post_installation_script: Optional[builtins.str] = None,
                 post_installation_script_extension: Optional[builtins.str] = None,
                 ssh_key: Optional[builtins.str] = None):
        """
        :param builtins.str config_drive_user_data: Config Drive UserData
        :param builtins.str efi_bootloader_path: EFI bootloader path
        :param builtins.str hostname: Custom hostname
        :param Mapping[str, builtins.str] http_headers: Image HTTP Headers
        :param builtins.str image_check_sum: Image checksum
        :param builtins.str image_check_sum_type: Checksum type
        :param builtins.str image_type: Image Type
        :param builtins.str image_url: Image URL
        :param builtins.str language: Display Language
        :param builtins.str post_installation_script: Post-Installation Script
        :param builtins.str post_installation_script_extension: Post-Installation Script File Extension
        :param builtins.str ssh_key: SSH Public Key
        """
        if config_drive_user_data is not None:
            pulumi.set(__self__, "config_drive_user_data", config_drive_user_data)
        if efi_bootloader_path is not None:
            pulumi.set(__self__, "efi_bootloader_path", efi_bootloader_path)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if image_check_sum is not None:
            pulumi.set(__self__, "image_check_sum", image_check_sum)
        if image_check_sum_type is not None:
            pulumi.set(__self__, "image_check_sum_type", image_check_sum_type)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if post_installation_script is not None:
            pulumi.set(__self__, "post_installation_script", post_installation_script)
        if post_installation_script_extension is not None:
            pulumi.set(__self__, "post_installation_script_extension", post_installation_script_extension)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)

    @property
    @pulumi.getter(name="configDriveUserData")
    def config_drive_user_data(self) -> Optional[builtins.str]:
        """
        Config Drive UserData
        """
        return pulumi.get(self, "config_drive_user_data")

    @property
    @pulumi.getter(name="efiBootloaderPath")
    def efi_bootloader_path(self) -> Optional[builtins.str]:
        """
        EFI bootloader path
        """
        return pulumi.get(self, "efi_bootloader_path")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        Custom hostname
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Image HTTP Headers
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter(name="imageCheckSum")
    def image_check_sum(self) -> Optional[builtins.str]:
        """
        Image checksum
        """
        return pulumi.get(self, "image_check_sum")

    @property
    @pulumi.getter(name="imageCheckSumType")
    def image_check_sum_type(self) -> Optional[builtins.str]:
        """
        Checksum type
        """
        return pulumi.get(self, "image_check_sum_type")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[builtins.str]:
        """
        Image Type
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[builtins.str]:
        """
        Image URL
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def language(self) -> Optional[builtins.str]:
        """
        Display Language
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="postInstallationScript")
    def post_installation_script(self) -> Optional[builtins.str]:
        """
        Post-Installation Script
        """
        return pulumi.get(self, "post_installation_script")

    @property
    @pulumi.getter(name="postInstallationScriptExtension")
    def post_installation_script_extension(self) -> Optional[builtins.str]:
        """
        Post-Installation Script File Extension
        """
        return pulumi.get(self, "post_installation_script_extension")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[builtins.str]:
        """
        SSH Public Key
        """
        return pulumi.get(self, "ssh_key")


@pulumi.output_type
class ServerReinstallTaskStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskGroupId":
            suggest = "disk_group_id"
        elif key == "hardwareRaids":
            suggest = "hardware_raids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_group_id: Optional[builtins.int] = None,
                 hardware_raids: Optional[Sequence['outputs.ServerReinstallTaskStorageHardwareRaid']] = None,
                 partitionings: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioning']] = None):
        """
        :param builtins.int disk_group_id: Disk group id to install the OS to (default is 0, meaning automatic).
        :param Sequence['ServerReinstallTaskStorageHardwareRaidArgs'] hardware_raids: Hardware Raid configurations (if not specified, all disks of the chosen disk group id will be configured in JBOD mode).
        :param Sequence['ServerReinstallTaskStoragePartitioningArgs'] partitionings: Partitioning configuration
        """
        if disk_group_id is not None:
            pulumi.set(__self__, "disk_group_id", disk_group_id)
        if hardware_raids is not None:
            pulumi.set(__self__, "hardware_raids", hardware_raids)
        if partitionings is not None:
            pulumi.set(__self__, "partitionings", partitionings)

    @property
    @pulumi.getter(name="diskGroupId")
    def disk_group_id(self) -> Optional[builtins.int]:
        """
        Disk group id to install the OS to (default is 0, meaning automatic).
        """
        return pulumi.get(self, "disk_group_id")

    @property
    @pulumi.getter(name="hardwareRaids")
    def hardware_raids(self) -> Optional[Sequence['outputs.ServerReinstallTaskStorageHardwareRaid']]:
        """
        Hardware Raid configurations (if not specified, all disks of the chosen disk group id will be configured in JBOD mode).
        """
        return pulumi.get(self, "hardware_raids")

    @property
    @pulumi.getter
    def partitionings(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioning']]:
        """
        Partitioning configuration
        """
        return pulumi.get(self, "partitionings")


@pulumi.output_type
class ServerReinstallTaskStorageHardwareRaid(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskStorageHardwareRaid. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskStorageHardwareRaid.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskStorageHardwareRaid.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arrays: Optional[builtins.int] = None,
                 disks: Optional[builtins.int] = None,
                 raid_level: Optional[builtins.int] = None,
                 spares: Optional[builtins.int] = None):
        """
        :param builtins.int arrays: Number of arrays (default is 1)
        :param builtins.int disks: Total number of disks in the disk group involved in the hardware raid configuration (all disks of the disk group by default)
        :param builtins.int raid_level: Hardware raid type (default is 1)
        :param builtins.int spares: Number of disks in the disk group involved in the spare (default is 0)
        """
        if arrays is not None:
            pulumi.set(__self__, "arrays", arrays)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if spares is not None:
            pulumi.set(__self__, "spares", spares)

    @property
    @pulumi.getter
    def arrays(self) -> Optional[builtins.int]:
        """
        Number of arrays (default is 1)
        """
        return pulumi.get(self, "arrays")

    @property
    @pulumi.getter
    def disks(self) -> Optional[builtins.int]:
        """
        Total number of disks in the disk group involved in the hardware raid configuration (all disks of the disk group by default)
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[builtins.int]:
        """
        Hardware raid type (default is 1)
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def spares(self) -> Optional[builtins.int]:
        """
        Number of disks in the disk group involved in the spare (default is 0)
        """
        return pulumi.get(self, "spares")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemeName":
            suggest = "scheme_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskStoragePartitioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskStoragePartitioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskStoragePartitioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disks: Optional[builtins.int] = None,
                 layouts: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayout']] = None,
                 scheme_name: Optional[builtins.str] = None):
        """
        :param builtins.int disks: Total number of disks in the disk group involved in the partitioning configuration (all disks of the disk group by default)
        :param Sequence['ServerReinstallTaskStoragePartitioningLayoutArgs'] layouts: Custom partitioning layout (default is the default layout of the operating system's default partitioning scheme). Accept multiple values (multiple partitions):
        :param builtins.str scheme_name: Partitioning scheme (if applicable with selected operating system)
        """
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if layouts is not None:
            pulumi.set(__self__, "layouts", layouts)
        if scheme_name is not None:
            pulumi.set(__self__, "scheme_name", scheme_name)

    @property
    @pulumi.getter
    def disks(self) -> Optional[builtins.int]:
        """
        Total number of disks in the disk group involved in the partitioning configuration (all disks of the disk group by default)
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def layouts(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayout']]:
        """
        Custom partitioning layout (default is the default layout of the operating system's default partitioning scheme). Accept multiple values (multiple partitions):
        """
        return pulumi.get(self, "layouts")

    @property
    @pulumi.getter(name="schemeName")
    def scheme_name(self) -> Optional[builtins.str]:
        """
        Partitioning scheme (if applicable with selected operating system)
        """
        return pulumi.get(self, "scheme_name")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioningLayout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystem":
            suggest = "file_system"
        elif key == "mountPoint":
            suggest = "mount_point"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerReinstallTaskStoragePartitioningLayout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerReinstallTaskStoragePartitioningLayout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerReinstallTaskStoragePartitioningLayout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system: builtins.str,
                 mount_point: builtins.str,
                 extras: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtra']] = None,
                 raid_level: Optional[builtins.int] = None,
                 size: Optional[builtins.int] = None):
        """
        :param builtins.str file_system: File system type
        :param builtins.str mount_point: Mount point
        :param Sequence['ServerReinstallTaskStoragePartitioningLayoutExtraArgs'] extras: Partition extras parameters (when applicable)
        :param builtins.int raid_level: Software raid type (default is 1)
        :param builtins.int size: Partition size in MiB (default value is 0 which means to fill the disk with that partition)
        """
        pulumi.set(__self__, "file_system", file_system)
        pulumi.set(__self__, "mount_point", mount_point)
        if extras is not None:
            pulumi.set(__self__, "extras", extras)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> builtins.str:
        """
        File system type
        """
        return pulumi.get(self, "file_system")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> builtins.str:
        """
        Mount point
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter
    def extras(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtra']]:
        """
        Partition extras parameters (when applicable)
        """
        return pulumi.get(self, "extras")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[builtins.int]:
        """
        Software raid type (default is 1)
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.int]:
        """
        Partition size in MiB (default value is 0 which means to fill the disk with that partition)
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioningLayoutExtra(dict):
    def __init__(__self__, *,
                 lvs: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtraLv']] = None,
                 zps: Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtraZp']] = None):
        """
        :param Sequence['ServerReinstallTaskStoragePartitioningLayoutExtraLvArgs'] lvs: LVM-specific parameters (when applicable)
        :param Sequence['ServerReinstallTaskStoragePartitioningLayoutExtraZpArgs'] zps: ZFS-specific parameters (when applicable)
        """
        if lvs is not None:
            pulumi.set(__self__, "lvs", lvs)
        if zps is not None:
            pulumi.set(__self__, "zps", zps)

    @property
    @pulumi.getter
    def lvs(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtraLv']]:
        """
        LVM-specific parameters (when applicable)
        """
        return pulumi.get(self, "lvs")

    @property
    @pulumi.getter
    def zps(self) -> Optional[Sequence['outputs.ServerReinstallTaskStoragePartitioningLayoutExtraZp']]:
        """
        ZFS-specific parameters (when applicable)
        """
        return pulumi.get(self, "zps")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioningLayoutExtraLv(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: Logical volume name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Logical volume name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerReinstallTaskStoragePartitioningLayoutExtraZp(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: zpool name (generated automatically if not specified, note that multiple ZFS partitions with same zpool names will be configured as multiple datasets belonging to the same zpool if compatible)
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        zpool name (generated automatically if not specified, note that multiple ZFS partitions with same zpool names will be configured as multiple datasets belonging to the same zpool if compatible)
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskGroupId":
            suggest = "disk_group_id"
        elif key == "hardwareRaids":
            suggest = "hardware_raids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_group_id: Optional[builtins.float] = None,
                 hardware_raids: Optional[Sequence['outputs.ServerStorageHardwareRaid']] = None,
                 partitioning: Optional['outputs.ServerStoragePartitioning'] = None):
        """
        :param builtins.float disk_group_id: Disk group id (default is 0, meaning automatic)
        :param Sequence['ServerStorageHardwareRaidArgs'] hardware_raids: Hardware Raid configurations (if not specified, all disks of the chosen disk group id will be configured in JBOD mode)
        :param 'ServerStoragePartitioningArgs' partitioning: Partitioning configuration
        """
        if disk_group_id is not None:
            pulumi.set(__self__, "disk_group_id", disk_group_id)
        if hardware_raids is not None:
            pulumi.set(__self__, "hardware_raids", hardware_raids)
        if partitioning is not None:
            pulumi.set(__self__, "partitioning", partitioning)

    @property
    @pulumi.getter(name="diskGroupId")
    def disk_group_id(self) -> Optional[builtins.float]:
        """
        Disk group id (default is 0, meaning automatic)
        """
        return pulumi.get(self, "disk_group_id")

    @property
    @pulumi.getter(name="hardwareRaids")
    def hardware_raids(self) -> Optional[Sequence['outputs.ServerStorageHardwareRaid']]:
        """
        Hardware Raid configurations (if not specified, all disks of the chosen disk group id will be configured in JBOD mode)
        """
        return pulumi.get(self, "hardware_raids")

    @property
    @pulumi.getter
    def partitioning(self) -> Optional['outputs.ServerStoragePartitioning']:
        """
        Partitioning configuration
        """
        return pulumi.get(self, "partitioning")


@pulumi.output_type
class ServerStorageHardwareRaid(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStorageHardwareRaid. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStorageHardwareRaid.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStorageHardwareRaid.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arrays: Optional[builtins.float] = None,
                 disks: Optional[builtins.float] = None,
                 raid_level: Optional[builtins.float] = None,
                 spares: Optional[builtins.float] = None):
        """
        :param builtins.float arrays: Number of arrays (default is 1)
        :param builtins.float disks: Total number of disks in the disk group involved in the hardware raid configuration (all disks of the disk group by default)
        :param builtins.float raid_level: Hardware raid type (default is 1)
        :param builtins.float spares: Number of disks in the disk group involved in the spare (default is 0)
        """
        if arrays is not None:
            pulumi.set(__self__, "arrays", arrays)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if spares is not None:
            pulumi.set(__self__, "spares", spares)

    @property
    @pulumi.getter
    def arrays(self) -> Optional[builtins.float]:
        """
        Number of arrays (default is 1)
        """
        return pulumi.get(self, "arrays")

    @property
    @pulumi.getter
    def disks(self) -> Optional[builtins.float]:
        """
        Total number of disks in the disk group involved in the hardware raid configuration (all disks of the disk group by default)
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[builtins.float]:
        """
        Hardware raid type (default is 1)
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def spares(self) -> Optional[builtins.float]:
        """
        Number of disks in the disk group involved in the spare (default is 0)
        """
        return pulumi.get(self, "spares")


@pulumi.output_type
class ServerStoragePartitioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemeName":
            suggest = "scheme_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStoragePartitioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStoragePartitioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStoragePartitioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disks: Optional[builtins.float] = None,
                 layouts: Optional[Sequence['outputs.ServerStoragePartitioningLayout']] = None,
                 scheme_name: Optional[builtins.str] = None):
        """
        :param builtins.float disks: Total number of disks in the disk group involved in the partitioning configuration (all disks of the disk group by default)
        :param Sequence['ServerStoragePartitioningLayoutArgs'] layouts: Custom partitioning layout (default is the default layout of the operating system's default partitioning scheme)
        :param builtins.str scheme_name: Partitioning scheme (if applicable with selected operating system)
        """
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if layouts is not None:
            pulumi.set(__self__, "layouts", layouts)
        if scheme_name is not None:
            pulumi.set(__self__, "scheme_name", scheme_name)

    @property
    @pulumi.getter
    def disks(self) -> Optional[builtins.float]:
        """
        Total number of disks in the disk group involved in the partitioning configuration (all disks of the disk group by default)
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def layouts(self) -> Optional[Sequence['outputs.ServerStoragePartitioningLayout']]:
        """
        Custom partitioning layout (default is the default layout of the operating system's default partitioning scheme)
        """
        return pulumi.get(self, "layouts")

    @property
    @pulumi.getter(name="schemeName")
    def scheme_name(self) -> Optional[builtins.str]:
        """
        Partitioning scheme (if applicable with selected operating system)
        """
        return pulumi.get(self, "scheme_name")


@pulumi.output_type
class ServerStoragePartitioningLayout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystem":
            suggest = "file_system"
        elif key == "mountPoint":
            suggest = "mount_point"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStoragePartitioningLayout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStoragePartitioningLayout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStoragePartitioningLayout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system: builtins.str,
                 mount_point: builtins.str,
                 extras: Optional['outputs.ServerStoragePartitioningLayoutExtras'] = None,
                 raid_level: Optional[builtins.float] = None,
                 size: Optional[builtins.float] = None):
        """
        :param builtins.str file_system: File system type
        :param builtins.str mount_point: Mount point
        :param 'ServerStoragePartitioningLayoutExtrasArgs' extras: Partition extras parameters
        :param builtins.float raid_level: Software raid type (default is 1)
        :param builtins.float size: Partition size in MiB (default value is 0 which means to fill the disk with that partition)
        """
        pulumi.set(__self__, "file_system", file_system)
        pulumi.set(__self__, "mount_point", mount_point)
        if extras is not None:
            pulumi.set(__self__, "extras", extras)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> builtins.str:
        """
        File system type
        """
        return pulumi.get(self, "file_system")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> builtins.str:
        """
        Mount point
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter
    def extras(self) -> Optional['outputs.ServerStoragePartitioningLayoutExtras']:
        """
        Partition extras parameters
        """
        return pulumi.get(self, "extras")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[builtins.float]:
        """
        Software raid type (default is 1)
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.float]:
        """
        Partition size in MiB (default value is 0 which means to fill the disk with that partition)
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class ServerStoragePartitioningLayoutExtras(dict):
    def __init__(__self__, *,
                 lv: Optional['outputs.ServerStoragePartitioningLayoutExtrasLv'] = None,
                 zp: Optional['outputs.ServerStoragePartitioningLayoutExtrasZp'] = None):
        """
        :param 'ServerStoragePartitioningLayoutExtrasLvArgs' lv: LVM-specific parameters
        :param 'ServerStoragePartitioningLayoutExtrasZpArgs' zp: ZFS-specific parameters
        """
        if lv is not None:
            pulumi.set(__self__, "lv", lv)
        if zp is not None:
            pulumi.set(__self__, "zp", zp)

    @property
    @pulumi.getter
    def lv(self) -> Optional['outputs.ServerStoragePartitioningLayoutExtrasLv']:
        """
        LVM-specific parameters
        """
        return pulumi.get(self, "lv")

    @property
    @pulumi.getter
    def zp(self) -> Optional['outputs.ServerStoragePartitioningLayoutExtrasZp']:
        """
        ZFS-specific parameters
        """
        return pulumi.get(self, "zp")


@pulumi.output_type
class ServerStoragePartitioningLayoutExtrasLv(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: Dedicated server name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Dedicated server name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerStoragePartitioningLayoutExtrasZp(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: Dedicated server name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Dedicated server name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCloudIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: Unique identifier of the resource
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with ovh:
        :param builtins.str urn: Unique resource name used in policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetCloudVersionResult(dict):
    def __init__(__self__, *,
                 build: builtins.str,
                 major: builtins.str,
                 minor: builtins.str):
        pulumi.set(__self__, "build", build)
        pulumi.set(__self__, "major", major)
        pulumi.set(__self__, "minor", minor)

    @property
    @pulumi.getter
    def build(self) -> builtins.str:
        return pulumi.get(self, "build")

    @property
    @pulumi.getter
    def major(self) -> builtins.str:
        return pulumi.get(self, "major")

    @property
    @pulumi.getter
    def minor(self) -> builtins.str:
        return pulumi.get(self, "minor")


@pulumi.output_type
class GetServerSpecificationsHardwareDefaultHardwareRaidSizeResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsHardwareDiskGroupResult(dict):
    def __init__(__self__, *,
                 default_hardware_raid_size: 'outputs.GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeResult',
                 default_hardware_raid_type: builtins.str,
                 description: builtins.str,
                 disk_group_id: builtins.float,
                 disk_size: 'outputs.GetServerSpecificationsHardwareDiskGroupDiskSizeResult',
                 disk_type: builtins.str,
                 number_of_disks: builtins.float,
                 raid_controller: builtins.str):
        """
        :param 'GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeArgs' default_hardware_raid_size: Default hardware raid size for this disk group
        :param builtins.str default_hardware_raid_type: Default hardware raid type for this disk group
        :param builtins.str description: Expansion card description
        :param builtins.float disk_group_id: Identifier of this disk group
        :param 'GetServerSpecificationsHardwareDiskGroupDiskSizeArgs' disk_size: Disk capacity
        :param builtins.str disk_type: Type of the disk (SSD, SATA, SAS, ...)
        :param builtins.float number_of_disks: Number of disks in this group
        :param builtins.str raid_controller: Raid controller, if any, managing this group of disks
        """
        pulumi.set(__self__, "default_hardware_raid_size", default_hardware_raid_size)
        pulumi.set(__self__, "default_hardware_raid_type", default_hardware_raid_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk_group_id", disk_group_id)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "raid_controller", raid_controller)

    @property
    @pulumi.getter(name="defaultHardwareRaidSize")
    def default_hardware_raid_size(self) -> 'outputs.GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeResult':
        """
        Default hardware raid size for this disk group
        """
        return pulumi.get(self, "default_hardware_raid_size")

    @property
    @pulumi.getter(name="defaultHardwareRaidType")
    def default_hardware_raid_type(self) -> builtins.str:
        """
        Default hardware raid type for this disk group
        """
        return pulumi.get(self, "default_hardware_raid_type")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Expansion card description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskGroupId")
    def disk_group_id(self) -> builtins.float:
        """
        Identifier of this disk group
        """
        return pulumi.get(self, "disk_group_id")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> 'outputs.GetServerSpecificationsHardwareDiskGroupDiskSizeResult':
        """
        Disk capacity
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> builtins.str:
        """
        Type of the disk (SSD, SATA, SAS, ...)
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> builtins.float:
        """
        Number of disks in this group
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter(name="raidController")
    def raid_controller(self) -> builtins.str:
        """
        Raid controller, if any, managing this group of disks
        """
        return pulumi.get(self, "raid_controller")


@pulumi.output_type
class GetServerSpecificationsHardwareDiskGroupDefaultHardwareRaidSizeResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsHardwareDiskGroupDiskSizeResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsHardwareExpansionCardResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str description: Expansion card description
        :param builtins.str type: Expansion card type enum
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Expansion card description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Expansion card type enum
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerSpecificationsHardwareMemorySizeResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsHardwareUsbKeyResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkBandwidthResult(dict):
    def __init__(__self__, *,
                 internet_to_ovh: 'outputs.GetServerSpecificationsNetworkBandwidthInternetToOvhResult',
                 ovh_to_internet: 'outputs.GetServerSpecificationsNetworkBandwidthOvhToInternetResult',
                 ovh_to_ovh: 'outputs.GetServerSpecificationsNetworkBandwidthOvhToOvhResult',
                 type: builtins.str):
        """
        :param 'GetServerSpecificationsNetworkBandwidthInternetToOvhArgs' internet_to_ovh: Bandwidth limitation Internet to OVH
        :param 'GetServerSpecificationsNetworkBandwidthOvhToInternetArgs' ovh_to_internet: Bandwidth limitation OVH to Internet
        :param 'GetServerSpecificationsNetworkBandwidthOvhToOvhArgs' ovh_to_ovh: Bandwidth limitation OVH to OVH
        :param builtins.str type: Bandwidth offer type (included┃standard)
        """
        pulumi.set(__self__, "internet_to_ovh", internet_to_ovh)
        pulumi.set(__self__, "ovh_to_internet", ovh_to_internet)
        pulumi.set(__self__, "ovh_to_ovh", ovh_to_ovh)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="internetToOvh")
    def internet_to_ovh(self) -> 'outputs.GetServerSpecificationsNetworkBandwidthInternetToOvhResult':
        """
        Bandwidth limitation Internet to OVH
        """
        return pulumi.get(self, "internet_to_ovh")

    @property
    @pulumi.getter(name="ovhToInternet")
    def ovh_to_internet(self) -> 'outputs.GetServerSpecificationsNetworkBandwidthOvhToInternetResult':
        """
        Bandwidth limitation OVH to Internet
        """
        return pulumi.get(self, "ovh_to_internet")

    @property
    @pulumi.getter(name="ovhToOvh")
    def ovh_to_ovh(self) -> 'outputs.GetServerSpecificationsNetworkBandwidthOvhToOvhResult':
        """
        Bandwidth limitation OVH to OVH
        """
        return pulumi.get(self, "ovh_to_ovh")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Bandwidth offer type (included┃standard)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerSpecificationsNetworkBandwidthInternetToOvhResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkBandwidthOvhToInternetResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkBandwidthOvhToOvhResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkConnectionValResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkOlaResult(dict):
    def __init__(__self__, *,
                 available: builtins.bool,
                 available_modes: Sequence['outputs.GetServerSpecificationsNetworkOlaAvailableModeResult'],
                 supported_modes: Sequence[builtins.str]):
        """
        :param builtins.bool available: Is the OLA feature available
        :param Sequence['GetServerSpecificationsNetworkOlaAvailableModeArgs'] available_modes: Supported modes
        :param Sequence[builtins.str] supported_modes: Supported modes (DEPRECATED)
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "available_modes", available_modes)
        pulumi.set(__self__, "supported_modes", supported_modes)

    @property
    @pulumi.getter
    def available(self) -> builtins.bool:
        """
        Is the OLA feature available
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter(name="availableModes")
    def available_modes(self) -> Sequence['outputs.GetServerSpecificationsNetworkOlaAvailableModeResult']:
        """
        Supported modes
        """
        return pulumi.get(self, "available_modes")

    @property
    @pulumi.getter(name="supportedModes")
    def supported_modes(self) -> Sequence[builtins.str]:
        """
        Supported modes (DEPRECATED)
        """
        return pulumi.get(self, "supported_modes")


@pulumi.output_type
class GetServerSpecificationsNetworkOlaAvailableModeResult(dict):
    def __init__(__self__, *,
                 default: builtins.bool,
                 interfaces: Sequence['outputs.GetServerSpecificationsNetworkOlaAvailableModeInterfaceResult'],
                 name: builtins.str):
        """
        :param builtins.bool default: Whether it is the default configuration of the server
        :param Sequence['GetServerSpecificationsNetworkOlaAvailableModeInterfaceArgs'] interfaces: Interface layout
        :param builtins.str name: Switch name
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "interfaces", interfaces)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def default(self) -> builtins.bool:
        """
        Whether it is the default configuration of the server
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetServerSpecificationsNetworkOlaAvailableModeInterfaceResult']:
        """
        Interface layout
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Switch name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServerSpecificationsNetworkOlaAvailableModeInterfaceResult(dict):
    def __init__(__self__, *,
                 aggregation: builtins.bool,
                 count: builtins.float,
                 type: builtins.str):
        """
        :param builtins.bool aggregation: Interface aggregation status
        :param builtins.float count: Interface count
        :param builtins.str type: Bandwidth offer type (included┃standard)
        """
        pulumi.set(__self__, "aggregation", aggregation)
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def aggregation(self) -> builtins.bool:
        """
        Interface aggregation status
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def count(self) -> builtins.float:
        """
        Interface count
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Bandwidth offer type (included┃standard)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerSpecificationsNetworkRoutingResult(dict):
    def __init__(__self__, *,
                 ipv4: 'outputs.GetServerSpecificationsNetworkRoutingIpv4Result',
                 ipv6: 'outputs.GetServerSpecificationsNetworkRoutingIpv6Result'):
        """
        :param 'GetServerSpecificationsNetworkRoutingIpv4Args' ipv4: Ipv4 routing details
        :param 'GetServerSpecificationsNetworkRoutingIpv6Args' ipv6: Ipv6 routing details
        """
        pulumi.set(__self__, "ipv4", ipv4)
        pulumi.set(__self__, "ipv6", ipv6)

    @property
    @pulumi.getter
    def ipv4(self) -> 'outputs.GetServerSpecificationsNetworkRoutingIpv4Result':
        """
        Ipv4 routing details
        """
        return pulumi.get(self, "ipv4")

    @property
    @pulumi.getter
    def ipv6(self) -> 'outputs.GetServerSpecificationsNetworkRoutingIpv6Result':
        """
        Ipv6 routing details
        """
        return pulumi.get(self, "ipv6")


@pulumi.output_type
class GetServerSpecificationsNetworkRoutingIpv4Result(dict):
    def __init__(__self__, *,
                 gateway: builtins.str,
                 ip: builtins.str,
                 network: builtins.str):
        """
        :param builtins.str gateway: Server gateway
        :param builtins.str ip: Server main IP
        :param builtins.str network: Server network
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def gateway(self) -> builtins.str:
        """
        Server gateway
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        Server main IP
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        """
        Server network
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class GetServerSpecificationsNetworkRoutingIpv6Result(dict):
    def __init__(__self__, *,
                 gateway: builtins.str,
                 ip: builtins.str,
                 network: builtins.str):
        """
        :param builtins.str gateway: Server gateway
        :param builtins.str ip: Server main IP
        :param builtins.str network: Server network
        """
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def gateway(self) -> builtins.str:
        """
        Server gateway
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        Server main IP
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def network(self) -> builtins.str:
        """
        Server network
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class GetServerSpecificationsNetworkSwitchingResult(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: Switch name
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Switch name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficResult(dict):
    def __init__(__self__, *,
                 input_quota_size: 'outputs.GetServerSpecificationsNetworkTrafficInputQuotaSizeResult',
                 input_quota_used: 'outputs.GetServerSpecificationsNetworkTrafficInputQuotaUsedResult',
                 is_throttled: builtins.bool,
                 output_quota_size: 'outputs.GetServerSpecificationsNetworkTrafficOutputQuotaSizeResult',
                 output_quota_used: 'outputs.GetServerSpecificationsNetworkTrafficOutputQuotaUsedResult',
                 reset_quota_date: builtins.str):
        """
        :param 'GetServerSpecificationsNetworkTrafficInputQuotaSizeArgs' input_quota_size: Monthly input traffic quota allowed
        :param 'GetServerSpecificationsNetworkTrafficInputQuotaUsedArgs' input_quota_used: Monthly input traffic consumed this month
        :param builtins.bool is_throttled: Whether bandwidth is throttleted for being over quota
        :param 'GetServerSpecificationsNetworkTrafficOutputQuotaSizeArgs' output_quota_size: Monthly output traffic quota allowed
        :param 'GetServerSpecificationsNetworkTrafficOutputQuotaUsedArgs' output_quota_used: Monthly output traffic consumed this month
        :param builtins.str reset_quota_date: Next reset quota date for traffic counter
        """
        pulumi.set(__self__, "input_quota_size", input_quota_size)
        pulumi.set(__self__, "input_quota_used", input_quota_used)
        pulumi.set(__self__, "is_throttled", is_throttled)
        pulumi.set(__self__, "output_quota_size", output_quota_size)
        pulumi.set(__self__, "output_quota_used", output_quota_used)
        pulumi.set(__self__, "reset_quota_date", reset_quota_date)

    @property
    @pulumi.getter(name="inputQuotaSize")
    def input_quota_size(self) -> 'outputs.GetServerSpecificationsNetworkTrafficInputQuotaSizeResult':
        """
        Monthly input traffic quota allowed
        """
        return pulumi.get(self, "input_quota_size")

    @property
    @pulumi.getter(name="inputQuotaUsed")
    def input_quota_used(self) -> 'outputs.GetServerSpecificationsNetworkTrafficInputQuotaUsedResult':
        """
        Monthly input traffic consumed this month
        """
        return pulumi.get(self, "input_quota_used")

    @property
    @pulumi.getter(name="isThrottled")
    def is_throttled(self) -> builtins.bool:
        """
        Whether bandwidth is throttleted for being over quota
        """
        return pulumi.get(self, "is_throttled")

    @property
    @pulumi.getter(name="outputQuotaSize")
    def output_quota_size(self) -> 'outputs.GetServerSpecificationsNetworkTrafficOutputQuotaSizeResult':
        """
        Monthly output traffic quota allowed
        """
        return pulumi.get(self, "output_quota_size")

    @property
    @pulumi.getter(name="outputQuotaUsed")
    def output_quota_used(self) -> 'outputs.GetServerSpecificationsNetworkTrafficOutputQuotaUsedResult':
        """
        Monthly output traffic consumed this month
        """
        return pulumi.get(self, "output_quota_used")

    @property
    @pulumi.getter(name="resetQuotaDate")
    def reset_quota_date(self) -> builtins.str:
        """
        Next reset quota date for traffic counter
        """
        return pulumi.get(self, "reset_quota_date")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficInputQuotaSizeResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficInputQuotaUsedResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficOutputQuotaSizeResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkTrafficOutputQuotaUsedResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServerSpecificationsNetworkVmacResult(dict):
    def __init__(__self__, *,
                 supported: builtins.bool):
        """
        :param builtins.bool supported: Whether server is compatible vmac
        """
        pulumi.set(__self__, "supported", supported)

    @property
    @pulumi.getter
    def supported(self) -> builtins.bool:
        """
        Whether server is compatible vmac
        """
        return pulumi.get(self, "supported")


@pulumi.output_type
class GetServerSpecificationsNetworkVrackResult(dict):
    def __init__(__self__, *,
                 bandwidth: 'outputs.GetServerSpecificationsNetworkVrackBandwidthResult',
                 type: builtins.str):
        """
        :param 'GetServerSpecificationsNetworkVrackBandwidthArgs' bandwidth: vrack bandwidth limitation
        :param builtins.str type: Bandwidth offer type (included┃standard)
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bandwidth(self) -> 'outputs.GetServerSpecificationsNetworkVrackBandwidthResult':
        """
        vrack bandwidth limitation
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Bandwidth offer type (included┃standard)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerSpecificationsNetworkVrackBandwidthResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.float:
        return pulumi.get(self, "value")


