# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DynhostLoginArgs', 'DynhostLogin']

@pulumi.input_type
class DynhostLoginArgs:
    def __init__(__self__, *,
                 login_suffix: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 sub_domain: pulumi.Input[builtins.str],
                 zone_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a DynhostLogin resource.
        :param pulumi.Input[builtins.str] login_suffix: Suffix that will be concatenated to the zoneName to create the login
        :param pulumi.Input[builtins.str] password: Password of the login
        :param pulumi.Input[builtins.str] sub_domain: Subdomain that the login will be allowed to update (use * to allow all)
        :param pulumi.Input[builtins.str] zone_name: Zone name
        """
        pulumi.set(__self__, "login_suffix", login_suffix)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "sub_domain", sub_domain)
        pulumi.set(__self__, "zone_name", zone_name)

    @property
    @pulumi.getter(name="loginSuffix")
    def login_suffix(self) -> pulumi.Input[builtins.str]:
        """
        Suffix that will be concatenated to the zoneName to create the login
        """
        return pulumi.get(self, "login_suffix")

    @login_suffix.setter
    def login_suffix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "login_suffix", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        Password of the login
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> pulumi.Input[builtins.str]:
        """
        Subdomain that the login will be allowed to update (use * to allow all)
        """
        return pulumi.get(self, "sub_domain")

    @sub_domain.setter
    def sub_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sub_domain", value)

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Input[builtins.str]:
        """
        Zone name
        """
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_name", value)


@pulumi.input_type
class _DynhostLoginState:
    def __init__(__self__, *,
                 login: Optional[pulumi.Input[builtins.str]] = None,
                 login_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DynhostLogin resources.
        :param pulumi.Input[builtins.str] login: Login name
        :param pulumi.Input[builtins.str] login_suffix: Suffix that will be concatenated to the zoneName to create the login
        :param pulumi.Input[builtins.str] password: Password of the login
        :param pulumi.Input[builtins.str] sub_domain: Subdomain that the login will be allowed to update (use * to allow all)
        :param pulumi.Input[builtins.str] zone: Login zone
        :param pulumi.Input[builtins.str] zone_name: Zone name
        """
        if login is not None:
            pulumi.set(__self__, "login", login)
        if login_suffix is not None:
            pulumi.set(__self__, "login_suffix", login_suffix)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if sub_domain is not None:
            pulumi.set(__self__, "sub_domain", sub_domain)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)
        if zone_name is not None:
            pulumi.set(__self__, "zone_name", zone_name)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Login name
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter(name="loginSuffix")
    def login_suffix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Suffix that will be concatenated to the zoneName to create the login
        """
        return pulumi.get(self, "login_suffix")

    @login_suffix.setter
    def login_suffix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_suffix", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password of the login
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subdomain that the login will be allowed to update (use * to allow all)
        """
        return pulumi.get(self, "sub_domain")

    @sub_domain.setter
    def sub_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sub_domain", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Login zone
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Zone name
        """
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_name", value)


@pulumi.type_token("ovh:Domain/dynhostLogin:DynhostLogin")
class DynhostLogin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a dynhost login for a given domain zone.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        dynhost_user = ovh.domain.DynhostLogin("dynhost_user",
            zone_name="mydomain.ovh",
            sub_domain="dynhost",
            login_suffix="dynhostUser",
            password="thisIsMyPassword")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] login_suffix: Suffix that will be concatenated to the zoneName to create the login
        :param pulumi.Input[builtins.str] password: Password of the login
        :param pulumi.Input[builtins.str] sub_domain: Subdomain that the login will be allowed to update (use * to allow all)
        :param pulumi.Input[builtins.str] zone_name: Zone name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DynhostLoginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a dynhost login for a given domain zone.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        dynhost_user = ovh.domain.DynhostLogin("dynhost_user",
            zone_name="mydomain.ovh",
            sub_domain="dynhost",
            login_suffix="dynhostUser",
            password="thisIsMyPassword")
        ```

        :param str resource_name: The name of the resource.
        :param DynhostLoginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DynhostLoginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DynhostLoginArgs.__new__(DynhostLoginArgs)

            if login_suffix is None and not opts.urn:
                raise TypeError("Missing required property 'login_suffix'")
            __props__.__dict__["login_suffix"] = login_suffix
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if sub_domain is None and not opts.urn:
                raise TypeError("Missing required property 'sub_domain'")
            __props__.__dict__["sub_domain"] = sub_domain
            if zone_name is None and not opts.urn:
                raise TypeError("Missing required property 'zone_name'")
            __props__.__dict__["zone_name"] = zone_name
            __props__.__dict__["login"] = None
            __props__.__dict__["zone"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DynhostLogin, __self__).__init__(
            'ovh:Domain/dynhostLogin:DynhostLogin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            login: Optional[pulumi.Input[builtins.str]] = None,
            login_suffix: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            sub_domain: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None,
            zone_name: Optional[pulumi.Input[builtins.str]] = None) -> 'DynhostLogin':
        """
        Get an existing DynhostLogin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] login: Login name
        :param pulumi.Input[builtins.str] login_suffix: Suffix that will be concatenated to the zoneName to create the login
        :param pulumi.Input[builtins.str] password: Password of the login
        :param pulumi.Input[builtins.str] sub_domain: Subdomain that the login will be allowed to update (use * to allow all)
        :param pulumi.Input[builtins.str] zone: Login zone
        :param pulumi.Input[builtins.str] zone_name: Zone name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DynhostLoginState.__new__(_DynhostLoginState)

        __props__.__dict__["login"] = login
        __props__.__dict__["login_suffix"] = login_suffix
        __props__.__dict__["password"] = password
        __props__.__dict__["sub_domain"] = sub_domain
        __props__.__dict__["zone"] = zone
        __props__.__dict__["zone_name"] = zone_name
        return DynhostLogin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def login(self) -> pulumi.Output[builtins.str]:
        """
        Login name
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter(name="loginSuffix")
    def login_suffix(self) -> pulumi.Output[builtins.str]:
        """
        Suffix that will be concatenated to the zoneName to create the login
        """
        return pulumi.get(self, "login_suffix")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        Password of the login
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> pulumi.Output[builtins.str]:
        """
        Subdomain that the login will be allowed to update (use * to allow all)
        """
        return pulumi.get(self, "sub_domain")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        Login zone
        """
        return pulumi.get(self, "zone")

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Output[builtins.str]:
        """
        Zone name
        """
        return pulumi.get(self, "zone_name")

