# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetZoneDNSSecResult',
    'AwaitableGetZoneDNSSecResult',
    'get_zone_dns_sec',
    'get_zone_dns_sec_output',
]

@pulumi.output_type
class GetZoneDNSSecResult:
    """
    A collection of values returned by getZoneDNSSec.
    """
    def __init__(__self__, id=None, status=None, zone_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if zone_name and not isinstance(zone_name, str):
            raise TypeError("Expected argument 'zone_name' to be a str")
        pulumi.set(__self__, "zone_name", zone_name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        DNSSEC status (`disableInProgress`, `disabled`, `enableInProgress` or `enabled`)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> builtins.str:
        return pulumi.get(self, "zone_name")


class AwaitableGetZoneDNSSecResult(GetZoneDNSSecResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneDNSSecResult(
            id=self.id,
            status=self.status,
            zone_name=self.zone_name)


def get_zone_dns_sec(zone_name: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneDNSSecResult:
    """
    Use this data source to retrieve information about a domain zone DNSSEC status.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    dnssec = ovh.Domain.get_zone_dns_sec(zone_name="mysite.ovh")
    ```


    :param builtins.str zone_name: The name of the domain zone
    """
    __args__ = dict()
    __args__['zoneName'] = zone_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Domain/getZoneDNSSec:getZoneDNSSec', __args__, opts=opts, typ=GetZoneDNSSecResult).value

    return AwaitableGetZoneDNSSecResult(
        id=pulumi.get(__ret__, 'id'),
        status=pulumi.get(__ret__, 'status'),
        zone_name=pulumi.get(__ret__, 'zone_name'))
def get_zone_dns_sec_output(zone_name: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneDNSSecResult]:
    """
    Use this data source to retrieve information about a domain zone DNSSEC status.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    dnssec = ovh.Domain.get_zone_dns_sec(zone_name="mysite.ovh")
    ```


    :param builtins.str zone_name: The name of the domain zone
    """
    __args__ = dict()
    __args__['zoneName'] = zone_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Domain/getZoneDNSSec:getZoneDNSSec', __args__, opts=opts, typ=GetZoneDNSSecResult)
    return __ret__.apply(lambda __response__: GetZoneDNSSecResult(
        id=pulumi.get(__response__, 'id'),
        status=pulumi.get(__response__, 'status'),
        zone_name=pulumi.get(__response__, 'zone_name')))
