# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCloudProjectFlavorResult',
    'AwaitableGetCloudProjectFlavorResult',
    'get_cloud_project_flavor',
    'get_cloud_project_flavor_output',
]

@pulumi.output_type
class GetCloudProjectFlavorResult:
    """
    A collection of values returned by getCloudProjectFlavor.
    """
    def __init__(__self__, available=None, capabilities=None, disk=None, id=None, inbound_bandwidth=None, name=None, os_type=None, outbound_bandwidth=None, plan_codes=None, quota=None, ram=None, region=None, service_name=None, type=None, vcpus=None):
        if available and not isinstance(available, bool):
            raise TypeError("Expected argument 'available' to be a bool")
        pulumi.set(__self__, "available", available)
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if disk and not isinstance(disk, float):
            raise TypeError("Expected argument 'disk' to be a float")
        pulumi.set(__self__, "disk", disk)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inbound_bandwidth and not isinstance(inbound_bandwidth, float):
            raise TypeError("Expected argument 'inbound_bandwidth' to be a float")
        pulumi.set(__self__, "inbound_bandwidth", inbound_bandwidth)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_type and not isinstance(os_type, str):
            raise TypeError("Expected argument 'os_type' to be a str")
        pulumi.set(__self__, "os_type", os_type)
        if outbound_bandwidth and not isinstance(outbound_bandwidth, float):
            raise TypeError("Expected argument 'outbound_bandwidth' to be a float")
        pulumi.set(__self__, "outbound_bandwidth", outbound_bandwidth)
        if plan_codes and not isinstance(plan_codes, dict):
            raise TypeError("Expected argument 'plan_codes' to be a dict")
        pulumi.set(__self__, "plan_codes", plan_codes)
        if quota and not isinstance(quota, float):
            raise TypeError("Expected argument 'quota' to be a float")
        pulumi.set(__self__, "quota", quota)
        if ram and not isinstance(ram, float):
            raise TypeError("Expected argument 'ram' to be a float")
        pulumi.set(__self__, "ram", ram)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vcpus and not isinstance(vcpus, float):
            raise TypeError("Expected argument 'vcpus' to be a float")
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter
    def available(self) -> builtins.bool:
        """
        Available in stock
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.GetCloudProjectFlavorCapabilityResult']:
        """
        Capabilities of the flavor
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def disk(self) -> builtins.float:
        """
        Number of disks
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Flavor id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inboundBandwidth")
    def inbound_bandwidth(self) -> builtins.float:
        """
        Max capacity of inbound traffic in Mbit/s
        """
        return pulumi.get(self, "inbound_bandwidth")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Flavor name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> builtins.str:
        """
        OS to install on
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="outboundBandwidth")
    def outbound_bandwidth(self) -> builtins.float:
        """
        Max capacity of outbound traffic in Mbit/s
        """
        return pulumi.get(self, "outbound_bandwidth")

    @property
    @pulumi.getter(name="planCodes")
    def plan_codes(self) -> 'outputs.GetCloudProjectFlavorPlanCodesResult':
        """
        Plan codes to order instances
        """
        return pulumi.get(self, "plan_codes")

    @property
    @pulumi.getter
    def quota(self) -> builtins.float:
        """
        Number instance you can spawn with your actual quota
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter
    def ram(self) -> builtins.float:
        """
        Ram quantity (Gio)
        """
        return pulumi.get(self, "ram")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Flavor region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Flavor type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vcpus(self) -> builtins.float:
        """
        Number of VCPUs
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetCloudProjectFlavorResult(GetCloudProjectFlavorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudProjectFlavorResult(
            available=self.available,
            capabilities=self.capabilities,
            disk=self.disk,
            id=self.id,
            inbound_bandwidth=self.inbound_bandwidth,
            name=self.name,
            os_type=self.os_type,
            outbound_bandwidth=self.outbound_bandwidth,
            plan_codes=self.plan_codes,
            quota=self.quota,
            ram=self.ram,
            region=self.region,
            service_name=self.service_name,
            type=self.type,
            vcpus=self.vcpus)


def get_cloud_project_flavor(id: Optional[builtins.str] = None,
                             service_name: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudProjectFlavorResult:
    """
    Retrieves the given flavor in a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    flavor = ovh.get_cloud_project_flavor(service_name="YYYY",
        id="XXXX")
    ```


    :param builtins.str id: Flavor id
    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getCloudProjectFlavor:getCloudProjectFlavor', __args__, opts=opts, typ=GetCloudProjectFlavorResult).value

    return AwaitableGetCloudProjectFlavorResult(
        available=pulumi.get(__ret__, 'available'),
        capabilities=pulumi.get(__ret__, 'capabilities'),
        disk=pulumi.get(__ret__, 'disk'),
        id=pulumi.get(__ret__, 'id'),
        inbound_bandwidth=pulumi.get(__ret__, 'inbound_bandwidth'),
        name=pulumi.get(__ret__, 'name'),
        os_type=pulumi.get(__ret__, 'os_type'),
        outbound_bandwidth=pulumi.get(__ret__, 'outbound_bandwidth'),
        plan_codes=pulumi.get(__ret__, 'plan_codes'),
        quota=pulumi.get(__ret__, 'quota'),
        ram=pulumi.get(__ret__, 'ram'),
        region=pulumi.get(__ret__, 'region'),
        service_name=pulumi.get(__ret__, 'service_name'),
        type=pulumi.get(__ret__, 'type'),
        vcpus=pulumi.get(__ret__, 'vcpus'))
def get_cloud_project_flavor_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                    service_name: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudProjectFlavorResult]:
    """
    Retrieves the given flavor in a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    flavor = ovh.get_cloud_project_flavor(service_name="YYYY",
        id="XXXX")
    ```


    :param builtins.str id: Flavor id
    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:index/getCloudProjectFlavor:getCloudProjectFlavor', __args__, opts=opts, typ=GetCloudProjectFlavorResult)
    return __ret__.apply(lambda __response__: GetCloudProjectFlavorResult(
        available=pulumi.get(__response__, 'available'),
        capabilities=pulumi.get(__response__, 'capabilities'),
        disk=pulumi.get(__response__, 'disk'),
        id=pulumi.get(__response__, 'id'),
        inbound_bandwidth=pulumi.get(__response__, 'inbound_bandwidth'),
        name=pulumi.get(__response__, 'name'),
        os_type=pulumi.get(__response__, 'os_type'),
        outbound_bandwidth=pulumi.get(__response__, 'outbound_bandwidth'),
        plan_codes=pulumi.get(__response__, 'plan_codes'),
        quota=pulumi.get(__response__, 'quota'),
        ram=pulumi.get(__response__, 'ram'),
        region=pulumi.get(__response__, 'region'),
        service_name=pulumi.get(__response__, 'service_name'),
        type=pulumi.get(__response__, 'type'),
        vcpus=pulumi.get(__response__, 'vcpus')))
